/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.importers;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.CharMatcher;
import com.google.refine.ProjectMetadata;
import com.google.refine.expr.ExpressionUtils;
import com.google.refine.importers.ImporterUtilities;
import com.google.refine.importers.ImportingParserBase;
import com.google.refine.importing.ImportingJob;
import com.google.refine.model.Cell;
import com.google.refine.model.Column;
import com.google.refine.model.ModelException;
import com.google.refine.model.Project;
import com.google.refine.model.Row;
import com.google.refine.util.JSONUtilities;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public abstract class TabularImportingParserBase
extends ImportingParserBase {
    @Override
    public ObjectNode createParserUIInitializationData(ImportingJob job, List<ObjectNode> fileRecords, String format) {
        ObjectNode options = super.createParserUIInitializationData(job, fileRecords, format);
        JSONUtilities.safePut(options, "ignoreLines", -1L);
        JSONUtilities.safePut(options, "headerLines", 1L);
        JSONUtilities.safePut(options, "skipDataLines", 0L);
        JSONUtilities.safePut(options, "storeBlankRows", true);
        JSONUtilities.safePut(options, "storeBlankColumns", true);
        JSONUtilities.safePut(options, "storeBlankCellsAsNulls", true);
        return options;
    }

    protected TabularImportingParserBase(boolean useInputStream) {
        super(useInputStream);
    }

    @Deprecated
    public static void readTable(Project project, ProjectMetadata metadata, ImportingJob job, TableDataReader reader, String fileSource, int limit, ObjectNode options, List<Exception> exceptions) {
        TabularImportingParserBase.readTable(project, job, reader, limit, options, exceptions);
    }

    public static void readTable(Project project, ImportingJob job, TableDataReader reader, int limit, ObjectNode options, List<Exception> exceptions) {
        int ignoreLines = JSONUtilities.getInt((JsonNode)options, "ignoreLines", -1);
        int headerLines = JSONUtilities.getInt((JsonNode)options, "headerLines", 1);
        int skipDataLines = JSONUtilities.getInt((JsonNode)options, "skipDataLines", 0);
        int limit2 = JSONUtilities.getInt((JsonNode)options, "limit", -1);
        if (limit > 0) {
            limit2 = limit2 > 0 ? Math.min(limit, limit2) : limit;
        }
        boolean guessCellValueTypes = JSONUtilities.getBoolean((JsonNode)options, "guessCellValueTypes", false);
        boolean storeBlankColumns = JSONUtilities.getBoolean((JsonNode)options, "storeBlankColumns", true);
        boolean storeBlankRows = JSONUtilities.getBoolean((JsonNode)options, "storeBlankRows", true);
        boolean storeBlankCellsAsNulls = JSONUtilities.getBoolean((JsonNode)options, "storeBlankCellsAsNulls", true);
        boolean trimStrings = JSONUtilities.getBoolean((JsonNode)options, "trimStrings", false);
        ArrayList<String> columnNames = new ArrayList<String>();
        boolean hasOurOwnColumnNames = headerLines > 0;
        ArrayList<Boolean> columnsHasData = new ArrayList<Boolean>();
        List<Object> cells = null;
        int rowsWithData = 0;
        try {
            while (!job.canceled && (cells = reader.getNextRowOfCells()) != null) {
                if (ignoreLines > 0) {
                    --ignoreLines;
                    continue;
                }
                if (headerLines > 0) {
                    for (int c = 0; c < cells.size(); ++c) {
                        Object cell = cells.get(c);
                        String columnName = cell == null ? "" : (cell instanceof Cell ? CharMatcher.whitespace().trimFrom((CharSequence)((Cell)cell).value.toString()) : CharMatcher.whitespace().trimFrom((CharSequence)cell.toString()));
                        ImporterUtilities.appendColumnName(columnNames, c, columnName);
                    }
                    if (--headerLines != 0) continue;
                    ImporterUtilities.setupColumns(project, columnNames);
                    continue;
                }
                Row row = new Row(cells.size());
                if (storeBlankRows || cells.size() > 0) {
                    ++rowsWithData;
                }
                if (skipDataLines > 0 && rowsWithData <= skipDataLines) continue;
                boolean rowHasData = false;
                for (int c = 0; c < cells.size(); ++c) {
                    Column column = ImporterUtilities.getOrAllocateColumn(project, columnNames, c, hasOurOwnColumnNames);
                    int cellIndex = column.getCellIndex();
                    while (cellIndex >= columnsHasData.size()) {
                        columnsHasData.add(false);
                    }
                    Object value = cells.get(c);
                    if (value instanceof Cell) {
                        row.setCell(cellIndex, (Cell)value);
                        rowHasData = true;
                        columnsHasData.set(cellIndex, true);
                        continue;
                    }
                    if (ExpressionUtils.isNonBlankData(value)) {
                        Object storedValue;
                        if (value instanceof String) {
                            if (trimStrings) {
                                value = CharMatcher.whitespace().trimFrom((CharSequence)((String)value));
                            }
                            storedValue = guessCellValueTypes ? ImporterUtilities.parseCellValue((String)value) : (String)value;
                        } else {
                            storedValue = ExpressionUtils.wrapStorable(value);
                        }
                        row.setCell(cellIndex, new Cell((Serializable)storedValue, null));
                        rowHasData = true;
                        columnsHasData.set(cellIndex, true);
                        continue;
                    }
                    if (!storeBlankCellsAsNulls) {
                        row.setCell(cellIndex, new Cell((Serializable)((Object)""), null));
                        continue;
                    }
                    row.setCell(cellIndex, null);
                }
                if (rowHasData || storeBlankRows) {
                    project.rows.add(row);
                }
                if (limit2 <= 0 || project.rows.size() < limit2) continue;
                break;
            }
            if (!storeBlankColumns) {
                TabularImportingParserBase.deleteEmptyColumns(columnsHasData, project);
            }
        }
        catch (IOException e) {
            exceptions.add(e);
        }
        catch (ModelException e) {
            exceptions.add(e);
        }
    }

    public static void deleteEmptyColumns(List<Boolean> columnsHasData, Project project) throws ModelException {
        project.columnModel.update();
        for (int c = 0; c < columnsHasData.size(); ++c) {
            if (columnsHasData.get(c).booleanValue()) continue;
            project.columnModel.removeColumnByCellIndex(c);
        }
        project.columnModel.update();
    }

    public static interface TableDataReader {
        public List<Object> getNextRowOfCells() throws IOException;
    }
}

