/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.importers;

import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.CharMatcher;
import com.google.refine.importing.ImportingJob;
import com.google.refine.importing.ImportingUtilities;
import com.google.refine.messages.OpenRefineMessage;
import com.google.refine.model.Column;
import com.google.refine.model.ModelException;
import com.google.refine.model.Project;
import com.google.refine.model.Row;
import com.google.refine.util.TrackingInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;

public class ImporterUtilities {
    public static Serializable parseCellValue(String text) {
        String text2;
        if (text.length() > 0 && (text2 = CharMatcher.whitespace().trimFrom((CharSequence)text)).length() > 0) {
            try {
                return Long.valueOf(Long.parseLong(text2));
            }
            catch (NumberFormatException numberFormatException) {
                try {
                    double d = Double.parseDouble(text2);
                    if (!Double.isInfinite(d) && !Double.isNaN(d)) {
                        return Double.valueOf(d);
                    }
                }
                catch (NumberFormatException numberFormatException2) {
                    // empty catch block
                }
            }
        }
        return text;
    }

    public static int getIntegerOption(String name, Properties options, int def) {
        String s;
        int value = def;
        if (options.containsKey(name) && (s = options.getProperty(name)) != null) {
            try {
                value = Integer.parseInt(s);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return value;
    }

    public static boolean getBooleanOption(String name, Properties options, boolean def) {
        String s;
        boolean value = def;
        if (options.containsKey(name) && (s = options.getProperty(name)) != null) {
            value = "on".equalsIgnoreCase(s) || "1".equals(s) || Boolean.parseBoolean(s);
        }
        return value;
    }

    public static void appendColumnName(List<String> columnNames, int index, String name) {
        name = CharMatcher.whitespace().trimFrom((CharSequence)name);
        while (columnNames.size() <= index) {
            columnNames.add("");
        }
        if (!((String)name).isEmpty()) {
            String oldName = columnNames.get(index);
            if (!oldName.isEmpty()) {
                name = oldName + " " + (String)name;
            }
            columnNames.set(index, (String)name);
        }
    }

    public static void ensureColumnsInRowExist(List<String> columnNames, Row row) {
        int count = row.cells.size();
        while (count > columnNames.size()) {
            columnNames.add("");
        }
    }

    public static Column getOrAllocateColumn(Project project, List<String> currentFileColumnNames, int index, boolean hasOurOwnColumnNames) {
        if (index < currentFileColumnNames.size()) {
            return project.columnModel.getColumnByName(currentFileColumnNames.get(index));
        }
        if (index >= currentFileColumnNames.size()) {
            String columnName;
            Column column;
            String prefix = OpenRefineMessage.importer_utilities_column() + " ";
            int i = index + 1;
            while ((column = project.columnModel.getColumnByName(columnName = prefix + i)) != null) {
                if (hasOurOwnColumnNames) {
                    ++i;
                    continue;
                }
                if (!currentFileColumnNames.contains(columnName)) {
                    currentFileColumnNames.add(columnName);
                }
                return column;
            }
            column = new Column(project.columnModel.allocateNewCellIndex(), columnName);
            try {
                project.columnModel.addColumn(-1, column, false);
            }
            catch (ModelException modelException) {
                // empty catch block
            }
            currentFileColumnNames.add(columnName);
            return column;
        }
        throw new RuntimeException("Unexpected code path");
    }

    public static void setupColumns(Project project, List<String> columnNames) {
        HashMap<String, Integer> nameToIndex = new HashMap<String, Integer>();
        for (int c = 0; c < columnNames.size(); ++c) {
            Object cell = CharMatcher.whitespace().trimFrom((CharSequence)columnNames.get(c));
            if (((String)cell).isEmpty()) {
                cell = "Column";
            } else if (((String)cell).startsWith("\"") && ((String)cell).endsWith("\"")) {
                cell = ((String)cell).substring(1, ((String)cell).length() - 1).trim();
            }
            if (nameToIndex.containsKey(cell)) {
                int index = (Integer)nameToIndex.get(cell);
                nameToIndex.put((String)cell, index + 1);
                cell = ((String)cell).contains(" ") ? (String)cell + " " + index : (String)cell + index;
            } else {
                nameToIndex.put((String)cell, 2);
            }
            columnNames.set(c, (String)cell);
            if (project.columnModel.getColumnByName((String)cell) != null) continue;
            Column column = new Column(project.columnModel.allocateNewCellIndex(), (String)cell);
            try {
                project.columnModel.addColumn(-1, column, false);
                continue;
            }
            catch (ModelException modelException) {
                // empty catch block
            }
        }
        project.columnModel.update();
    }

    public static MultiFileReadingProgress createMultiFileReadingProgress(final ImportingJob job, List<ObjectNode> fileRecords) {
        long totalSize = 0L;
        for (ObjectNode fileRecord : fileRecords) {
            File file = ImportingUtilities.getFile(job, fileRecord);
            totalSize += file.length();
        }
        final long totalSize2 = totalSize;
        return new MultiFileReadingProgress(){
            long totalBytesRead = 0L;

            void setProgress(String fileSource, long bytesRead) {
                job.setProgress(totalSize2 == 0L ? -1 : (int)(100L * (this.totalBytesRead + bytesRead) / totalSize2), "Reading " + fileSource);
            }

            @Override
            public void startFile(String fileSource) {
                this.setProgress(fileSource, 0L);
            }

            @Override
            public void readingFile(String fileSource, long bytesRead) {
                this.setProgress(fileSource, bytesRead);
            }

            @Override
            public void endFile(String fileSource, long bytesRead) {
                this.totalBytesRead += bytesRead;
            }
        };
    }

    public static InputStream openAndTrackFile(final String fileSource, File file, final MultiFileReadingProgress progress) throws FileNotFoundException {
        FileInputStream inputStream = new FileInputStream(file);
        return progress == null ? inputStream : new TrackingInputStream(inputStream){

            @Override
            protected long track(long bytesRead) {
                long l = super.track(bytesRead);
                progress.readingFile(fileSource, this.bytesRead);
                return l;
            }
        };
    }

    public static interface MultiFileReadingProgress {
        public void startFile(String var1);

        public void readingFile(String var1, long var2);

        public void endFile(String var1, long var2);
    }
}

