/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.history;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.refine.history.HistoryEntry;
import com.google.refine.model.Project;
import com.google.refine.process.Process;
import com.google.refine.process.ProcessManager;

public class HistoryProcess
extends Process {
    protected final Project _project;
    protected final long _lastDoneID;
    protected final String _description;
    protected boolean _done = false;
    private static final String WARN = "Not a long-running process";

    public HistoryProcess(Project project, long lastDoneID) {
        this._project = project;
        this._lastDoneID = lastDoneID;
        if (this._lastDoneID == 0L) {
            this._description = "Undo all";
        } else {
            HistoryEntry entry = this._project.history.getEntry(this._lastDoneID);
            this._description = "Undo/redo until after " + entry.description;
        }
    }

    @Override
    @JsonIgnore
    public long getId() {
        return super.getId();
    }

    @Override
    public void cancel() {
        throw new RuntimeException(WARN);
    }

    @Override
    public boolean isImmediate() {
        return true;
    }

    @Override
    public HistoryEntry performImmediate() {
        this._project.history.undoRedo(this._lastDoneID);
        this._done = true;
        return null;
    }

    @Override
    public void startPerforming(ProcessManager manager) {
        throw new RuntimeException(WARN);
    }

    @JsonProperty(value="status")
    public String getStatus() {
        return this._done ? "done" : "pending";
    }

    @JsonProperty(value="description")
    public String getDescription() {
        return this._description;
    }

    @Override
    public boolean isDone() {
        throw new RuntimeException(WARN);
    }

    @Override
    public boolean isRunning() {
        throw new RuntimeException(WARN);
    }
}

