/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.expr;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.refine.expr.Evaluable;
import com.google.refine.expr.LanguageSpecificParser;
import com.google.refine.expr.ParsingException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public abstract class MetaParser {
    public static final String GREL_LANGUAGE_CODE = "grel";
    protected static final Map<String, LanguageInfo> s_languages = new HashMap<String, LanguageInfo>();

    public static void registerLanguageParser(String languagePrefix, String name, LanguageSpecificParser parser, String defaultExpression) {
        s_languages.put(languagePrefix, new LanguageInfo(name, parser, defaultExpression));
    }

    public static void unregisterLanguageParser(String languagePrefix) {
        s_languages.remove(languagePrefix.toLowerCase());
    }

    public static LanguageInfo getLanguageInfo(String languagePrefix) {
        return s_languages.get(languagePrefix.toLowerCase());
    }

    public static Set<String> getLanguagePrefixes() {
        return s_languages.keySet();
    }

    public static Evaluable parse(String s) throws ParsingException {
        LanguageInfo info;
        String language = GREL_LANGUAGE_CODE;
        int colon = s.indexOf(58);
        if (colon >= 0 && "gel".equals(language = s.substring(0, colon).toLowerCase())) {
            language = GREL_LANGUAGE_CODE;
        }
        if ((info = s_languages.get(language = language.toLowerCase())) != null) {
            return info.parser.parse(s.substring(colon + 1), language);
        }
        return MetaParser.parseGREL(s);
    }

    protected static Evaluable parseGREL(String s) throws ParsingException {
        LanguageInfo info = s_languages.get(GREL_LANGUAGE_CODE);
        if (info == null) {
            throw new ParsingException("Default language GREL is not available");
        }
        return info.parser.parse(s, GREL_LANGUAGE_CODE);
    }

    public static class LanguageInfo {
        @JsonProperty(value="name")
        public final String name;
        @JsonIgnore
        public final LanguageSpecificParser parser;
        @JsonProperty(value="defaultExpression")
        public final String defaultExpression;

        LanguageInfo(String name, LanguageSpecificParser parser, String defaultExpression) {
            this.name = name;
            this.parser = parser;
            this.defaultExpression = defaultExpression;
        }
    }
}

