/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.exporters;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.refine.ProjectManager;
import com.google.refine.browsing.Engine;
import com.google.refine.browsing.FilteredRows;
import com.google.refine.browsing.RowVisitor;
import com.google.refine.exporters.TabularSerializer;
import com.google.refine.model.Cell;
import com.google.refine.model.Column;
import com.google.refine.model.Project;
import com.google.refine.model.Recon;
import com.google.refine.model.Row;
import com.google.refine.preference.PreferenceStore;
import com.google.refine.util.JSONUtilities;
import com.google.refine.util.ParsingUtilities;
import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TimeZone;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.validator.routines.UrlValidator;

public abstract class CustomizableTabularExporterUtilities {
    private static final String fullIso8601 = "yyyy-MM-dd'T'HH:mm:ss'Z'";

    @Deprecated(since="3.9")
    public static void exportRows(Project project, Engine engine, Properties params, TabularSerializer serializer) {
        CustomizableTabularExporterUtilities.exportRows(project, engine, params.getProperty("options"), serializer);
    }

    public static void exportRows(Project project, Engine engine, String optionsString, final TabularSerializer serializer) {
        ArrayList<String> columnNames;
        List<JsonNode> columnOptionArray;
        JsonNode options;
        JsonNode optionsTemp = null;
        if (optionsString != null) {
            try {
                optionsTemp = ParsingUtilities.mapper.readTree(optionsString);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        final boolean outputColumnHeaders = (options = optionsTemp) == null ? true : JSONUtilities.getBoolean(options, "outputColumnHeaders", true);
        final boolean outputEmptyRows = options == null ? false : JSONUtilities.getBoolean(options, "outputBlankRows", true);
        final int limit = options == null ? -1 : JSONUtilities.getInt(options, "limit", -1);
        final HashMap<String, CellFormatter> columnNameToFormatter = new HashMap<String, CellFormatter>();
        List<JsonNode> list = columnOptionArray = options == null ? null : JSONUtilities.getArray(options, "columns");
        if (columnOptionArray == null) {
            List<Column> columns = project.columnModel.columns;
            columnNames = new ArrayList(columns.size());
            for (Column column : columns) {
                String name = column.getName();
                columnNames.add(name);
                columnNameToFormatter.put(name, new CellFormatter());
            }
        } else {
            int count = columnOptionArray.size();
            columnNames = new ArrayList<String>(count);
            for (int i = 0; i < count; ++i) {
                String name;
                JsonNode columnOptions = columnOptionArray.get(i);
                if (columnOptions == null || (name = JSONUtilities.getString(columnOptions, "name", null)) == null) continue;
                columnNames.add(name);
                try {
                    columnNameToFormatter.put(name, (CellFormatter)ParsingUtilities.mapper.treeToValue((TreeNode)columnOptions, ColumnOptions.class));
                    continue;
                }
                catch (JsonProcessingException e) {
                    e.printStackTrace();
                }
            }
        }
        RowVisitor visitor = new RowVisitor(){
            int rowCount = 0;

            @Override
            public void start(Project project) {
                serializer.startFile(options);
                if (outputColumnHeaders) {
                    ArrayList<TabularSerializer.CellData> cells = new ArrayList<TabularSerializer.CellData>(columnNames.size());
                    for (String name : columnNames) {
                        cells.add(new TabularSerializer.CellData(name, name, name, null));
                    }
                    serializer.addRow(cells, true);
                }
            }

            @Override
            public boolean visit(Project project, int rowIndex, Row row) {
                ArrayList<TabularSerializer.CellData> cells = new ArrayList<TabularSerializer.CellData>(columnNames.size());
                int nonNullCount = 0;
                for (String columnName : columnNames) {
                    Column column = project.columnModel.getColumnByName(columnName);
                    CellFormatter formatter = (CellFormatter)columnNameToFormatter.get(columnName);
                    TabularSerializer.CellData cellData = formatter.format(project, column, row.getCell(column.getCellIndex()));
                    cells.add(cellData);
                    if (cellData == null) continue;
                    ++nonNullCount;
                }
                if (nonNullCount > 0 || outputEmptyRows) {
                    serializer.addRow(cells, false);
                    ++this.rowCount;
                }
                return limit > 0 && this.rowCount >= limit;
            }

            @Override
            public void end(Project project) {
                serializer.endFile();
            }
        };
        FilteredRows filteredRows = engine.getAllFilteredRows();
        filteredRows.accept(project, visitor);
    }

    @Deprecated(since="3.9")
    public static int[] countColumnsRows(Project project, Engine engine, Properties params) {
        RowCountingTabularSerializer serializer = new RowCountingTabularSerializer();
        CustomizableTabularExporterUtilities.exportRows(project, engine, params, (TabularSerializer)serializer);
        return new int[]{serializer.columns, serializer.rows};
    }

    public static class CellFormatter {
        @JsonProperty(value="reconSettings")
        ReconSettings recon = new ReconSettings();
        @JsonProperty(value="dateSettings")
        DateSettings date = new DateSettings();
        @JsonProperty(value="nullValueToEmptyStr")
        boolean includeNullFieldValue = false;
        DateFormat dateFormatter;
        String[] urlSchemes = new String[]{"http", "https", "ftp"};
        UrlValidator urlValidator = new UrlValidator(this.urlSchemes);
        Map<String, String> identifierSpaceToUrl = null;

        @JsonCreator
        CellFormatter(@JsonProperty(value="reconSettings") ReconSettings reconSettings, @JsonProperty(value="dateSettings") DateSettings dateSettings, @JsonProperty(value="nullValueToEmptyStr") boolean includeNullFieldValue) {
            if (reconSettings != null) {
                this.recon = reconSettings;
            }
            if (dateSettings != null) {
                this.date = dateSettings;
            }
            this.setup();
        }

        CellFormatter() {
            this.setup();
        }

        private void setup() {
            if (this.date.formatMode == DateFormatMode.CUSTOM && (this.date.custom == null || this.date.custom.isEmpty())) {
                this.date.formatMode = DateFormatMode.ISO_8601;
            }
            switch (this.date.formatMode) {
                case SHORT_LOCALE: {
                    this.dateFormatter = this.date.omitTime ? SimpleDateFormat.getDateInstance(3) : SimpleDateFormat.getDateTimeInstance(3, 3);
                    break;
                }
                case MEDIUM_LOCALE: {
                    this.dateFormatter = this.date.omitTime ? SimpleDateFormat.getDateInstance(2) : SimpleDateFormat.getDateTimeInstance(2, 2);
                    break;
                }
                case LONG_LOCALE: {
                    this.dateFormatter = this.date.omitTime ? SimpleDateFormat.getDateInstance(1) : SimpleDateFormat.getDateTimeInstance(1, 1);
                    break;
                }
                case FULL_LOCALE: {
                    this.dateFormatter = this.date.omitTime ? SimpleDateFormat.getDateInstance(0) : SimpleDateFormat.getDateTimeInstance(0, 0);
                    break;
                }
                case CUSTOM: {
                    this.dateFormatter = new SimpleDateFormat(this.date.custom);
                    break;
                }
                default: {
                    DateFormat dateFormat = this.dateFormatter = this.date.omitTime ? new SimpleDateFormat("yyyy-MM-dd") : new SimpleDateFormat(CustomizableTabularExporterUtilities.fullIso8601);
                }
            }
            if (!this.date.useLocalTimeZone) {
                this.dateFormatter.setTimeZone(TimeZone.getTimeZone("UTC"));
            }
        }

        TabularSerializer.CellData format(Project project, Column column, Cell cell) {
            if (cell != null) {
                Serializable value;
                String link = null;
                String text = null;
                if (cell.recon != null) {
                    Recon recon = cell.recon;
                    if (recon.judgment == Recon.Judgment.Matched) {
                        if (this.recon.outputMode == ReconOutputMode.ENTITY_NAME) {
                            text = recon.match.name;
                        } else if (this.recon.outputMode == ReconOutputMode.ENTITY_ID) {
                            text = recon.match.id;
                        }
                        if (this.recon.linkToEntityPages) {
                            this.buildIdentifierSpaceToUrlMap();
                            String service = recon.service;
                            String viewUrl = this.identifierSpaceToUrl.get(service);
                            if (viewUrl != null) {
                                link = StringUtils.replace((String)viewUrl, (String)"{{id}}", (String)recon.match.id);
                            }
                        }
                    } else if (this.recon.blankUnmatchedCells) {
                        return null;
                    }
                }
                if ((value = cell.value) != null) {
                    if (text == null) {
                        if (value instanceof String) {
                            text = (String)((Object)value);
                            if (text.contains(":") && this.urlValidator.isValid(text)) {
                                try {
                                    link = new URI(text).toString();
                                }
                                catch (URISyntaxException uRISyntaxException) {}
                            }
                        } else {
                            text = value instanceof OffsetDateTime ? ((OffsetDateTime)value).format(DateTimeFormatter.ISO_INSTANT) : value.toString();
                        }
                    }
                    return new TabularSerializer.CellData(column.getName(), value, text, link);
                }
            } else if (this.includeNullFieldValue) {
                return new TabularSerializer.CellData(column.getName(), "", "", "");
            }
            return null;
        }

        void buildIdentifierSpaceToUrlMap() {
            if (this.identifierSpaceToUrl != null) {
                return;
            }
            this.identifierSpaceToUrl = new HashMap<String, String>();
            PreferenceStore ps = ProjectManager.singleton.getPreferenceStore();
            ArrayNode services = (ArrayNode)ps.get("reconciliation.standardServices");
            if (services != null) {
                int count = services.size();
                for (int i = 0; i < count; ++i) {
                    ObjectNode service = (ObjectNode)services.get(i);
                    ObjectNode view = JSONUtilities.getObject(service, "view");
                    if (view == null) continue;
                    String url = JSONUtilities.getString((JsonNode)service, "url", null);
                    String viewUrl = JSONUtilities.getString((JsonNode)view, "url", null);
                    if (url == null || viewUrl == null) continue;
                    this.identifierSpaceToUrl.put(url, viewUrl);
                }
            }
        }
    }

    public static class ColumnOptions
    extends CellFormatter {
        @JsonProperty(value="name")
        String columnName;
    }

    private static class RowCountingTabularSerializer
    implements TabularSerializer {
        int columns;
        int rows;

        private RowCountingTabularSerializer() {
        }

        @Override
        public void startFile(JsonNode options) {
        }

        @Override
        public void endFile() {
        }

        @Override
        public void addRow(List<TabularSerializer.CellData> cells, boolean isHeader) {
            this.columns = Math.max(this.columns, cells.size());
            ++this.rows;
        }
    }

    private static class DateSettings {
        @JsonProperty(value="format")
        DateFormatMode formatMode = DateFormatMode.ISO_8601;
        @JsonProperty(value="custom")
        String custom = null;
        @JsonProperty(value="useLocalTimeZone")
        boolean useLocalTimeZone = false;
        @JsonProperty(value="omitTime")
        boolean omitTime = false;

        private DateSettings() {
        }
    }

    private static class ReconSettings {
        @JsonProperty(value="output")
        ReconOutputMode outputMode = ReconOutputMode.ENTITY_NAME;
        @JsonProperty(value="blankUnmatchedCells")
        boolean blankUnmatchedCells = false;
        @JsonProperty(value="linkToEntityPages")
        boolean linkToEntityPages = true;

        private ReconSettings() {
        }
    }

    private static enum DateFormatMode {
        ISO_8601,
        SHORT_LOCALE,
        MEDIUM_LOCALE,
        LONG_LOCALE,
        FULL_LOCALE,
        CUSTOM;

    }

    private static enum ReconOutputMode {
        ENTITY_NAME,
        ENTITY_ID,
        CELL_CONTENT;

    }
}

