/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.commands;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.refine.ProjectManager;
import com.google.refine.ProjectMetadata;
import com.google.refine.RefineServlet;
import com.google.refine.browsing.Engine;
import com.google.refine.browsing.EngineConfig;
import com.google.refine.commands.CSRFTokenFactory;
import com.google.refine.commands.HttpUtilities;
import com.google.refine.history.HistoryEntry;
import com.google.refine.model.Project;
import com.google.refine.process.Process;
import com.google.refine.util.ParsingUtilities;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Pattern;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Command {
    protected static final Logger logger = LoggerFactory.getLogger((String)"command");
    public static final CSRFTokenFactory csrfFactory = new CSRFTokenFactory(3600L, 32);
    protected RefineServlet servlet;

    public void init(RefineServlet servlet) {
        this.servlet = servlet;
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        throw new UnsupportedOperationException();
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        throw new UnsupportedOperationException();
    }

    public void doHead(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        throw new UnsupportedOperationException();
    }

    public void doPut(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        throw new UnsupportedOperationException();
    }

    public void doDelete(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        throw new UnsupportedOperationException();
    }

    public boolean logRequests() {
        return true;
    }

    protected static EngineConfig getEngineConfig(HttpServletRequest request) {
        if (request == null) {
            throw new IllegalArgumentException("parameter 'request' should not be null");
        }
        String json = request.getParameter("engine");
        if (json == null) {
            return null;
        }
        try {
            return EngineConfig.deserialize(json);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    protected static Engine getEngine(HttpServletRequest request, Project project) throws Exception {
        if (request == null) {
            throw new IllegalArgumentException("parameter 'request' should not be null");
        }
        if (project == null) {
            throw new IllegalArgumentException("parameter 'project' should not be null");
        }
        Engine engine = new Engine(project);
        EngineConfig c = Command.getEngineConfig(request);
        if (c != null) {
            engine.initializeFromConfig(c);
        }
        return engine;
    }

    protected static void checkJSONP(HttpServletRequest request) {
        if (request.getParameter("callback") != null) {
            throw new IllegalJsonpException("JSONP is no longer supported. Please use JSON for AJAX requests");
        }
    }

    protected Project getProject(HttpServletRequest request) throws ServletException {
        Long id;
        if (request == null) {
            throw new IllegalArgumentException("parameter 'request' should not be null");
        }
        String param = request.getParameter("project");
        if (param == null || "".equals(param)) {
            throw new ServletException("Can't find project: missing ID parameter");
        }
        try {
            id = Long.parseLong(param);
        }
        catch (NumberFormatException e) {
            throw new ServletException("Can't find project: badly formatted id #", (Throwable)e);
        }
        Project p = ProjectManager.singleton.getProject(id);
        if (p != null) {
            return p;
        }
        throw new ServletException("Failed to find project id #" + param + " - may be corrupt");
    }

    protected ProjectMetadata getProjectMetadata(HttpServletRequest request) throws ServletException {
        if (request == null) {
            throw new IllegalArgumentException("parameter 'request' should not be null");
        }
        try {
            ProjectMetadata pm = ProjectManager.singleton.getProjectMetadata(Long.parseLong(request.getParameter("project")));
            if (pm != null) {
                return pm;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        throw new ServletException("Can't find project metadata: missing or bad URL parameter");
    }

    protected static int getIntegerParameter(HttpServletRequest request, String name, int def) {
        if (request == null) {
            throw new IllegalArgumentException("parameter 'request' should not be null");
        }
        try {
            return Integer.parseInt(request.getParameter(name));
        }
        catch (Exception exception) {
            return def;
        }
    }

    protected static Map<String, String> getParameters(HttpServletRequest request) {
        if (request == null) {
            throw new IllegalArgumentException("parameter 'request' should not be null");
        }
        HashMap<String, String> result = new HashMap<String, String>();
        request.getParameterMap().forEach((k, v) -> result.put((String)k, v == null ? null : v[0]));
        return result;
    }

    protected boolean hasValidCSRFToken(HttpServletRequest request) throws ServletException {
        if (request == null) {
            throw new IllegalArgumentException("parameter 'request' should not be null");
        }
        try {
            String token = request.getParameter("csrf_token");
            return token != null && csrfFactory.validToken(token);
        }
        catch (Exception exception) {
            throw new ServletException("Can't find CSRF token: missing or bad URL parameter");
        }
    }

    protected boolean hasValidCSRFTokenAsGET(HttpServletRequest request) {
        if (request == null) {
            throw new IllegalArgumentException("parameter 'request' should not be null");
        }
        Map<String, String> options = ParsingUtilities.parseParameters(request);
        String token = options.get("csrf_token");
        return token != null && csrfFactory.validToken(token);
    }

    protected static void performProcessAndRespond(HttpServletRequest request, HttpServletResponse response, Project project, Process process) throws Exception {
        HistoryEntry historyEntry = project.processManager.queueProcess(process);
        if (historyEntry != null) {
            Command.respondJSON(response, new HistoryEntryResponse(historyEntry));
        } else {
            Command.respondCodePending(response);
        }
    }

    protected static void respondStatusOk(HttpServletResponse response) throws IOException {
        Command.respondStatusOk(response, null);
    }

    protected static void respondStatusOk(HttpServletResponse response, String message) throws IOException {
        Command.respondStatus(response, "ok", message);
    }

    protected static void respondOkDone(HttpServletResponse response) throws IOException {
        Command.respondStatusOk(response, "done");
    }

    protected static void respondCodePending(HttpServletResponse response) throws IOException {
        Command.respondJSON(response, Map.of("code", "pending"));
    }

    protected static void respond(HttpServletResponse response, String content) throws IOException, ServletException {
        HttpUtilities.respond(response, content);
    }

    @Deprecated
    protected static void respond(HttpServletResponse response, String status, String message) throws IOException {
        Command.respondStatus(response, status, message);
    }

    protected static void respondStatus(HttpServletResponse response, String status, String message) throws IOException {
        HttpUtilities.respond(response, status, message);
    }

    protected static void respondStatusError(HttpServletResponse response, String message) throws IOException {
        Command.respondStatus(response, "error", message);
    }

    public static void respondJSON(HttpServletResponse response, Object o) throws IOException {
        Command.respondJSON(response, o, new Properties());
    }

    @Deprecated
    protected static void respondJSON(HttpServletResponse response, Object o, Properties options) throws IOException {
        HttpUtilities.respondJSON(response, o, options);
    }

    protected static void respondCSRFError(HttpServletResponse response) throws IOException {
        Command.respondCodeError(response, "Missing or invalid csrf_token parameter");
    }

    protected static void respondCodeError(HttpServletResponse response, String message) throws IOException {
        Command.respondCodeError(response, message, 400);
    }

    protected static void respondCodeError(HttpServletResponse response, String message, int statusCode) throws IOException {
        Command.respondCodeError(response, message, statusCode, null);
    }

    protected static void respondCodeError(HttpServletResponse response, String message, int statusCode, String stackTrace) throws IOException {
        HashMap<String, String> responseJSON = new HashMap<String, String>();
        responseJSON.put("code", "error");
        if (message != null) {
            responseJSON.put("message", message);
        }
        if (stackTrace != null) {
            responseJSON.put("stack", stackTrace);
        }
        Command.respondJSON(response, responseJSON);
    }

    protected static void respondException(HttpServletResponse response, Exception e) throws IOException, ServletException {
        logger.warn("Exception caught", (Throwable)e);
        if (response == null) {
            throw new ServletException("Response object can't be null");
        }
        try (StringWriter sw = new StringWriter();
             PrintWriter pw = new PrintWriter(sw);){
            e.printStackTrace(pw);
            pw.flush();
            sw.flush();
            Command.respondCodeError(response, e.toString(), 200, sw.toString());
        }
    }

    protected static void respondNoJsonpException(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        if (response == null) {
            throw new ServletException("Response object can't be null");
        }
        response.setStatus(400);
        String cb = request.getParameter("callback");
        Pattern validIdentifier = Pattern.compile("[a-zA-Z0-9_]+");
        if (validIdentifier.matcher(cb).matches()) {
            PrintWriter pw = response.getWriter();
            pw.write(cb + "(");
            ParsingUtilities.defaultWriter.writeValue((Writer)pw, Map.of("code", "error", "status", "error", "message", "JSONP is not supported for this command. Please use JSON in your AJAX requests."));
            pw.write(")");
        }
    }

    protected static void respondStatusErrors(HttpServletResponse response, List<Exception> exceptions) throws IOException, ServletException {
        Command.respondJSON(response, Map.of("status", "error", "errors", exceptions));
    }

    protected void respondWithErrorPage(HttpServletRequest request, HttpServletResponse response, String message, Throwable e) {
        HttpUtilities.respondWithErrorPage(this.servlet, request, response, message, e);
    }

    protected static void redirect(HttpServletResponse response, String url) throws IOException {
        response.sendRedirect(url);
    }

    public static class IllegalJsonpException
    extends IllegalArgumentException {
        public IllegalJsonpException(String s) {
            super(s);
        }
    }

    protected static class HistoryEntryResponse {
        @JsonProperty(value="historyEntry")
        protected HistoryEntry historyEntry;

        @JsonProperty(value="code")
        protected String getCode() {
            return "ok";
        }

        protected HistoryEntryResponse(HistoryEntry entry) {
            this.historyEntry = entry;
        }
    }
}

