/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.browsing.util;

import com.google.refine.browsing.util.RowEvaluable;
import com.google.refine.expr.ExpressionUtils;
import com.google.refine.model.Project;
import com.google.refine.model.Row;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Properties;

public abstract class TimeBinIndex {
    protected int _totalValueCount;
    protected int _timeValueCount;
    protected long _min;
    protected long _max;
    protected long _step;
    protected int[] _bins;
    protected int _timeRowCount;
    protected int _nonTimeRowCount;
    protected int _blankRowCount;
    protected int _errorRowCount;
    protected boolean _hasError = false;
    protected boolean _hasNonTime = false;
    protected boolean _hasTime = false;
    protected boolean _hasBlank = false;
    protected long[] steps = new long[]{1L, 1000L, 60000L, 3600000L, 86400000L, 604800000L, 2629746000L, 31556952000L, 315569520000L, 3155695200000L, 31556952000000L};

    protected abstract void iterate(Project var1, RowEvaluable var2, List<Long> var3);

    public TimeBinIndex(Project project, RowEvaluable rowEvaluable) {
        this._min = Long.MAX_VALUE;
        this._max = Long.MIN_VALUE;
        ArrayList<Long> allValues = new ArrayList<Long>();
        this.iterate(project, rowEvaluable, allValues);
        this._timeValueCount = allValues.size();
        if (this._min >= this._max) {
            this._step = 1L;
            this._min = Math.min(this._min, this._max);
            this._max = this._step;
            this._bins = new int[1];
            return;
        }
        long diff = this._max - this._min;
        Object object = this.steps;
        int n = ((long[])object).length;
        for (int i = 0; i < n; ++i) {
            long step;
            this._step = step = object[i];
            if (diff / this._step <= 100L) break;
        }
        this._bins = new int[(int)(diff / this._step) + 1];
        object = allValues.iterator();
        while (object.hasNext()) {
            int bin;
            long d = (Long)object.next();
            int n2 = bin = (int)Math.max((d - this._min) / this._step, 0L);
            this._bins[n2] = this._bins[n2] + 1;
        }
    }

    public boolean isTemporal() {
        return this._timeValueCount > this._totalValueCount / 2;
    }

    public long getMin() {
        return this._min;
    }

    public long getMax() {
        return this._max;
    }

    public long getStep() {
        return this._step;
    }

    public int[] getBins() {
        return this._bins;
    }

    public int getTimeRowCount() {
        return this._timeRowCount;
    }

    public int getNonTimeRowCount() {
        return this._nonTimeRowCount;
    }

    public int getBlankRowCount() {
        return this._blankRowCount;
    }

    public int getErrorRowCount() {
        return this._errorRowCount;
    }

    protected void processRow(Project project, RowEvaluable rowEvaluable, List<Long> allValues, int rowIndex, Row row, Properties bindings) {
        Object value = rowEvaluable.eval(project, rowIndex, row, bindings);
        if (ExpressionUtils.isError(value)) {
            this._hasError = true;
        } else if (ExpressionUtils.isNonBlankData(value)) {
            if (value.getClass().isArray()) {
                Object[] a;
                for (Object v : a = (Object[])value) {
                    ++this._totalValueCount;
                    if (ExpressionUtils.isError(v)) {
                        this._hasError = true;
                        continue;
                    }
                    if (ExpressionUtils.isNonBlankData(v)) {
                        if (v instanceof OffsetDateTime) {
                            this._hasTime = true;
                            this.processValue(((OffsetDateTime)v).toInstant().toEpochMilli(), allValues);
                            continue;
                        }
                        this._hasNonTime = true;
                        continue;
                    }
                    this._hasBlank = true;
                }
            } else if (value instanceof Collection) {
                for (Object v : ExpressionUtils.toObjectCollection(value)) {
                    ++this._totalValueCount;
                    if (ExpressionUtils.isError(v)) {
                        this._hasError = true;
                        continue;
                    }
                    if (ExpressionUtils.isNonBlankData(v)) {
                        if (v instanceof OffsetDateTime) {
                            this._hasTime = true;
                            this.processValue(((OffsetDateTime)v).toInstant().toEpochMilli(), allValues);
                            continue;
                        }
                        this._hasNonTime = true;
                        continue;
                    }
                    this._hasBlank = true;
                }
            } else {
                ++this._totalValueCount;
                if (value instanceof OffsetDateTime) {
                    this._hasTime = true;
                    this.processValue(((OffsetDateTime)value).toInstant().toEpochMilli(), allValues);
                } else {
                    this._hasNonTime = true;
                }
            }
        } else {
            this._hasBlank = true;
        }
    }

    protected void preprocessing() {
        this._hasBlank = false;
        this._hasError = false;
        this._hasNonTime = false;
        this._hasTime = false;
    }

    protected void postprocessing() {
        if (this._hasError) {
            ++this._errorRowCount;
        }
        if (this._hasBlank) {
            ++this._blankRowCount;
        }
        if (this._hasTime) {
            ++this._timeRowCount;
        }
        if (this._hasNonTime) {
            ++this._nonTimeRowCount;
        }
    }

    protected void processValue(long v, List<Long> allValues) {
        this._min = Math.min(this._min, v);
        this._max = Math.max(this._max, v);
        allValues.add(v);
    }
}

