/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.browsing.util;

import com.google.refine.browsing.RecordVisitor;
import com.google.refine.browsing.RowVisitor;
import com.google.refine.browsing.util.NumericBinIndex;
import com.google.refine.browsing.util.RowEvaluable;
import com.google.refine.expr.ExpressionUtils;
import com.google.refine.model.Project;
import com.google.refine.model.Record;
import com.google.refine.model.Row;
import java.util.Collection;
import java.util.Properties;

public class ExpressionNumericValueBinner
implements RowVisitor,
RecordVisitor {
    protected final RowEvaluable _rowEvaluable;
    protected final NumericBinIndex _index;
    public final int[] bins;
    public int numericCount;
    public int nonNumericCount;
    public int blankCount;
    public int errorCount;
    protected boolean hasError;
    protected boolean hasBlank;
    protected boolean hasNumeric;
    protected boolean hasNonNumeric;

    public ExpressionNumericValueBinner(RowEvaluable rowEvaluable, NumericBinIndex index) {
        this._rowEvaluable = rowEvaluable;
        this._index = index;
        this.bins = new int[this._index.getBins().length];
    }

    @Override
    public void start(Project project) {
    }

    @Override
    public void end(Project project) {
    }

    @Override
    public boolean visit(Project project, int rowIndex, Row row) {
        this.resetFlags();
        Properties bindings = ExpressionUtils.createBindings(project);
        this.processRow(project, rowIndex, row, bindings);
        this.updateCounts();
        return false;
    }

    @Override
    public boolean visit(Project project, Record record) {
        this.resetFlags();
        Properties bindings = ExpressionUtils.createBindings(project);
        for (int r = record.fromRowIndex; r < record.toRowIndex; ++r) {
            this.processRow(project, r, project.rows.get(r), bindings);
        }
        this.updateCounts();
        return false;
    }

    protected void resetFlags() {
        this.hasError = false;
        this.hasBlank = false;
        this.hasNumeric = false;
        this.hasNonNumeric = false;
    }

    protected void updateCounts() {
        if (this.hasError) {
            ++this.errorCount;
        }
        if (this.hasBlank) {
            ++this.blankCount;
        }
        if (this.hasNumeric) {
            ++this.numericCount;
        }
        if (this.hasNonNumeric) {
            ++this.nonNumericCount;
        }
    }

    protected void processRow(Project project, int rowIndex, Row row, Properties bindings) {
        Object value = this._rowEvaluable.eval(project, rowIndex, row, bindings);
        if (value != null) {
            if (value.getClass().isArray()) {
                Object[] a;
                for (Object v : a = (Object[])value) {
                    this.processValue(v);
                }
                return;
            }
            if (value instanceof Collection) {
                for (Object v : ExpressionUtils.toObjectCollection(value)) {
                    this.processValue(v);
                }
                return;
            }
        }
        this.processValue(value);
    }

    protected void processValue(Object value) {
        if (ExpressionUtils.isError(value)) {
            this.hasError = true;
        } else if (ExpressionUtils.isNonBlankData(value)) {
            if (value instanceof Number) {
                double d = ((Number)value).doubleValue();
                if (!Double.isInfinite(d) && !Double.isNaN(d)) {
                    this.hasNumeric = true;
                    int bin = (int)Math.floor((d - this._index.getMin()) / this._index.getStep());
                    if (bin >= 0 && bin < this.bins.length) {
                        int n = bin;
                        this.bins[n] = this.bins[n] + 1;
                    }
                } else {
                    this.hasError = true;
                }
            } else {
                this.hasNonNumeric = true;
            }
        } else {
            this.hasBlank = true;
        }
    }
}

