/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.browsing.util;

import com.google.refine.browsing.DecoratedValue;
import com.google.refine.browsing.RecordVisitor;
import com.google.refine.browsing.RowVisitor;
import com.google.refine.browsing.facets.NominalFacetChoice;
import com.google.refine.browsing.util.RowEvaluable;
import com.google.refine.expr.Evaluable;
import com.google.refine.expr.ExpressionUtils;
import com.google.refine.model.Cell;
import com.google.refine.model.Project;
import com.google.refine.model.Record;
import com.google.refine.model.Row;
import com.google.refine.util.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class ExpressionNominalValueGrouper
implements RowVisitor,
RecordVisitor {
    protected final Evaluable _evaluable;
    protected final String _columnName;
    protected final int _cellIndex;
    public final Map<Object, IndexedNominalFacetChoice> choices = new HashMap<Object, IndexedNominalFacetChoice>();
    public int blankCount = 0;
    public int errorCount = 0;
    protected boolean hasBlank;
    protected boolean hasError;

    public ExpressionNominalValueGrouper(Evaluable evaluable, String columnName, int cellIndex) {
        this._evaluable = evaluable;
        this._columnName = columnName;
        this._cellIndex = cellIndex;
    }

    @Override
    public void start(Project project) {
    }

    @Override
    public void end(Project project) {
    }

    @Override
    public boolean visit(Project project, int rowIndex, Row row) {
        this.hasError = false;
        this.hasBlank = false;
        Properties bindings = ExpressionUtils.createBindings(project);
        this.visitRow(project, rowIndex, row, bindings, rowIndex);
        if (this.hasError) {
            ++this.errorCount;
        }
        if (this.hasBlank) {
            ++this.blankCount;
        }
        return false;
    }

    @Override
    public boolean visit(Project project, Record record) {
        Properties bindings = ExpressionUtils.createBindings(project);
        for (int r = record.fromRowIndex; r < record.toRowIndex; ++r) {
            this.hasError = false;
            this.hasBlank = false;
            Row row = project.rows.get(r);
            this.visitRow(project, r, row, bindings, record.recordIndex);
            if (this.hasError) {
                ++this.errorCount;
            }
            if (!this.hasBlank) continue;
            ++this.blankCount;
        }
        return false;
    }

    protected void visitRow(Project project, int rowIndex, Row row, Properties bindings, int index) {
        Object value = this.evalRow(project, rowIndex, row, bindings);
        if (value != null) {
            if (value.getClass().isArray()) {
                Object[] a;
                for (Object v : a = (Object[])value) {
                    this.processValue(v, rowIndex);
                }
            } else if (value instanceof Collection) {
                for (Object v : ExpressionUtils.toObjectCollection(value)) {
                    this.processValue(v, rowIndex);
                }
            } else {
                this.processValue(value, rowIndex);
            }
        } else {
            this.processValue(value, rowIndex);
        }
    }

    protected Object evalRow(Project project, int rowIndex, Row row, Properties bindings) {
        Cell cell = this._cellIndex < 0 ? null : row.getCell(this._cellIndex);
        ExpressionUtils.bind(bindings, row, rowIndex, this._columnName, cell);
        return this._evaluable.evaluate(bindings);
    }

    protected void processValue(Object value, int index) {
        if (ExpressionUtils.isError(value)) {
            this.hasError = true;
        } else if (ExpressionUtils.isNonBlankData(value)) {
            String valueString = StringUtils.toString(value);
            IndexedNominalFacetChoice facetChoice = this.choices.get(valueString);
            if (facetChoice != null) {
                if (facetChoice._latestIndex < index) {
                    facetChoice._latestIndex = index;
                    ++facetChoice.count;
                }
            } else {
                String label = valueString;
                DecoratedValue dValue = new DecoratedValue(value, label);
                IndexedNominalFacetChoice choice = new IndexedNominalFacetChoice(dValue, index);
                choice.count = 1;
                this.choices.put(valueString, choice);
            }
        } else {
            this.hasBlank = true;
        }
    }

    public RowEvaluable getChoiceCountRowEvaluable() {
        return new RowEvaluable(){

            @Override
            public Object eval(Project project, int rowIndex, Row row, Properties bindings) {
                Object value = ExpressionNominalValueGrouper.this.evalRow(project, rowIndex, row, bindings);
                return ExpressionNominalValueGrouper.this.getChoiceValueCountMultiple(value);
            }
        };
    }

    public Object getChoiceValueCountMultiple(Object value) {
        if (value != null) {
            if (value.getClass().isArray()) {
                Object[] choiceValues = (Object[])value;
                ArrayList<Integer> counts = new ArrayList<Integer>(choiceValues.length);
                for (Object choiceValue : choiceValues) {
                    counts.add(this.getChoiceValueCount(choiceValue));
                }
                return counts;
            }
            if (value instanceof Collection) {
                List<Object> choiceValues = ExpressionUtils.toObjectList(value);
                ArrayList<Integer> counts = new ArrayList<Integer>(choiceValues.size());
                int count = choiceValues.size();
                for (int i = 0; i < count; ++i) {
                    counts.add(this.getChoiceValueCount(choiceValues.get(i)));
                }
                return counts;
            }
        }
        return this.getChoiceValueCount(value);
    }

    public Integer getChoiceValueCount(Object choiceValue) {
        if (ExpressionUtils.isError(choiceValue)) {
            return this.errorCount;
        }
        if (ExpressionUtils.isNonBlankData(choiceValue)) {
            IndexedNominalFacetChoice choice = this.choices.get(StringUtils.toString(choiceValue));
            return choice != null ? choice.count : 0;
        }
        return this.blankCount;
    }

    public static class IndexedNominalFacetChoice
    extends NominalFacetChoice {
        int _latestIndex;

        public IndexedNominalFacetChoice(DecoratedValue decoratedValue, int latestIndex) {
            super(decoratedValue);
            this._latestIndex = latestIndex;
        }
    }
}

