/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.browsing.util;

import com.google.refine.browsing.FilteredRecords;
import com.google.refine.browsing.RecordFilter;
import com.google.refine.browsing.RecordVisitor;
import com.google.refine.model.Project;
import com.google.refine.model.Record;
import java.util.LinkedList;
import java.util.List;

public class ConjunctiveFilteredRecords
implements FilteredRecords {
    protected final List<RecordFilter> _recordFilters = new LinkedList<RecordFilter>();

    public void add(RecordFilter recordFilter) {
        this._recordFilters.add(recordFilter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void accept(Project project, RecordVisitor visitor) {
        try {
            visitor.start(project);
            int c = project.recordModel.getRecordCount();
            for (int r = 0; r < c; ++r) {
                Record record = project.recordModel.getRecord(r);
                if (!this.matchRecord(project, record) || !visitor.visit(project, record.fromRowIndex, record)) continue;
                return;
            }
        }
        finally {
            visitor.end(project);
        }
    }

    protected boolean matchRecord(Project project, Record record) {
        for (RecordFilter recordFilter : this._recordFilters) {
            if (recordFilter.filterRecord(project, record)) continue;
            return false;
        }
        return true;
    }
}

