/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.browsing.filters;

import com.google.refine.browsing.filters.ExpressionNumberComparisonRowFilter;
import com.google.refine.browsing.util.RowEvaluable;
import com.google.refine.expr.ExpressionUtils;
import java.time.OffsetDateTime;

public abstract class ExpressionTimeComparisonRowFilter
extends ExpressionNumberComparisonRowFilter {
    protected final boolean _selectTime;
    protected final boolean _selectNonTime;

    public ExpressionTimeComparisonRowFilter(RowEvaluable rowEvaluable, boolean selectTime, boolean selectNonTime, boolean selectBlank, boolean selectError) {
        super(rowEvaluable, selectTime, selectNonTime, selectBlank, selectError);
        this._selectTime = selectTime;
        this._selectNonTime = selectNonTime;
    }

    @Override
    protected boolean checkValue(Object v) {
        if (ExpressionUtils.isError(v)) {
            return this._selectError;
        }
        if (ExpressionUtils.isNonBlankData(v)) {
            if (v instanceof OffsetDateTime) {
                long time = ((OffsetDateTime)v).toInstant().toEpochMilli();
                return this._selectTime && this.checkValue(time);
            }
            return this._selectNonTime;
        }
        return this._selectBlank;
    }

    @Override
    protected boolean checkValue(double d) {
        return false;
    }

    protected abstract boolean checkValue(long var1);
}

