/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.browsing.filters;

import com.fasterxml.jackson.databind.node.ArrayNode;
import com.google.refine.browsing.RowFilter;
import com.google.refine.browsing.util.RowEvaluable;
import com.google.refine.expr.ExpressionUtils;
import com.google.refine.expr.util.JsonValueConverter;
import com.google.refine.model.Project;
import com.google.refine.model.Row;
import java.util.Collection;
import java.util.Properties;

public abstract class ExpressionNumberComparisonRowFilter
implements RowFilter {
    protected final RowEvaluable _rowEvaluable;
    protected final boolean _selectNumeric;
    protected final boolean _selectNonNumeric;
    protected final boolean _selectBlank;
    protected final boolean _selectError;

    public ExpressionNumberComparisonRowFilter(RowEvaluable rowEvaluable, boolean selectNumeric, boolean selectNonNumeric, boolean selectBlank, boolean selectError) {
        this._rowEvaluable = rowEvaluable;
        this._selectNumeric = selectNumeric;
        this._selectNonNumeric = selectNonNumeric;
        this._selectBlank = selectBlank;
        this._selectError = selectError;
    }

    @Override
    public boolean filterRow(Project project, int rowIndex, Row row) {
        Properties bindings = ExpressionUtils.createBindings(project);
        Object value = this._rowEvaluable.eval(project, rowIndex, row, bindings);
        if (value != null) {
            if (value.getClass().isArray()) {
                Object[] a;
                for (Object v : a = (Object[])value) {
                    if (!this.checkValue(v)) continue;
                    return true;
                }
                return false;
            }
            if (value instanceof Collection) {
                for (Object v : ExpressionUtils.toObjectCollection(value)) {
                    if (!this.checkValue(v)) continue;
                    return true;
                }
                return false;
            }
            if (value instanceof ArrayNode) {
                ArrayNode a = (ArrayNode)value;
                int l = a.size();
                for (int i = 0; i < l; ++i) {
                    if (!this.checkValue(JsonValueConverter.convert(a.get(i)))) continue;
                    return true;
                }
                return false;
            }
        }
        return this.checkValue(value);
    }

    protected boolean checkValue(Object v) {
        if (ExpressionUtils.isError(v)) {
            return this._selectError;
        }
        if (ExpressionUtils.isNonBlankData(v)) {
            if (v instanceof Number) {
                double d = ((Number)v).doubleValue();
                if (Double.isInfinite(d) || Double.isNaN(d)) {
                    return this._selectError;
                }
                return this._selectNumeric && this.checkValue(d);
            }
            return this._selectNonNumeric;
        }
        return this._selectBlank;
    }

    protected abstract boolean checkValue(double var1);
}

