/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.browsing.filters;

import com.fasterxml.jackson.databind.node.ArrayNode;
import com.google.refine.browsing.RowFilter;
import com.google.refine.expr.Evaluable;
import com.google.refine.expr.ExpressionUtils;
import com.google.refine.expr.util.JsonValueConverter;
import com.google.refine.model.Cell;
import com.google.refine.model.Project;
import com.google.refine.model.Row;
import java.util.Collection;
import java.util.Properties;

public class ExpressionEqualRowFilter
implements RowFilter {
    protected final Evaluable _evaluable;
    protected final String _columnName;
    protected final int _cellIndex;
    protected final Object[] _matches;
    protected final boolean _selectBlank;
    protected final boolean _selectError;
    protected final boolean _invert;

    public ExpressionEqualRowFilter(Evaluable evaluable, String columnName, int cellIndex, Object[] matches, boolean selectBlank, boolean selectError, boolean invert) {
        this._evaluable = evaluable;
        this._columnName = columnName;
        this._cellIndex = cellIndex;
        this._matches = matches;
        this._selectBlank = selectBlank;
        this._selectError = selectError;
        this._invert = invert;
    }

    @Override
    public boolean filterRow(Project project, int rowIndex, Row row) {
        return this._invert ? this.internalInvertedFilterRow(project, rowIndex, row) : this.internalFilterRow(project, rowIndex, row);
    }

    public boolean internalFilterRow(Project project, int rowIndex, Row row) {
        Cell cell = this._cellIndex < 0 ? null : row.getCell(this._cellIndex);
        Properties bindings = ExpressionUtils.createBindings(project);
        ExpressionUtils.bind(bindings, row, rowIndex, this._columnName, cell);
        Object value = this._evaluable.evaluate(bindings);
        if (value != null) {
            if (value.getClass().isArray()) {
                Object[] a;
                for (Object v : a = (Object[])value) {
                    if (!this.testValue(v)) continue;
                    return true;
                }
                return false;
            }
            if (value instanceof Collection) {
                for (Object v : ExpressionUtils.toObjectCollection(value)) {
                    if (!this.testValue(v)) continue;
                    return true;
                }
                return false;
            }
            if (value instanceof ArrayNode) {
                ArrayNode a = (ArrayNode)value;
                int l = a.size();
                for (int i = 0; i < l; ++i) {
                    if (!this.testValue(JsonValueConverter.convert(a.get(i)))) continue;
                    return true;
                }
                return false;
            }
        }
        return this.testValue(value);
    }

    public boolean internalInvertedFilterRow(Project project, int rowIndex, Row row) {
        Cell cell = this._cellIndex < 0 ? null : row.getCell(this._cellIndex);
        Properties bindings = ExpressionUtils.createBindings(project);
        ExpressionUtils.bind(bindings, row, rowIndex, this._columnName, cell);
        Object value = this._evaluable.evaluate(bindings);
        if (value != null) {
            if (value.getClass().isArray()) {
                Object[] a;
                for (Object v : a = (Object[])value) {
                    if (!this.testValue(v)) continue;
                    return false;
                }
                return true;
            }
            if (value instanceof Collection) {
                for (Object v : ExpressionUtils.toObjectCollection(value)) {
                    if (!this.testValue(v)) continue;
                    return false;
                }
                return true;
            }
            if (value instanceof ArrayNode) {
                ArrayNode a = (ArrayNode)value;
                int l = a.size();
                for (int i = 0; i < l; ++i) {
                    if (!this.testValue(JsonValueConverter.convert(a.get(i)))) continue;
                    return false;
                }
                return true;
            }
        }
        return !this.testValue(value);
    }

    protected boolean testValue(Object v) {
        if (ExpressionUtils.isError(v)) {
            return this._selectError;
        }
        if (ExpressionUtils.isNonBlankData(v)) {
            for (Object match : this._matches) {
                if (!this.testValue(v, match)) continue;
                return true;
            }
            return false;
        }
        return this._selectBlank;
    }

    protected boolean testValue(Object v, Object match) {
        return v instanceof Number && match instanceof Number ? ((Number)match).doubleValue() == ((Number)v).doubleValue() : match.equals(v);
    }
}

