/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.browsing.facets;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.refine.browsing.FilteredRecords;
import com.google.refine.browsing.FilteredRows;
import com.google.refine.browsing.RecordFilter;
import com.google.refine.browsing.RowFilter;
import com.google.refine.browsing.facets.Facet;
import com.google.refine.browsing.facets.FacetConfig;
import com.google.refine.browsing.filters.AnyRowRecordFilter;
import com.google.refine.browsing.filters.ExpressionStringComparisonRowFilter;
import com.google.refine.expr.Evaluable;
import com.google.refine.model.Column;
import com.google.refine.model.Project;
import com.google.refine.util.PatternSyntaxExceptionParser;
import java.util.Collections;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class TextSearchFacet
implements Facet {
    TextSearchFacetConfig _config = new TextSearchFacetConfig();
    protected int _cellIndex;
    protected Pattern _pattern;
    protected String _query;

    @JsonProperty(value="name")
    public String getName() {
        return this._config._name;
    }

    @JsonProperty(value="columnName")
    public String getColumnName() {
        return this._config._columnName;
    }

    @JsonProperty(value="query")
    public String getQuery() {
        return this._config._query;
    }

    @JsonProperty(value="mode")
    public String getMode() {
        return this._config._mode;
    }

    @JsonProperty(value="caseSensitive")
    public boolean isCaseSensitive() {
        return this._config._caseSensitive;
    }

    @JsonProperty(value="invert")
    public boolean isInverted() {
        return this._config._invert;
    }

    public void initializeFromConfig(TextSearchFacetConfig config, Project project) {
        this._config = config;
        Column column = project.columnModel.getColumnByName(this._config._columnName);
        this._cellIndex = column != null ? column.getCellIndex() : -1;
        this._query = this._config._query;
        if (this._query != null) {
            if ("regex".equals(this._config._mode)) {
                try {
                    this._pattern = Pattern.compile(this._query, this._config._caseSensitive ? 0 : 2);
                }
                catch (PatternSyntaxException e) {
                    PatternSyntaxExceptionParser err = new PatternSyntaxExceptionParser(e);
                    throw new IllegalArgumentException(err.getUserMessage());
                }
            } else if (!this._config._caseSensitive) {
                this._query = this._query.toLowerCase();
            }
        }
    }

    @Override
    public RowFilter getRowFilter(Project project) {
        if (this._query == null || this._query.length() == 0 || this._cellIndex < 0) {
            return null;
        }
        if ("regex".equals(this._config._mode) && this._pattern == null) {
            return null;
        }
        Evaluable eval = new Evaluable(){

            @Override
            public Object evaluate(Properties bindings) {
                return bindings.get("value");
            }

            @Override
            public String getSource() {
                return "value";
            }

            @Override
            public String getLanguagePrefix() {
                return "grel";
            }
        };
        if ("regex".equals(this._config._mode)) {
            return new ExpressionStringComparisonRowFilter(eval, this._config._invert, this._config._columnName, this._cellIndex){

                @Override
                protected boolean checkValue(String s) {
                    return TextSearchFacet.this._pattern.matcher(s).find();
                }
            };
        }
        return new ExpressionStringComparisonRowFilter(eval, this._config._invert, this._config._columnName, this._cellIndex){

            @Override
            protected boolean checkValue(String s) {
                return (TextSearchFacet.this._config._caseSensitive ? s : s.toLowerCase()).contains(TextSearchFacet.this._query);
            }
        };
    }

    @Override
    public RecordFilter getRecordFilter(Project project) {
        RowFilter rowFilter = this.getRowFilter(project);
        return rowFilter == null ? null : new AnyRowRecordFilter(rowFilter);
    }

    @Override
    public void computeChoices(Project project, FilteredRows filteredRows) {
    }

    @Override
    public void computeChoices(Project project, FilteredRecords filteredRecords) {
    }

    public static class TextSearchFacetConfig
    implements FacetConfig {
        @JsonProperty(value="name")
        protected String _name;
        @JsonProperty(value="columnName")
        protected String _columnName;
        @JsonProperty(value="query")
        protected String _query = null;
        @JsonProperty(value="mode")
        protected String _mode;
        @JsonProperty(value="caseSensitive")
        protected boolean _caseSensitive;
        @JsonProperty(value="invert")
        protected boolean _invert;

        @Override
        public TextSearchFacet apply(Project project) {
            TextSearchFacet facet = new TextSearchFacet();
            facet.initializeFromConfig(this, project);
            return facet;
        }

        @Override
        public String getJsonType() {
            return "text";
        }

        @Override
        public void validate() {
            if ("regex".equals(this._mode)) {
                try {
                    Pattern.compile(this._query, this._caseSensitive ? 0 : 2);
                }
                catch (PatternSyntaxException e) {
                    throw new IllegalArgumentException(e);
                }
            }
        }

        @Override
        public Optional<Set<String>> getColumnDependencies() {
            return Optional.of(Collections.singleton(this._columnName));
        }
    }
}

