/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.browsing.facets;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.refine.browsing.FilteredRecords;
import com.google.refine.browsing.FilteredRows;
import com.google.refine.browsing.RecordFilter;
import com.google.refine.browsing.RowFilter;
import com.google.refine.browsing.facets.Facet;
import com.google.refine.browsing.facets.FacetConfig;
import com.google.refine.browsing.filters.AnyRowRecordFilter;
import com.google.refine.browsing.filters.ExpressionNumberComparisonRowFilter;
import com.google.refine.browsing.util.ExpressionBasedRowEvaluable;
import com.google.refine.browsing.util.ExpressionNumericValueBinner;
import com.google.refine.browsing.util.NumericBinIndex;
import com.google.refine.browsing.util.NumericBinRecordIndex;
import com.google.refine.browsing.util.NumericBinRowIndex;
import com.google.refine.browsing.util.RowEvaluable;
import com.google.refine.expr.Evaluable;
import com.google.refine.expr.MetaParser;
import com.google.refine.expr.ParsingException;
import com.google.refine.model.Column;
import com.google.refine.model.Project;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;

public class RangeFacet
implements Facet {
    public static final String ERR_NO_NUMERIC_VALUE_PRESENT = "No numeric value present.";
    RangeFacetConfig _config = null;
    protected int _cellIndex;
    protected Evaluable _eval;
    protected String _errorMessage;
    protected double _min;
    protected double _max;
    protected double _step;
    protected int[] _baseBins;
    protected int[] _bins;
    @JsonProperty(value="baseNumericCount")
    protected int _baseNumericCount;
    @JsonProperty(value="baseNonNumericCount")
    protected int _baseNonNumericCount;
    @JsonProperty(value="baseBlankCount")
    protected int _baseBlankCount;
    @JsonProperty(value="baseErrorCount")
    protected int _baseErrorCount;
    @JsonProperty(value="numericCount")
    protected int _numericCount;
    @JsonProperty(value="nonNumericCount")
    protected int _nonNumericCount;
    @JsonProperty(value="blankCount")
    protected int _blankCount;
    @JsonProperty(value="errorCount")
    protected int _errorCount;
    protected static final String MIN = "min";
    protected static final String MAX = "max";
    protected static final String TO = "to";
    protected static final String FROM = "from";

    @JsonProperty(value="name")
    public String getName() {
        return this._config._name;
    }

    @JsonProperty(value="expression")
    public String getExpression() {
        return this._config._expression;
    }

    @JsonProperty(value="columnName")
    public String getColumnName() {
        return this._config._columnName;
    }

    @JsonProperty(value="error")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getError() {
        if (this._errorMessage != null) {
            return this._errorMessage;
        }
        if (!this.isFiniteRange()) {
            return ERR_NO_NUMERIC_VALUE_PRESENT;
        }
        return null;
    }

    @JsonIgnore
    public boolean isFiniteRange() {
        return !Double.isInfinite(this._min) && !Double.isInfinite(this._max);
    }

    @JsonProperty(value="min")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Double getMin() {
        if (this.getError() == null) {
            return this._min;
        }
        return null;
    }

    @JsonProperty(value="max")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Double getMax() {
        if (this.getError() == null) {
            return this._max;
        }
        return null;
    }

    @JsonProperty(value="step")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Double getStep() {
        if (this.getError() == null) {
            return this._step;
        }
        return null;
    }

    @JsonProperty(value="bins")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public int[] getBins() {
        if (this.getError() == null) {
            return this._bins;
        }
        return null;
    }

    @JsonProperty(value="baseBins")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public int[] getBaseBins() {
        if (this.getError() == null) {
            return this._baseBins;
        }
        return null;
    }

    @JsonProperty(value="from")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Double getFrom() {
        if (this.getError() == null) {
            return this._config._from;
        }
        return null;
    }

    @JsonProperty(value="to")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Double getTo() {
        if (this.getError() == null) {
            return this._config._to;
        }
        return null;
    }

    public void initializeFromConfig(RangeFacetConfig config, Project project) {
        this._config = config;
        if (this._config._columnName.length() > 0) {
            Column column = project.columnModel.getColumnByName(this._config._columnName);
            if (column != null) {
                this._cellIndex = column.getCellIndex();
            } else {
                this._errorMessage = "No column named " + this._config._columnName;
            }
        } else {
            this._cellIndex = -1;
        }
        try {
            this._eval = MetaParser.parse(this._config._expression);
        }
        catch (ParsingException e) {
            this._errorMessage = e.getMessage();
        }
    }

    @Override
    public RowFilter getRowFilter(Project project) {
        if (this._eval != null && this._errorMessage == null && this._config._selected) {
            return new ExpressionNumberComparisonRowFilter(this.getRowEvaluable(project), this._config._selectNumeric, this._config._selectNonNumeric, this._config._selectBlank, this._config._selectError){

                @Override
                protected boolean checkValue(double d) {
                    return d >= RangeFacet.this._config._from && d < RangeFacet.this._config._to;
                }
            };
        }
        return null;
    }

    @Override
    public RecordFilter getRecordFilter(Project project) {
        RowFilter rowFilter = this.getRowFilter(project);
        return rowFilter == null ? null : new AnyRowRecordFilter(rowFilter);
    }

    @Override
    public void computeChoices(Project project, FilteredRows filteredRows) {
        if (this._eval != null && this._errorMessage == null) {
            String key;
            RowEvaluable rowEvaluable = this.getRowEvaluable(project);
            Column column = project.columnModel.getColumnByCellIndex(this._cellIndex);
            NumericBinIndex index = (NumericBinIndex)column.getPrecompute(key = "numeric-bin:row-based:" + this._config._expression);
            if (index == null) {
                index = new NumericBinRowIndex(project, rowEvaluable);
                column.setPrecompute(key, index);
            }
            this.retrieveDataFromBaseBinIndex(index);
            ExpressionNumericValueBinner binner = new ExpressionNumericValueBinner(rowEvaluable, index);
            filteredRows.accept(project, binner);
            this.retrieveDataFromBinner(binner);
        }
    }

    @Override
    public void computeChoices(Project project, FilteredRecords filteredRecords) {
        if (this._eval != null && this._errorMessage == null) {
            String key;
            RowEvaluable rowEvaluable = this.getRowEvaluable(project);
            Column column = project.columnModel.getColumnByCellIndex(this._cellIndex);
            NumericBinIndex index = (NumericBinIndex)column.getPrecompute(key = "numeric-bin:record-based:" + this._config._expression);
            if (index == null) {
                index = new NumericBinRecordIndex(project, rowEvaluable);
                column.setPrecompute(key, index);
            }
            this.retrieveDataFromBaseBinIndex(index);
            ExpressionNumericValueBinner binner = new ExpressionNumericValueBinner(rowEvaluable, index);
            filteredRecords.accept(project, binner);
            this.retrieveDataFromBinner(binner);
        }
    }

    protected RowEvaluable getRowEvaluable(Project project) {
        return new ExpressionBasedRowEvaluable(this._config._columnName, this._cellIndex, this._eval);
    }

    protected void retrieveDataFromBaseBinIndex(NumericBinIndex index) {
        this._min = index.getMin();
        this._max = index.getMax();
        this._step = index.getStep();
        this._baseBins = index.getBins();
        this._baseNumericCount = index.getNumericRowCount();
        this._baseNonNumericCount = index.getNonNumericRowCount();
        this._baseBlankCount = index.getBlankRowCount();
        this._baseErrorCount = index.getErrorRowCount();
        if (this._config._selected) {
            this._config._from = Math.max(this._config._from, this._min);
            this._config._to = Math.min(this._config._to, this._max);
        } else {
            this._config._from = this._min;
            this._config._to = this._max;
        }
    }

    protected void retrieveDataFromBinner(ExpressionNumericValueBinner binner) {
        this._bins = binner.bins;
        this._numericCount = binner.numericCount;
        this._nonNumericCount = binner.nonNumericCount;
        this._blankCount = binner.blankCount;
        this._errorCount = binner.errorCount;
    }

    public static class RangeFacetConfig
    implements FacetConfig {
        @JsonProperty(value="name")
        protected String _name;
        @JsonProperty(value="expression")
        protected String _expression;
        @JsonProperty(value="columnName")
        protected String _columnName;
        @JsonProperty(value="from")
        protected double _from;
        @JsonProperty(value="to")
        protected double _to;
        @JsonProperty(value="selectNumeric")
        protected boolean _selectNumeric;
        @JsonProperty(value="selectNonNumeric")
        protected boolean _selectNonNumeric;
        @JsonProperty(value="selectBlank")
        protected boolean _selectBlank;
        @JsonProperty(value="selectError")
        protected boolean _selectError;
        @JsonIgnore
        protected boolean _selected;

        @JsonCreator
        public RangeFacetConfig(@JsonProperty(value="name") String name, @JsonProperty(value="expression") String expression, @JsonProperty(value="columnName") String columnName, @JsonProperty(value="from") Double from, @JsonProperty(value="to") Double to, @JsonProperty(value="selectNumeric") Boolean selectNumeric, @JsonProperty(value="selectNonNumeric") Boolean selectNonNumeric, @JsonProperty(value="selectBlank") Boolean selectBlank, @JsonProperty(value="selectError") Boolean selectError) {
            this._name = name;
            this._expression = expression;
            this._columnName = columnName;
            this._from = from == null ? 0.0 : from;
            this._to = to == null ? 0.0 : to;
            this._selectNumeric = selectNumeric == null ? true : selectNumeric;
            this._selectNonNumeric = selectNonNumeric == null ? true : selectNonNumeric;
            this._selectBlank = selectBlank == null ? true : selectBlank;
            this._selectError = selectError == null ? true : selectError;
            this._selected = !this._selectNumeric || !this._selectNonNumeric || !this._selectBlank || !this._selectError || from != null || to != null;
        }

        @Override
        public RangeFacet apply(Project project) {
            RangeFacet facet = new RangeFacet();
            facet.initializeFromConfig(this, project);
            return facet;
        }

        @Override
        public String getJsonType() {
            return "range";
        }

        @Override
        public void validate() {
            try {
                MetaParser.parse(this._expression);
            }
            catch (ParsingException e) {
                throw new IllegalArgumentException(e);
            }
        }

        @Override
        public Optional<Set<String>> getColumnDependencies() {
            try {
                return MetaParser.parse(this._expression).getColumnDependencies(Optional.of(this._columnName));
            }
            catch (ParsingException e) {
                return Optional.of(Collections.emptySet());
            }
        }
    }
}

