/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.browsing.facets;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.refine.ProjectManager;
import com.google.refine.browsing.DecoratedValue;
import com.google.refine.browsing.FilteredRecords;
import com.google.refine.browsing.FilteredRows;
import com.google.refine.browsing.RecordFilter;
import com.google.refine.browsing.RowFilter;
import com.google.refine.browsing.facets.Facet;
import com.google.refine.browsing.facets.FacetConfig;
import com.google.refine.browsing.facets.NominalFacetChoice;
import com.google.refine.browsing.filters.AllRowsRecordFilter;
import com.google.refine.browsing.filters.AnyRowRecordFilter;
import com.google.refine.browsing.filters.ExpressionEqualRowFilter;
import com.google.refine.browsing.util.ExpressionNominalValueGrouper;
import com.google.refine.expr.Evaluable;
import com.google.refine.expr.MetaParser;
import com.google.refine.expr.ParsingException;
import com.google.refine.model.Column;
import com.google.refine.model.Project;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class ListFacet
implements Facet {
    public static final String ERR_TOO_MANY_CHOICES = "Too many choices";
    ListFacetConfig _config = new ListFacetConfig();
    protected int _cellIndex;
    protected Evaluable _eval;
    protected String _errorMessage;
    protected List<NominalFacetChoice> _choices = new LinkedList<NominalFacetChoice>();
    protected int _blankCount;
    protected int _errorCount;

    @JsonProperty(value="name")
    public String getName() {
        return this._config.name;
    }

    @JsonProperty(value="columnName")
    public String getColumnName() {
        return this._config.columnName;
    }

    @JsonProperty(value="expression")
    public String getExpression() {
        return this._config.expression;
    }

    @JsonProperty(value="invert")
    public boolean getInvert() {
        return this._config.invert;
    }

    @JsonProperty(value="error")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getError() {
        if (this._errorMessage == null && this._choices.size() > this.getLimit()) {
            return ERR_TOO_MANY_CHOICES;
        }
        return this._errorMessage;
    }

    @JsonProperty(value="choiceCount")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Integer getChoiceCount() {
        if (this._errorMessage == null && this._choices.size() > this.getLimit()) {
            return this._choices.size();
        }
        return null;
    }

    @JsonProperty(value="choices")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<NominalFacetChoice> getChoices() {
        if (this.getError() == null) {
            return this._choices;
        }
        return null;
    }

    @JsonProperty(value="blankChoice")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public OtherChoice getBlankChoice() {
        if (this.getError() == null && !this._config.omitBlank && (this._config.selectBlank || this._blankCount > 0)) {
            return new OtherChoice(this._config.selectBlank, this._blankCount);
        }
        return null;
    }

    @JsonProperty(value="errorChoice")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public OtherChoice getErrorChoice() {
        if (this.getError() == null && !this._config.omitError && (this._config.selectError || this._errorCount > 0)) {
            return new OtherChoice(this._config.selectError, this._errorCount);
        }
        return null;
    }

    protected int getLimit() {
        Object v = ProjectManager.singleton.getPreferenceStore().get("ui.browsing.listFacet.limit");
        if (v != null) {
            if (v instanceof Number) {
                return ((Number)v).intValue();
            }
            try {
                int n = Integer.parseInt(v.toString());
                return n;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 2000;
    }

    public void initializeFromConfig(ListFacetConfig config, Project project) {
        this._config = config;
        if (this._config.columnName.length() > 0) {
            Column column = project.columnModel.getColumnByName(this._config.columnName);
            if (column != null) {
                this._cellIndex = column.getCellIndex();
            } else {
                this._errorMessage = "No column named " + this._config.columnName;
            }
        } else {
            this._cellIndex = -1;
        }
        try {
            this._eval = MetaParser.parse(this._config.expression);
        }
        catch (ParsingException e) {
            this._errorMessage = e.getMessage();
        }
    }

    @Override
    public RowFilter getRowFilter(Project project) {
        return this._eval == null || this._errorMessage != null || this._config.selection.size() == 0 && !this._config.selectBlank && !this._config.selectError ? null : new ExpressionEqualRowFilter(this._eval, this._config.columnName, this._cellIndex, this.createMatches(), this._config.selectBlank, this._config.selectError, this._config.invert);
    }

    @Override
    public RecordFilter getRecordFilter(Project project) {
        RowFilter rowFilter = this.getRowFilter(project);
        return rowFilter == null ? null : (this._config.invert ? new AllRowsRecordFilter(rowFilter) : new AnyRowRecordFilter(rowFilter));
    }

    @Override
    public void computeChoices(Project project, FilteredRows filteredRows) {
        if (this._eval != null && this._errorMessage == null) {
            ExpressionNominalValueGrouper grouper = new ExpressionNominalValueGrouper(this._eval, this._config.columnName, this._cellIndex);
            filteredRows.accept(project, grouper);
            this.postProcessGrouper(grouper);
        }
    }

    @Override
    public void computeChoices(Project project, FilteredRecords filteredRecords) {
        if (this._eval != null && this._errorMessage == null) {
            ExpressionNominalValueGrouper grouper = new ExpressionNominalValueGrouper(this._eval, this._config.columnName, this._cellIndex);
            filteredRecords.accept(project, grouper);
            this.postProcessGrouper(grouper);
        }
    }

    protected void postProcessGrouper(ExpressionNominalValueGrouper grouper) {
        this._choices.clear();
        this._choices.addAll(grouper.choices.values());
        for (DecoratedValue decoratedValue : this._config.selection) {
            String valueString = decoratedValue.value.toString();
            if (grouper.choices.containsKey(valueString)) {
                grouper.choices.get((Object)valueString).selected = true;
                continue;
            }
            NominalFacetChoice choice = new NominalFacetChoice(decoratedValue);
            choice.count = 0;
            choice.selected = true;
            this._choices.add(choice);
        }
        this._blankCount = grouper.blankCount;
        this._errorCount = grouper.errorCount;
    }

    protected Object[] createMatches() {
        Object[] a = new Object[this._config.selection.size()];
        for (int i = 0; i < a.length; ++i) {
            a[i] = this._config.selection.get((int)i).value;
        }
        return a;
    }

    public static class ListFacetConfig
    implements FacetConfig {
        @JsonProperty(value="name")
        public String name;
        @JsonProperty(value="expression")
        public String expression;
        @JsonProperty(value="columnName")
        public String columnName;
        @JsonProperty(value="invert")
        public boolean invert;
        @JsonProperty(value="omitBlank")
        public boolean omitBlank;
        @JsonProperty(value="omitError")
        public boolean omitError;
        @JsonIgnore
        public List<DecoratedValue> selection = new LinkedList<DecoratedValue>();
        @JsonProperty(value="selectBlank")
        public boolean selectBlank;
        @JsonProperty(value="selectError")
        public boolean selectError;

        @JsonProperty(value="selection")
        public List<DecoratedValueWrapper> getWrappedSelection() {
            return this.selection.stream().map(e -> new DecoratedValueWrapper((DecoratedValue)e)).collect(Collectors.toList());
        }

        @JsonProperty(value="selection")
        public void setSelection(List<DecoratedValueWrapper> wrapped) {
            this.selection = wrapped.stream().map(e -> e.value).collect(Collectors.toList());
        }

        @Override
        public Facet apply(Project project) {
            ListFacet facet = new ListFacet();
            facet.initializeFromConfig(this, project);
            return facet;
        }

        @Override
        public String getJsonType() {
            return "list";
        }

        @Override
        public void validate() {
            try {
                MetaParser.parse(this.expression);
            }
            catch (ParsingException e) {
                throw new IllegalArgumentException(e);
            }
        }

        @Override
        public Optional<Set<String>> getColumnDependencies() {
            try {
                return MetaParser.parse(this.expression).getColumnDependencies(Optional.of(this.columnName));
            }
            catch (ParsingException e) {
                return Optional.of(Collections.emptySet());
            }
        }
    }

    public static class OtherChoice {
        @JsonProperty(value="s")
        boolean selected;
        @JsonProperty(value="c")
        int count;

        public OtherChoice(@JsonProperty(value="s") boolean selected, @JsonProperty(value="c") int count) {
            this.selected = selected;
            this.count = count;
        }
    }

    public static class DecoratedValueWrapper {
        @JsonProperty(value="v")
        public final DecoratedValue value;

        @JsonCreator
        public DecoratedValueWrapper(@JsonProperty(value="v") DecoratedValue value) {
            this.value = value;
        }
    }
}

