/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.browsing;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.refine.browsing.EngineConfig;
import com.google.refine.browsing.FilteredRecords;
import com.google.refine.browsing.FilteredRows;
import com.google.refine.browsing.RecordFilter;
import com.google.refine.browsing.RecordVisitor;
import com.google.refine.browsing.RowFilter;
import com.google.refine.browsing.RowVisitor;
import com.google.refine.browsing.facets.Facet;
import com.google.refine.browsing.util.ConjunctiveFilteredRecords;
import com.google.refine.browsing.util.ConjunctiveFilteredRows;
import com.google.refine.browsing.util.FilteredRecordsAsFilteredRows;
import com.google.refine.model.Project;
import com.google.refine.model.Record;
import com.google.refine.model.Row;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;

public class Engine {
    public static final String INCLUDE_DEPENDENT = "includeDependent";
    public static final String MODE = "mode";
    public static final String MODE_ROW_BASED = "row-based";
    public static final String MODE_RECORD_BASED = "record-based";
    @JsonIgnore
    protected Project _project;
    @JsonProperty(value="facets")
    protected List<Facet> _facets = new LinkedList<Facet>();
    @JsonIgnore
    protected EngineConfig _config = new EngineConfig(Collections.emptyList(), Mode.RowBased);

    public static String modeToString(Mode mode) {
        return mode == Mode.RowBased ? MODE_ROW_BASED : MODE_RECORD_BASED;
    }

    public static Mode stringToMode(String s) {
        return MODE_ROW_BASED.equals(s) ? Mode.RowBased : Mode.RecordBased;
    }

    public Engine(Project project) {
        this._project = project;
    }

    @JsonProperty(value="engine-mode")
    public Mode getMode() {
        return this._config.getMode();
    }

    public void setMode(Mode mode) {
        this._config = new EngineConfig(this._config.getFacetConfigs(), mode);
    }

    @JsonIgnore
    public FilteredRows getAllRows() {
        return new FilteredRows(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void accept(Project project, RowVisitor visitor) {
                try {
                    visitor.start(project);
                    int c = project.rows.size();
                    for (int rowIndex = 0; rowIndex < c; ++rowIndex) {
                        Row row = project.rows.get(rowIndex);
                        if (!visitor.visit(project, rowIndex, rowIndex, row)) continue;
                        break;
                    }
                }
                finally {
                    visitor.end(project);
                }
            }
        };
    }

    @JsonIgnore
    public FilteredRows getAllFilteredRows() {
        return this.getFilteredRows(null);
    }

    public FilteredRows getFilteredRows(Facet except) {
        if (this._config.getMode().equals((Object)Mode.RecordBased)) {
            return new FilteredRecordsAsFilteredRows(this.getFilteredRecords(except));
        }
        if (this._config.getMode().equals((Object)Mode.RowBased)) {
            ConjunctiveFilteredRows cfr = new ConjunctiveFilteredRows();
            for (Facet facet : this._facets) {
                RowFilter rowFilter;
                if (facet == except || (rowFilter = facet.getRowFilter(this._project)) == null) continue;
                cfr.add(rowFilter);
            }
            return cfr;
        }
        throw new InternalError("Unknown mode.");
    }

    @JsonIgnore
    public FilteredRecords getAllRecords() {
        return new FilteredRecords(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void accept(Project project, RecordVisitor visitor) {
                try {
                    visitor.start(project);
                    int c = project.recordModel.getRecordCount();
                    for (int r = 0; r < c; ++r) {
                        Record record = project.recordModel.getRecord(r);
                        visitor.visit(project, record.fromRowIndex, record);
                    }
                }
                finally {
                    visitor.end(project);
                }
            }
        };
    }

    @JsonIgnore
    public FilteredRecords getFilteredRecords() {
        return this.getFilteredRecords(null);
    }

    public FilteredRecords getFilteredRecords(Facet except) {
        if (this._config.getMode().equals((Object)Mode.RecordBased)) {
            ConjunctiveFilteredRecords cfr = new ConjunctiveFilteredRecords();
            for (Facet facet : this._facets) {
                RecordFilter recordFilter;
                if (facet == except || (recordFilter = facet.getRecordFilter(this._project)) == null) continue;
                cfr.add(recordFilter);
            }
            return cfr;
        }
        throw new InternalError("This method should not be called when the engine is not in record mode.");
    }

    public void initializeFromConfig(EngineConfig config) {
        this._config = config;
        this._facets = config.getFacetConfigs().stream().map(c -> c.apply(this._project)).collect(Collectors.toList());
    }

    public void computeFacets() {
        if (this._config.getMode().equals((Object)Mode.RowBased)) {
            for (Facet facet : this._facets) {
                FilteredRows filteredRows = this.getFilteredRows(facet);
                facet.computeChoices(this._project, filteredRows);
            }
        } else if (this._config.getMode().equals((Object)Mode.RecordBased)) {
            for (Facet facet : this._facets) {
                FilteredRecords filteredRecords = this.getFilteredRecords(facet);
                facet.computeChoices(this._project, filteredRecords);
            }
        } else {
            throw new InternalError("Unknown mode.");
        }
    }

    public static enum Mode {
        RowBased,
        RecordBased;

    }
}

