/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.refine.ProjectManager;
import com.google.refine.commands.Command;
import com.google.refine.importing.ImportingManager;
import com.google.refine.io.FileProjectManager;
import edu.mit.simile.butterfly.Butterfly;
import edu.mit.simile.butterfly.ButterflyModule;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RefineServlet
extends Butterfly {
    private static String ASSIGNED_VERSION = "3.9.3";
    public static String VERSION = "";
    public static String REVISION = "";
    public static String FULL_VERSION = "";
    public static String FULLNAME = "OpenRefine ";
    static final long serialVersionUID = 2386057901503517403L;
    private static final String JAVAX_SERVLET_CONTEXT_TEMPDIR = "javax.servlet.context.tempdir";
    private File tempDir = null;
    private static RefineServlet s_singleton;
    private static File s_dataDir;
    private static final Map<String, Command> commands;
    private static ScheduledExecutorService service;
    static final Logger logger;
    private static final List<ClassMapping> classMappings;
    private static final Map<String, String> classMappingsCache;
    private static final Map<String, Class<?>> classCache;

    public void init() throws ServletException {
        super.init();
        VERSION = this.getInitParameter("refine.version");
        REVISION = this.getInitParameter("refine.revision");
        if (VERSION.equals("$VERSION")) {
            VERSION = ASSIGNED_VERSION;
        }
        if (REVISION.equals("$REVISION")) {
            ClassLoader classLoader = ((Object)((Object)this)).getClass().getClassLoader();
            try {
                InputStream gitStats = classLoader.getResourceAsStream("git.properties");
                ObjectMapper mapper = new ObjectMapper();
                ObjectNode parsedGit = (ObjectNode)mapper.readValue(gitStats, ObjectNode.class);
                REVISION = parsedGit.get("git.commit.id.abbrev").asText("TRUNK");
            }
            catch (IOException e) {
                REVISION = "TRUNK";
            }
        }
        FULL_VERSION = VERSION + " [" + REVISION + "]";
        FULLNAME = FULLNAME + FULL_VERSION;
        logger.info("Starting {} ...", (Object)FULLNAME);
        s_singleton = this;
        logger.trace("> initialize");
        String data = this.getInitParameter("refine.data");
        if (data == null) {
            throw new ServletException("can't find servlet init config 'refine.data', I have to give up initializing");
        }
        logger.info("Initializing FileProjectManager with data dir: {}", (Object)data);
        s_dataDir = new File(data);
        FileProjectManager.initialize(s_dataDir);
        ImportingManager.initialize(this);
        long AUTOSAVE_PERIOD = Long.parseLong(this.getInitParameter("refine.autosave"));
        service.scheduleWithFixedDelay(new AutoSaveTimerTask(), AUTOSAVE_PERIOD, AUTOSAVE_PERIOD, TimeUnit.MINUTES);
        logger.trace("< initialize");
    }

    public void destroy() {
        logger.trace("> destroy");
        if (this._timer != null) {
            this._timer.cancel();
            this._timer = null;
        }
        if (ProjectManager.singleton != null) {
            ProjectManager.singleton.dispose();
            ProjectManager.singleton = null;
        }
        logger.trace("< destroy");
        super.destroy();
    }

    public void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (request.getPathInfo().startsWith("/command/")) {
            String commandKey = this.getCommandKey(request);
            Command command = commands.get(commandKey);
            if (command != null) {
                if (request.getMethod().equals("GET")) {
                    if (!logger.isTraceEnabled() && command.logRequests()) {
                        logger.info("GET {}", (Object)request.getPathInfo());
                    }
                    logger.trace("> GET {}", (Object)commandKey);
                    command.doGet(request, response);
                    logger.trace("< GET {}", (Object)commandKey);
                } else if (request.getMethod().equals("POST")) {
                    if (!logger.isTraceEnabled() && command.logRequests()) {
                        logger.info("POST {}", (Object)request.getPathInfo());
                    }
                    logger.trace("> POST {}", (Object)commandKey);
                    command.doPost(request, response);
                    logger.trace("< POST {}", (Object)commandKey);
                } else if (request.getMethod().equals("PUT")) {
                    if (!logger.isTraceEnabled() && command.logRequests()) {
                        logger.info("PUT {}", (Object)request.getPathInfo());
                    }
                    logger.trace("> PUT {}", (Object)commandKey);
                    command.doPut(request, response);
                    logger.trace("< PUT {}", (Object)commandKey);
                } else if (request.getMethod().equals("DELETE")) {
                    if (!logger.isTraceEnabled() && command.logRequests()) {
                        logger.info("DELETE {}", (Object)request.getPathInfo());
                    }
                    logger.trace("> DELETE {}", (Object)commandKey);
                    command.doDelete(request, response);
                    logger.trace("< DELETE {}", (Object)commandKey);
                } else if (request.getMethod().equals("HEAD")) {
                    if (!logger.isTraceEnabled() && command.logRequests()) {
                        logger.info("HEAD {}", (Object)request.getPathInfo());
                    }
                    logger.trace("> HEAD {}", (Object)commandKey);
                    command.doHead(request, response);
                    logger.trace("< HEAD {}", (Object)commandKey);
                } else {
                    response.sendError(405);
                }
            } else {
                response.sendError(404);
            }
        } else {
            super.service(request, response);
        }
    }

    public ButterflyModule getModule(String name) {
        return (ButterflyModule)this._modulesByName.get(name);
    }

    public String[] getModuleNames() {
        return (String[])this._modulesByName.keySet().stream().sorted().toArray(String[]::new);
    }

    protected String getCommandKey(HttpServletRequest request) {
        int slash2;
        String path = request.getPathInfo().substring("/command/".length());
        int slash1 = path.indexOf(47);
        if (slash1 >= 0 && (slash2 = path.indexOf(47, slash1 + 1)) > 0) {
            path = path.substring(0, slash2);
        }
        return path;
    }

    public File getTempDir() {
        if (this.tempDir == null) {
            this.tempDir = (File)this._config.getServletContext().getAttribute(JAVAX_SERVLET_CONTEXT_TEMPDIR);
            if (this.tempDir == null) {
                throw new RuntimeException("This app server doesn't support temp directories");
            }
        }
        return this.tempDir;
    }

    public File getTempFile(String name) {
        return new File(this.getTempDir(), name);
    }

    public File getCacheDir(String name) {
        File dir = new File(new File(s_dataDir, "cache"), name);
        dir.mkdirs();
        return dir;
    }

    public String getConfiguration(String name, String def) {
        return null;
    }

    protected boolean registerOneCommand(ButterflyModule module, String name, Command commandObject) {
        return this.registerOneCommand(module.getName() + "/" + name, commandObject);
    }

    protected boolean registerOneCommand(String path, Command commandObject) {
        if (commands.containsKey(path)) {
            return false;
        }
        commandObject.init(this);
        commands.put(path, commandObject);
        return true;
    }

    protected boolean unregisterCommand(String verb) {
        return commands.remove(verb) != null;
    }

    public static boolean registerCommand(ButterflyModule module, String commandName, Command commandObject) {
        return s_singleton.registerOneCommand(module, commandName, commandObject);
    }

    public static void registerClassMapping(String from, String to) {
        classMappings.add(new ClassMapping(from, to.endsWith("*") ? to.substring(0, to.length() - 1) : to));
    }

    public static void cacheClass(Class<?> klass) {
        classCache.put(klass.getName(), klass);
    }

    public static Class<?> getClass(String className) throws ClassNotFoundException {
        Class<?> klass;
        Object toClassName = classMappingsCache.get(className);
        if (toClassName == null) {
            toClassName = className;
            for (ClassMapping m : classMappings) {
                if (m.from.endsWith("*")) {
                    if (!((String)toClassName).startsWith(m.from.substring(0, m.from.length() - 1))) continue;
                    toClassName = m.to + ((String)toClassName).substring(m.from.length() - 1);
                    continue;
                }
                if (!m.from.equals(toClassName)) continue;
                toClassName = m.to;
            }
            classMappingsCache.put(className, (String)toClassName);
        }
        if ((klass = classCache.get(toClassName)) == null) {
            klass = Class.forName((String)toClassName);
            classCache.put((String)toClassName, klass);
        }
        return klass;
    }

    @Deprecated
    public static void setUserAgent(URLConnection urlConnection) {
        if (urlConnection instanceof HttpURLConnection) {
            RefineServlet.setUserAgent((HttpURLConnection)urlConnection);
        }
    }

    @Deprecated
    public static void setUserAgent(HttpURLConnection httpConnection) {
        httpConnection.addRequestProperty("User-Agent", RefineServlet.getUserAgent());
    }

    public static String getUserAgent() {
        return "OpenRefine/" + FULL_VERSION;
    }

    static {
        commands = new HashMap<String, Command>();
        service = Executors.newSingleThreadScheduledExecutor();
        logger = LoggerFactory.getLogger((String)"refine");
        classMappings = new ArrayList<ClassMapping>();
        RefineServlet.registerClassMapping("com.metaweb.*", "com.google.*");
        RefineServlet.registerClassMapping("com.google.gridworks.*", "com.google.refine.*");
        classMappingsCache = new HashMap<String, String>();
        classCache = new HashMap();
    }

    protected static class AutoSaveTimerTask
    implements Runnable {
        protected AutoSaveTimerTask() {
        }

        @Override
        public void run() {
            try {
                ProjectManager.singleton.save(false);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private static class ClassMapping {
        final String from;
        final String to;

        ClassMapping(String from, String to) {
            this.from = from;
            this.to = to;
        }
    }
}

