/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.refine.LookupCacheManager;
import com.google.refine.ProjectMetadata;
import com.google.refine.history.HistoryEntryManager;
import com.google.refine.model.Project;
import com.google.refine.preference.PreferenceStore;
import com.google.refine.preference.TopList;
import com.google.refine.util.GetProjectIDException;
import com.google.refine.util.ParsingUtilities;
import java.io.IOException;
import java.io.InputStream;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ProjectManager {
    public static final int EXPRESSION_HISTORY_MAX = 100;
    protected static final Duration PROJECT_FLUSH_DELAY = Duration.ofMinutes(15L);
    protected static final Duration QUICK_SAVE_MAX_TIME = Duration.ofSeconds(30L);
    protected Map<Long, ProjectMetadata> _projectsMetadata;
    private Map<String, Integer> _projectsTags;
    protected PreferenceStore _preferenceStore;
    final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected transient LookupCacheManager _lookupCacheManager = new LookupCacheManager();
    protected transient int _busy = 0;
    protected transient Map<Long, Project> _projects;
    public static ProjectManager singleton;

    protected ProjectManager() {
        this._projectsMetadata = new HashMap<Long, ProjectMetadata>();
        this._preferenceStore = new PreferenceStore();
        this._projects = new HashMap<Long, Project>();
        this._projectsTags = new HashMap<String, Integer>();
        ProjectManager.preparePreferenceStore(this._preferenceStore);
    }

    public void dispose() {
        this.save(true);
        for (Project project : this._projects.values()) {
            if (project == null) continue;
            project.dispose();
        }
        this._projects.clear();
        this._projectsMetadata.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerProject(Project project, ProjectMetadata projectMetadata) {
        ProjectManager projectManager = this;
        synchronized (projectManager) {
            projectMetadata.setRowCount(project.rows.size());
            this._projects.put(project.id, project);
            this._projectsMetadata.put(project.id, projectMetadata);
            this.addProjectTags(projectMetadata.getTags());
        }
    }

    public abstract boolean loadProjectMetadata(long var1);

    protected abstract Project loadProject(long var1);

    public abstract void importProject(long var1, InputStream var3, boolean var4) throws IOException;

    public abstract void exportProject(long var1, TarArchiveOutputStream var3) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ensureProjectSaved(long id) {
        ProjectManager projectManager = this;
        synchronized (projectManager) {
            Project project;
            ProjectMetadata metadata = this.getProjectMetadata(id);
            if (metadata != null) {
                try {
                    this.saveMetadata(metadata, id);
                }
                catch (Exception e) {
                    this.logger.error("Error saving project metadata", (Throwable)e);
                }
            }
            if ((project = this.getProject(id)) != null && metadata != null && metadata.getModified().isAfter(project.getLastSave())) {
                try {
                    this.saveProject(project);
                }
                catch (Exception e) {
                    this.logger.error("Error saving project ", (Throwable)e);
                }
            }
        }
    }

    public abstract void saveMetadata(ProjectMetadata var1, long var2) throws Exception;

    protected abstract void saveProject(Project var1) throws IOException;

    public void save(boolean allModified) {
        if (allModified || this._busy == 0) {
            this.saveProjects(allModified);
            this.saveWorkspace();
        }
    }

    protected abstract void saveWorkspace();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveProjects(boolean allModified) {
        ArrayList<SaveRecord> records = new ArrayList<SaveRecord>();
        Instant startTimeOfSave = Instant.now();
        Instant quicksaveDeadline = startTimeOfSave.plus(QUICK_SAVE_MAX_TIME);
        ProjectManager projectManager = this;
        synchronized (projectManager) {
            for (long id : this._projectsMetadata.keySet()) {
                boolean hasUnsavedChanges;
                ProjectMetadata metadata = this.getProjectMetadata(id);
                Project project = this._projects.get(id);
                if (project == null) continue;
                boolean bl = hasUnsavedChanges = metadata.getModified().isAfter(project.getLastSave()) || metadata.getModified().equals(project.getLastSave());
                if (hasUnsavedChanges) {
                    long msecsOverdue = Duration.between(startTimeOfSave, project.getLastSave()).toMillis();
                    records.add(new SaveRecord(project, msecsOverdue));
                    continue;
                }
                if (project.getProcessManager().hasPending() || !project.getLastSave().plus(PROJECT_FLUSH_DELAY).isBefore(startTimeOfSave)) continue;
                this._projects.remove(id).dispose();
            }
        }
        if (records.size() > 0) {
            records.sort((o1, o2) -> Long.compare(o2.overdue, o1.overdue));
            this.logger.info(allModified ? "Saving all modified projects ..." : "Saving some modified projects ...");
            for (SaveRecord record : records) {
                if (!allModified && Instant.now().isAfter(quicksaveDeadline)) break;
                try {
                    this.saveProject(record.project);
                }
                catch (Exception e) {
                    this.logger.error("Error when saving projects. Attempting to free memory", (Throwable)e);
                    this.disposeUnmodifiedProjects();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void disposeUnmodifiedProjects() {
        ProjectManager projectManager = this;
        synchronized (projectManager) {
            for (long id : this._projectsMetadata.keySet()) {
                ProjectMetadata metadata = this.getProjectMetadata(id);
                Project project = this._projects.get(id);
                if (project == null || project.getProcessManager().hasPending() || !project.getLastSave().isAfter(metadata.getModified())) continue;
                this._projects.remove(id).dispose();
            }
        }
    }

    @JsonIgnore
    public LookupCacheManager getLookupCacheManager() {
        return this._lookupCacheManager;
    }

    public ProjectMetadata getProjectMetadata(long id) {
        return this._projectsMetadata.get(id);
    }

    public ProjectMetadata getProjectMetadata(String name) {
        for (ProjectMetadata pm : this._projectsMetadata.values()) {
            if (!pm.getName().equals(name)) continue;
            return pm;
        }
        return null;
    }

    public long getProjectID(String name) throws GetProjectIDException {
        if (name == null) {
            throw new GetProjectIDException("Can't lookup a project with a null name");
        }
        Integer count = 0;
        Long id = -1L;
        for (Map.Entry<Long, ProjectMetadata> entry : this._projectsMetadata.entrySet()) {
            ProjectMetadata metadata = entry.getValue();
            if (metadata == null || !name.equals(metadata.getName())) continue;
            id = entry.getKey();
            count = count + 1;
        }
        if (count == 1) {
            return id;
        }
        if (count == 0) {
            throw new GetProjectIDException("Unable to find project with name: " + name);
        }
        throw new GetProjectIDException("Multiple (" + count + ") projects found with name: " + name);
    }

    private boolean isValidUserMetadataDefinition(ObjectNode placeHolderJsonObj) {
        return placeHolderJsonObj != null && placeHolderJsonObj.has("name") && placeHolderJsonObj.has("display");
    }

    public void mergeEmptyUserMetadata(ProjectMetadata metadata) {
        if (metadata == null) {
            return;
        }
        ArrayNode userMetadataPreference = null;
        ArrayNode jsonObjArray = metadata.getUserMetadata();
        this.initDisplay(jsonObjArray);
        String userMeta = (String)this._preferenceStore.get("userMetadata");
        if (userMeta == null) {
            return;
        }
        userMetadataPreference = ParsingUtilities.mapper.createArrayNode();
        for (int index = 0; index < userMetadataPreference.size(); ++index) {
            boolean found = false;
            ObjectNode placeHolderJsonObj = (ObjectNode)userMetadataPreference.get(index);
            if (!this.isValidUserMetadataDefinition(placeHolderJsonObj)) {
                this.logger.warn("Skipped invalid user metadata definition" + placeHolderJsonObj.toString());
                continue;
            }
            for (int i = 0; i < jsonObjArray.size(); ++i) {
                ObjectNode node;
                JsonNode jsonObj = jsonObjArray.get(i);
                if (!(jsonObj instanceof ObjectNode) || !(node = (ObjectNode)jsonObj).get("name").asText("").equals(placeHolderJsonObj.get("name").asText(""))) continue;
                found = true;
                node.set("display", placeHolderJsonObj.get("display"));
                break;
            }
            if (found) continue;
            placeHolderJsonObj.put("value", "");
            metadata.getUserMetadata().add((JsonNode)placeHolderJsonObj);
            this.logger.info("Put the placeholder {} for project {}", (Object)placeHolderJsonObj.get("name").asText(""), (Object)metadata.getName());
        }
    }

    private void initDisplay(ArrayNode jsonObjArray) {
        for (int index = 0; index < jsonObjArray.size(); ++index) {
            if (!(jsonObjArray.get(index) instanceof ObjectNode)) continue;
            ObjectNode projectMetaJsonObj = (ObjectNode)jsonObjArray.get(index);
            projectMetaJsonObj.put("display", false);
        }
    }

    @JsonIgnore
    public Map<Long, ProjectMetadata> getAllProjectMetadata() {
        for (Project project : this._projects.values()) {
            this.mergeEmptyUserMetadata(project.getMetadata());
        }
        return this._projectsMetadata;
    }

    public void addProjectTags(String[] tags) {
        if (tags != null) {
            for (String tag : tags) {
                if (this._projectsTags.containsKey(tag)) {
                    this._projectsTags.put(tag, this._projectsTags.get(tag) + 1);
                    continue;
                }
                this._projectsTags.put(tag, 1);
            }
        }
    }

    public void removeProjectTags(String[] tags) {
        for (String tag : tags) {
            if (!this._projectsTags.containsKey(tag)) continue;
            int occurrence = this._projectsTags.get(tag);
            if (occurrence <= 1) {
                this._projectsTags.remove(tag);
                continue;
            }
            this._projectsTags.put(tag, occurrence - 1);
        }
    }

    @JsonIgnore
    public Map<String, Integer> getAllProjectsTags() {
        return Collections.unmodifiableMap(this._projectsTags);
    }

    @Deprecated(since="3.8")
    @JsonIgnore
    public Map<String, Integer> getAllProjectTags() {
        return this._projectsTags;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Project getProject(long id) {
        ProjectManager projectManager = this;
        synchronized (projectManager) {
            if (this._projects.containsKey(id)) {
                return this._projects.get(id);
            }
            Project project = this.loadProject(id);
            if (project != null) {
                this._projects.put(id, project);
            }
            return project;
        }
    }

    @JsonProperty(value="preferences")
    public PreferenceStore getPreferenceStore() {
        return this._preferenceStore;
    }

    @JsonIgnore
    public List<String> getExpressions() {
        return ((TopList)this._preferenceStore.get("scripting.expressions")).getList();
    }

    @JsonIgnore
    public abstract HistoryEntryManager getHistoryEntryManager();

    public void deleteProject(Project project) {
        this.deleteProject(project.id);
    }

    public abstract void deleteProject(long var1);

    protected void removeProject(long projectID) {
        if (this._projects.containsKey(projectID)) {
            this._projects.remove(projectID).dispose();
        }
        this._projectsMetadata.remove(projectID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBusy(boolean busy) {
        ProjectManager projectManager = this;
        synchronized (projectManager) {
            this._busy = busy ? ++this._busy : --this._busy;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLatestExpression(String s) {
        ProjectManager projectManager = this;
        synchronized (projectManager) {
            ((TopList)this._preferenceStore.get("scripting.expressions")).add(s);
        }
    }

    protected static void preparePreferenceStore(PreferenceStore ps) {
        ps.put("scripting.expressions", new TopList(100));
        ps.put("scripting.starred-expressions", new TopList(Integer.MAX_VALUE));
    }

    protected static class SaveRecord {
        final Project project;
        final long overdue;

        SaveRecord(Project project, long overdue) {
            this.project = project;
            this.overdue = overdue;
        }
    }
}

