/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine;

import com.google.refine.ProjectManager;
import com.google.refine.ProjectMetadata;
import com.google.refine.expr.ExpressionUtils;
import com.google.refine.expr.HasFieldsListImpl;
import com.google.refine.expr.WrappedRow;
import com.google.refine.model.Column;
import com.google.refine.model.Project;
import com.google.refine.model.Row;
import com.google.refine.util.LookupException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class LookupCacheManager {
    public static final String INDEX_COLUMN_NAME = "_OpenRefine_Index_Column_Name_";
    protected final Map<String, ProjectLookup> _lookups = new HashMap<String, ProjectLookup>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProjectLookup getLookup(long targetProject, String targetColumn) throws LookupException {
        String key = targetProject + ";" + targetColumn;
        if (!this._lookups.containsKey(key)) {
            ProjectLookup lookup = new ProjectLookup(targetProject, targetColumn);
            this.computeLookup(lookup);
            Map<String, ProjectLookup> map = this._lookups;
            synchronized (map) {
                this._lookups.put(key, lookup);
            }
        }
        return this._lookups.get(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushLookupsInvolvingProject(long projectID) {
        Map<String, ProjectLookup> map = this._lookups;
        synchronized (map) {
            Iterator<Map.Entry<String, ProjectLookup>> it = this._lookups.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<String, ProjectLookup> entry = it.next();
                ProjectLookup lookup = entry.getValue();
                if (lookup.targetProjectID != projectID) continue;
                it.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushLookupsInvolvingProjectColumn(long projectID, String columnName) {
        Map<String, ProjectLookup> map = this._lookups;
        synchronized (map) {
            Iterator<Map.Entry<String, ProjectLookup>> it = this._lookups.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<String, ProjectLookup> entry = it.next();
                ProjectLookup lookup = entry.getValue();
                if (lookup.targetProjectID != projectID || !lookup.targetColumnName.equals(columnName)) continue;
                it.remove();
            }
        }
    }

    protected void computeLookup(ProjectLookup lookup) throws LookupException {
        if (lookup.targetProjectID < 0L) {
            return;
        }
        Project targetProject = ProjectManager.singleton.getProject(lookup.targetProjectID);
        ProjectMetadata targetProjectMetadata = ProjectManager.singleton.getProjectMetadata(lookup.targetProjectID);
        if (targetProject == null) {
            return;
        }
        if (INDEX_COLUMN_NAME.equals(lookup.targetColumnName)) {
            for (int r = 0; r < targetProject.rows.size(); ++r) {
                lookup.valueToRowIndices.put(String.valueOf(r), Collections.singletonList(r));
            }
            return;
        }
        Column targetColumn = targetProject.columnModel.getColumnByName(lookup.targetColumnName);
        if (targetColumn == null) {
            throw new LookupException("Unable to find column " + lookup.targetColumnName + " in project " + targetProjectMetadata.getName());
        }
        int count = targetProject.rows.size();
        for (int r = 0; r < count; ++r) {
            Row targetRow = targetProject.rows.get(r);
            Object value = targetRow.getCellValue(targetColumn.getCellIndex());
            if (!ExpressionUtils.isNonBlankData(value)) continue;
            String valueStr = value.toString();
            lookup.valueToRowIndices.putIfAbsent(valueStr, new ArrayList());
            lookup.valueToRowIndices.get(valueStr).add(r);
        }
    }

    public static class ProjectLookup {
        public final long targetProjectID;
        public final String targetColumnName;
        public final Map<Object, List<Integer>> valueToRowIndices = new HashMap<Object, List<Integer>>();

        ProjectLookup(long targetProjectID, String targetColumnName) {
            this.targetProjectID = targetProjectID;
            this.targetColumnName = targetColumnName;
        }

        public HasFieldsListImpl getRows(Object value) {
            Project targetProject;
            HasFieldsListImpl rows = new HasFieldsListImpl();
            if (!ExpressionUtils.isNonBlankData(value)) {
                return rows;
            }
            String valueStr = value.toString();
            if (this.valueToRowIndices.containsKey(valueStr) && (targetProject = ProjectManager.singleton.getProject(this.targetProjectID)) != null) {
                for (Integer r : this.valueToRowIndices.get(valueStr)) {
                    Row row = targetProject.rows.get(r);
                    rows.add(new WrappedRow(targetProject, r, row));
                }
                return rows;
            }
            return rows;
        }
    }
}

