/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine;

import edu.mit.simile.butterfly.ButterflyModule;
import edu.mit.simile.butterfly.MountPoint;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientSideResourceManager {
    static final Logger logger = LoggerFactory.getLogger((String)"refine_clientSideResourceManager");
    protected static final Map<String, ClientSideResourceBundle> s_bundles = new HashMap<String, ClientSideResourceBundle>();

    public static void addPaths(String bundleName, ButterflyModule module, String[] paths) {
        ClientSideResourceBundle bundle = s_bundles.get(bundleName);
        if (bundle == null) {
            bundle = new ClientSideResourceBundle();
            s_bundles.put(bundleName, bundle);
        }
        for (String path : paths) {
            String fullPath = ClientSideResourceManager.resolve(module, path);
            if (fullPath == null) {
                logger.error("Failed to add paths to unmounted module " + module.getName());
                break;
            }
            if (bundle._pathSet.contains(fullPath)) continue;
            QualifiedPath qualifiedPath = new QualifiedPath();
            qualifiedPath.module = module;
            qualifiedPath.path = path;
            qualifiedPath.fullPath = fullPath;
            bundle._pathSet.add(fullPath);
            bundle._pathList.add(qualifiedPath);
        }
    }

    public static QualifiedPath[] getPaths(String bundleName) {
        ClientSideResourceBundle bundle = s_bundles.get(bundleName);
        if (bundle == null) {
            return new QualifiedPath[0];
        }
        QualifiedPath[] paths = new QualifiedPath[bundle._pathList.size()];
        bundle._pathList.toArray(paths);
        return paths;
    }

    protected static String resolve(ButterflyModule module, String path) {
        String mountPointPath;
        MountPoint mountPoint = module.getMountPoint();
        if (mountPoint != null && (mountPointPath = mountPoint.getMountPoint()) != null) {
            StringBuffer sb = new StringBuffer();
            boolean slashed = path.startsWith("/");
            char[] mountPointChars = mountPointPath.toCharArray();
            sb.append(mountPointChars, 0, slashed ? mountPointChars.length - 1 : mountPointChars.length);
            sb.append(path);
            return sb.toString();
        }
        return null;
    }

    public static class ClientSideResourceBundle {
        protected final Set<String> _pathSet = new HashSet<String>();
        protected final List<QualifiedPath> _pathList = new ArrayList<QualifiedPath>();
    }

    public static class QualifiedPath {
        public ButterflyModule module;
        public String path;
        public String fullPath;
    }
}

