/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.DatabindContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.jsontype.impl.TypeIdResolverBase;
import com.google.refine.RefineServlet;
import java.io.IOException;

public class ClassResolver
extends TypeIdResolverBase {
    private JavaType baseType;

    public void init(JavaType baseType) {
        this.baseType = baseType;
    }

    public String idFromValue(Object value) {
        return value.getClass().getCanonicalName();
    }

    public String idFromValueAndType(Object value, Class<?> suggestedType) {
        return suggestedType.getCanonicalName();
    }

    public JavaType typeFromId(DatabindContext context, String id) throws IOException {
        try {
            return context.constructSpecializedType(this.baseType, RefineServlet.getClass(id));
        }
        catch (ClassNotFoundException e) {
            throw new IOException(e);
        }
    }

    public JsonTypeInfo.Id getMechanism() {
        return JsonTypeInfo.Id.CLASS;
    }
}

