/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.query.resultio;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Optional;
import java.util.function.Supplier;
import org.openrdf.model.ValueFactory;
import org.openrdf.query.GraphQueryResult;
import org.openrdf.query.QueryEvaluationException;
import org.openrdf.query.QueryResultHandler;
import org.openrdf.query.QueryResultHandlerException;
import org.openrdf.query.QueryResults;
import org.openrdf.query.TupleQueryResult;
import org.openrdf.query.TupleQueryResultHandler;
import org.openrdf.query.TupleQueryResultHandlerException;
import org.openrdf.query.impl.TupleQueryResultBuilder;
import org.openrdf.query.resultio.BooleanQueryResultFormat;
import org.openrdf.query.resultio.BooleanQueryResultParser;
import org.openrdf.query.resultio.BooleanQueryResultParserFactory;
import org.openrdf.query.resultio.BooleanQueryResultParserRegistry;
import org.openrdf.query.resultio.BooleanQueryResultWriter;
import org.openrdf.query.resultio.BooleanQueryResultWriterFactory;
import org.openrdf.query.resultio.BooleanQueryResultWriterRegistry;
import org.openrdf.query.resultio.QueryResultFormat;
import org.openrdf.query.resultio.QueryResultParseException;
import org.openrdf.query.resultio.QueryResultWriter;
import org.openrdf.query.resultio.TupleQueryResultFormat;
import org.openrdf.query.resultio.TupleQueryResultParser;
import org.openrdf.query.resultio.TupleQueryResultParserFactory;
import org.openrdf.query.resultio.TupleQueryResultParserRegistry;
import org.openrdf.query.resultio.TupleQueryResultWriter;
import org.openrdf.query.resultio.TupleQueryResultWriterFactory;
import org.openrdf.query.resultio.TupleQueryResultWriterRegistry;
import org.openrdf.query.resultio.UnsupportedQueryResultFormatException;
import org.openrdf.query.resultio.helpers.QueryResultCollector;
import org.openrdf.rio.RDFFormat;
import org.openrdf.rio.RDFHandler;
import org.openrdf.rio.RDFHandlerException;
import org.openrdf.rio.RDFWriter;
import org.openrdf.rio.Rio;
import org.openrdf.rio.UnsupportedRDFormatException;

public class QueryResultIO {
    public static Optional<QueryResultFormat> getParserFormatForMIMEType(String mimeType) {
        return TupleQueryResultParserRegistry.getInstance().getFileFormatForMIMEType(mimeType);
    }

    public static Optional<QueryResultFormat> getParserFormatForFileName(String fileName) {
        return TupleQueryResultParserRegistry.getInstance().getFileFormatForFileName(fileName);
    }

    public static Optional<QueryResultFormat> getWriterFormatForMIMEType(String mimeType) {
        return TupleQueryResultWriterRegistry.getInstance().getFileFormatForMIMEType(mimeType);
    }

    public static Optional<QueryResultFormat> getWriterFormatForFileName(String fileName) {
        return TupleQueryResultWriterRegistry.getInstance().getFileFormatForFileName(fileName);
    }

    public static Optional<QueryResultFormat> getBooleanParserFormatForMIMEType(String mimeType) {
        return BooleanQueryResultParserRegistry.getInstance().getFileFormatForMIMEType(mimeType);
    }

    public static Optional<QueryResultFormat> getBooleanParserFormatForFileName(String fileName) {
        return BooleanQueryResultParserRegistry.getInstance().getFileFormatForFileName(fileName);
    }

    public static Optional<QueryResultFormat> getBooleanWriterFormatForMIMEType(String mimeType) {
        return BooleanQueryResultWriterRegistry.getInstance().getFileFormatForMIMEType(mimeType);
    }

    public static Optional<QueryResultFormat> getBooleanWriterFormatForFileName(String fileName) {
        return BooleanQueryResultWriterRegistry.getInstance().getFileFormatForFileName(fileName);
    }

    public static TupleQueryResultParser createTupleParser(QueryResultFormat format) throws UnsupportedQueryResultFormatException {
        TupleQueryResultParserFactory factory = (TupleQueryResultParserFactory)TupleQueryResultParserRegistry.getInstance().get((Object)format).orElseThrow(() -> new UnsupportedQueryResultFormatException("No parser factory available for tuple query result format " + (Object)((Object)format)));
        return factory.getParser();
    }

    public static TupleQueryResultParser createTupleParser(QueryResultFormat format, ValueFactory valueFactory) throws UnsupportedQueryResultFormatException {
        TupleQueryResultParser parser = QueryResultIO.createTupleParser(format);
        parser.setValueFactory(valueFactory);
        return parser;
    }

    public static TupleQueryResultWriter createTupleWriter(QueryResultFormat format, OutputStream out) throws UnsupportedQueryResultFormatException {
        TupleQueryResultWriterFactory factory = (TupleQueryResultWriterFactory)TupleQueryResultWriterRegistry.getInstance().get((Object)format).orElseThrow(() -> new UnsupportedQueryResultFormatException("No writer factory available for tuple query result format " + (Object)((Object)format)));
        return factory.getWriter(out);
    }

    public static BooleanQueryResultParser createBooleanParser(QueryResultFormat format) throws UnsupportedQueryResultFormatException {
        BooleanQueryResultParserFactory factory = (BooleanQueryResultParserFactory)BooleanQueryResultParserRegistry.getInstance().get((Object)format).orElseThrow(() -> new UnsupportedQueryResultFormatException("No parser factory available for boolean query result format " + (Object)((Object)format)));
        return factory.getParser();
    }

    public static BooleanQueryResultWriter createBooleanWriter(QueryResultFormat format, OutputStream out) throws UnsupportedQueryResultFormatException {
        BooleanQueryResultWriterFactory factory = (BooleanQueryResultWriterFactory)BooleanQueryResultWriterRegistry.getInstance().get((Object)format).orElseThrow(() -> new UnsupportedQueryResultFormatException("No writer factory available for boolean query result format " + (Object)((Object)format)));
        return factory.getWriter(out);
    }

    public static QueryResultWriter createWriter(QueryResultFormat format, OutputStream out) throws UnsupportedQueryResultFormatException {
        Supplier<UnsupportedQueryResultFormatException> exception = () -> new UnsupportedQueryResultFormatException("No writer factory available for query result format " + (Object)((Object)format));
        if (format instanceof TupleQueryResultFormat) {
            TupleQueryResultWriterFactory factory = (TupleQueryResultWriterFactory)TupleQueryResultWriterRegistry.getInstance().get((Object)((TupleQueryResultFormat)format)).orElseThrow(exception);
            return factory.getWriter(out);
        }
        if (format instanceof BooleanQueryResultFormat) {
            BooleanQueryResultWriterFactory factory = (BooleanQueryResultWriterFactory)BooleanQueryResultWriterRegistry.getInstance().get((Object)((BooleanQueryResultFormat)format)).orElseThrow(exception);
            return factory.getWriter(out);
        }
        throw exception.get();
    }

    public static void parseTuple(InputStream in, QueryResultFormat format, TupleQueryResultHandler handler, ValueFactory valueFactory) throws IOException, QueryResultParseException, TupleQueryResultHandlerException, UnsupportedQueryResultFormatException {
        TupleQueryResultParser parser = QueryResultIO.createTupleParser(format);
        parser.setValueFactory(valueFactory);
        parser.setQueryResultHandler((QueryResultHandler)handler);
        try {
            parser.parseQueryResult(in);
        }
        catch (QueryResultHandlerException e) {
            if (e instanceof TupleQueryResultHandlerException) {
                throw (TupleQueryResultHandlerException)e;
            }
            throw new TupleQueryResultHandlerException((Throwable)e);
        }
    }

    public static TupleQueryResult parseTuple(InputStream in, QueryResultFormat format) throws IOException, QueryResultParseException, TupleQueryResultHandlerException, UnsupportedQueryResultFormatException {
        TupleQueryResultParser parser = QueryResultIO.createTupleParser(format);
        TupleQueryResultBuilder qrBuilder = new TupleQueryResultBuilder();
        parser.setQueryResultHandler((QueryResultHandler)qrBuilder);
        try {
            parser.parseQueryResult(in);
        }
        catch (QueryResultHandlerException e) {
            if (e instanceof TupleQueryResultHandlerException) {
                throw (TupleQueryResultHandlerException)e;
            }
            throw new TupleQueryResultHandlerException((Throwable)e);
        }
        return qrBuilder.getQueryResult();
    }

    public static boolean parseBoolean(InputStream in, QueryResultFormat format) throws IOException, QueryResultParseException, UnsupportedQueryResultFormatException {
        BooleanQueryResultParser parser = QueryResultIO.createBooleanParser(format);
        try {
            QueryResultCollector handler = new QueryResultCollector();
            parser.setQueryResultHandler(handler);
            parser.parseQueryResult(in);
            if (handler.getHandledBoolean()) {
                return handler.getBoolean();
            }
            throw new QueryResultParseException("Did not find a boolean result");
        }
        catch (QueryResultHandlerException e) {
            throw new QueryResultParseException(e);
        }
    }

    public static void writeTuple(TupleQueryResult tqr, QueryResultFormat format, OutputStream out) throws IOException, TupleQueryResultHandlerException, UnsupportedQueryResultFormatException, QueryEvaluationException {
        TupleQueryResultWriter writer = QueryResultIO.createTupleWriter(format, out);
        try {
            writer.startDocument();
            writer.startHeader();
            QueryResults.report((TupleQueryResult)tqr, (QueryResultHandler)writer);
        }
        catch (QueryResultHandlerException e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            if (e instanceof TupleQueryResultHandlerException) {
                throw (TupleQueryResultHandlerException)e;
            }
            throw new TupleQueryResultHandlerException((Throwable)e);
        }
    }

    public static void writeBoolean(boolean value, QueryResultFormat format, OutputStream out) throws QueryResultHandlerException, UnsupportedQueryResultFormatException {
        BooleanQueryResultWriter writer = QueryResultIO.createBooleanWriter(format, out);
        writer.startDocument();
        writer.startHeader();
        writer.handleBoolean(value);
    }

    public static void writeGraph(GraphQueryResult gqr, RDFFormat format, OutputStream out) throws IOException, RDFHandlerException, UnsupportedRDFormatException, QueryEvaluationException {
        RDFWriter writer = Rio.createWriter((RDFFormat)format, (OutputStream)out);
        try {
            QueryResults.report((GraphQueryResult)gqr, (RDFHandler)writer);
        }
        catch (RDFHandlerException e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            throw e;
        }
    }
}

