/*
 * Decompiled with CFR 0.152.
 */
package org.opencv.dnn;

import java.util.List;
import org.opencv.core.Mat;
import org.opencv.core.MatOfByte;
import org.opencv.core.MatOfFloat;
import org.opencv.core.MatOfInt;
import org.opencv.core.MatOfRect;
import org.opencv.core.MatOfRect2d;
import org.opencv.core.MatOfRotatedRect;
import org.opencv.core.Scalar;
import org.opencv.core.Size;
import org.opencv.dnn.Image2BlobParams;
import org.opencv.dnn.Net;
import org.opencv.utils.Converters;

public class Dnn {
    public static final int DNN_BACKEND_DEFAULT = 0;
    public static final int DNN_BACKEND_HALIDE = 1;
    public static final int DNN_BACKEND_INFERENCE_ENGINE = 2;
    public static final int DNN_BACKEND_OPENCV = 3;
    public static final int DNN_BACKEND_VKCOM = 4;
    public static final int DNN_BACKEND_CUDA = 5;
    public static final int DNN_BACKEND_WEBNN = 6;
    public static final int DNN_BACKEND_TIMVX = 7;
    public static final int DNN_BACKEND_CANN = 8;
    public static final int DNN_LAYOUT_UNKNOWN = 0;
    public static final int DNN_LAYOUT_ND = 1;
    public static final int DNN_LAYOUT_NCHW = 2;
    public static final int DNN_LAYOUT_NCDHW = 3;
    public static final int DNN_LAYOUT_NHWC = 4;
    public static final int DNN_LAYOUT_NDHWC = 5;
    public static final int DNN_LAYOUT_PLANAR = 6;
    public static final int DNN_PMODE_NULL = 0;
    public static final int DNN_PMODE_CROP_CENTER = 1;
    public static final int DNN_PMODE_LETTERBOX = 2;
    public static final int SoftNMSMethod_SOFTNMS_LINEAR = 1;
    public static final int SoftNMSMethod_SOFTNMS_GAUSSIAN = 2;
    public static final int DNN_TARGET_CPU = 0;
    public static final int DNN_TARGET_OPENCL = 1;
    public static final int DNN_TARGET_OPENCL_FP16 = 2;
    public static final int DNN_TARGET_MYRIAD = 3;
    public static final int DNN_TARGET_VULKAN = 4;
    public static final int DNN_TARGET_FPGA = 5;
    public static final int DNN_TARGET_CUDA = 6;
    public static final int DNN_TARGET_CUDA_FP16 = 7;
    public static final int DNN_TARGET_HDDL = 8;
    public static final int DNN_TARGET_NPU = 9;
    public static final int DNN_TARGET_CPU_FP16 = 10;

    public static List<Integer> getAvailableTargets(int be) {
        return Dnn.getAvailableTargets_0(be);
    }

    public static Net readNetFromDarknet(String cfgFile, String darknetModel) {
        return new Net(Dnn.readNetFromDarknet_0(cfgFile, darknetModel));
    }

    public static Net readNetFromDarknet(String cfgFile) {
        return new Net(Dnn.readNetFromDarknet_1(cfgFile));
    }

    public static Net readNetFromDarknet(MatOfByte bufferCfg, MatOfByte bufferModel) {
        MatOfByte bufferCfg_mat = bufferCfg;
        MatOfByte bufferModel_mat = bufferModel;
        return new Net(Dnn.readNetFromDarknet_2(bufferCfg_mat.nativeObj, bufferModel_mat.nativeObj));
    }

    public static Net readNetFromDarknet(MatOfByte bufferCfg) {
        MatOfByte bufferCfg_mat = bufferCfg;
        return new Net(Dnn.readNetFromDarknet_3(bufferCfg_mat.nativeObj));
    }

    public static Net readNetFromCaffe(String prototxt, String caffeModel) {
        return new Net(Dnn.readNetFromCaffe_0(prototxt, caffeModel));
    }

    public static Net readNetFromCaffe(String prototxt) {
        return new Net(Dnn.readNetFromCaffe_1(prototxt));
    }

    public static Net readNetFromCaffe(MatOfByte bufferProto, MatOfByte bufferModel) {
        MatOfByte bufferProto_mat = bufferProto;
        MatOfByte bufferModel_mat = bufferModel;
        return new Net(Dnn.readNetFromCaffe_2(bufferProto_mat.nativeObj, bufferModel_mat.nativeObj));
    }

    public static Net readNetFromCaffe(MatOfByte bufferProto) {
        MatOfByte bufferProto_mat = bufferProto;
        return new Net(Dnn.readNetFromCaffe_3(bufferProto_mat.nativeObj));
    }

    public static Net readNetFromTensorflow(String model, String config) {
        return new Net(Dnn.readNetFromTensorflow_0(model, config));
    }

    public static Net readNetFromTensorflow(String model) {
        return new Net(Dnn.readNetFromTensorflow_1(model));
    }

    public static Net readNetFromTensorflow(MatOfByte bufferModel, MatOfByte bufferConfig) {
        MatOfByte bufferModel_mat = bufferModel;
        MatOfByte bufferConfig_mat = bufferConfig;
        return new Net(Dnn.readNetFromTensorflow_2(bufferModel_mat.nativeObj, bufferConfig_mat.nativeObj));
    }

    public static Net readNetFromTensorflow(MatOfByte bufferModel) {
        MatOfByte bufferModel_mat = bufferModel;
        return new Net(Dnn.readNetFromTensorflow_3(bufferModel_mat.nativeObj));
    }

    public static Net readNetFromTFLite(String model) {
        return new Net(Dnn.readNetFromTFLite_0(model));
    }

    public static Net readNetFromTFLite(MatOfByte bufferModel) {
        MatOfByte bufferModel_mat = bufferModel;
        return new Net(Dnn.readNetFromTFLite_1(bufferModel_mat.nativeObj));
    }

    public static Net readNetFromTorch(String model, boolean isBinary, boolean evaluate) {
        return new Net(Dnn.readNetFromTorch_0(model, isBinary, evaluate));
    }

    public static Net readNetFromTorch(String model, boolean isBinary) {
        return new Net(Dnn.readNetFromTorch_1(model, isBinary));
    }

    public static Net readNetFromTorch(String model) {
        return new Net(Dnn.readNetFromTorch_2(model));
    }

    public static Net readNet(String model, String config, String framework) {
        return new Net(Dnn.readNet_0(model, config, framework));
    }

    public static Net readNet(String model, String config) {
        return new Net(Dnn.readNet_1(model, config));
    }

    public static Net readNet(String model) {
        return new Net(Dnn.readNet_2(model));
    }

    public static Net readNet(String framework, MatOfByte bufferModel, MatOfByte bufferConfig) {
        MatOfByte bufferModel_mat = bufferModel;
        MatOfByte bufferConfig_mat = bufferConfig;
        return new Net(Dnn.readNet_3(framework, bufferModel_mat.nativeObj, bufferConfig_mat.nativeObj));
    }

    public static Net readNet(String framework, MatOfByte bufferModel) {
        MatOfByte bufferModel_mat = bufferModel;
        return new Net(Dnn.readNet_4(framework, bufferModel_mat.nativeObj));
    }

    public static Mat readTorchBlob(String filename, boolean isBinary) {
        return new Mat(Dnn.readTorchBlob_0(filename, isBinary));
    }

    public static Mat readTorchBlob(String filename) {
        return new Mat(Dnn.readTorchBlob_1(filename));
    }

    public static Net readNetFromModelOptimizer(String xml, String bin) {
        return new Net(Dnn.readNetFromModelOptimizer_0(xml, bin));
    }

    public static Net readNetFromModelOptimizer(MatOfByte bufferModelConfig, MatOfByte bufferWeights) {
        MatOfByte bufferModelConfig_mat = bufferModelConfig;
        MatOfByte bufferWeights_mat = bufferWeights;
        return new Net(Dnn.readNetFromModelOptimizer_1(bufferModelConfig_mat.nativeObj, bufferWeights_mat.nativeObj));
    }

    public static Net readNetFromONNX(String onnxFile) {
        return new Net(Dnn.readNetFromONNX_0(onnxFile));
    }

    public static Net readNetFromONNX(MatOfByte buffer) {
        MatOfByte buffer_mat = buffer;
        return new Net(Dnn.readNetFromONNX_1(buffer_mat.nativeObj));
    }

    public static Mat readTensorFromONNX(String path) {
        return new Mat(Dnn.readTensorFromONNX_0(path));
    }

    public static Mat blobFromImage(Mat image, double scalefactor, Size size, Scalar mean, boolean swapRB, boolean crop, int ddepth) {
        return new Mat(Dnn.blobFromImage_0(image.nativeObj, scalefactor, size.width, size.height, mean.val[0], mean.val[1], mean.val[2], mean.val[3], swapRB, crop, ddepth));
    }

    public static Mat blobFromImage(Mat image, double scalefactor, Size size, Scalar mean, boolean swapRB, boolean crop) {
        return new Mat(Dnn.blobFromImage_1(image.nativeObj, scalefactor, size.width, size.height, mean.val[0], mean.val[1], mean.val[2], mean.val[3], swapRB, crop));
    }

    public static Mat blobFromImage(Mat image, double scalefactor, Size size, Scalar mean, boolean swapRB) {
        return new Mat(Dnn.blobFromImage_2(image.nativeObj, scalefactor, size.width, size.height, mean.val[0], mean.val[1], mean.val[2], mean.val[3], swapRB));
    }

    public static Mat blobFromImage(Mat image, double scalefactor, Size size, Scalar mean) {
        return new Mat(Dnn.blobFromImage_3(image.nativeObj, scalefactor, size.width, size.height, mean.val[0], mean.val[1], mean.val[2], mean.val[3]));
    }

    public static Mat blobFromImage(Mat image, double scalefactor, Size size) {
        return new Mat(Dnn.blobFromImage_4(image.nativeObj, scalefactor, size.width, size.height));
    }

    public static Mat blobFromImage(Mat image, double scalefactor) {
        return new Mat(Dnn.blobFromImage_5(image.nativeObj, scalefactor));
    }

    public static Mat blobFromImage(Mat image) {
        return new Mat(Dnn.blobFromImage_6(image.nativeObj));
    }

    public static Mat blobFromImages(List<Mat> images, double scalefactor, Size size, Scalar mean, boolean swapRB, boolean crop, int ddepth) {
        Mat images_mat = Converters.vector_Mat_to_Mat(images);
        return new Mat(Dnn.blobFromImages_0(images_mat.nativeObj, scalefactor, size.width, size.height, mean.val[0], mean.val[1], mean.val[2], mean.val[3], swapRB, crop, ddepth));
    }

    public static Mat blobFromImages(List<Mat> images, double scalefactor, Size size, Scalar mean, boolean swapRB, boolean crop) {
        Mat images_mat = Converters.vector_Mat_to_Mat(images);
        return new Mat(Dnn.blobFromImages_1(images_mat.nativeObj, scalefactor, size.width, size.height, mean.val[0], mean.val[1], mean.val[2], mean.val[3], swapRB, crop));
    }

    public static Mat blobFromImages(List<Mat> images, double scalefactor, Size size, Scalar mean, boolean swapRB) {
        Mat images_mat = Converters.vector_Mat_to_Mat(images);
        return new Mat(Dnn.blobFromImages_2(images_mat.nativeObj, scalefactor, size.width, size.height, mean.val[0], mean.val[1], mean.val[2], mean.val[3], swapRB));
    }

    public static Mat blobFromImages(List<Mat> images, double scalefactor, Size size, Scalar mean) {
        Mat images_mat = Converters.vector_Mat_to_Mat(images);
        return new Mat(Dnn.blobFromImages_3(images_mat.nativeObj, scalefactor, size.width, size.height, mean.val[0], mean.val[1], mean.val[2], mean.val[3]));
    }

    public static Mat blobFromImages(List<Mat> images, double scalefactor, Size size) {
        Mat images_mat = Converters.vector_Mat_to_Mat(images);
        return new Mat(Dnn.blobFromImages_4(images_mat.nativeObj, scalefactor, size.width, size.height));
    }

    public static Mat blobFromImages(List<Mat> images, double scalefactor) {
        Mat images_mat = Converters.vector_Mat_to_Mat(images);
        return new Mat(Dnn.blobFromImages_5(images_mat.nativeObj, scalefactor));
    }

    public static Mat blobFromImages(List<Mat> images) {
        Mat images_mat = Converters.vector_Mat_to_Mat(images);
        return new Mat(Dnn.blobFromImages_6(images_mat.nativeObj));
    }

    public static Mat blobFromImageWithParams(Mat image, Image2BlobParams param) {
        return new Mat(Dnn.blobFromImageWithParams_0(image.nativeObj, param.nativeObj));
    }

    public static Mat blobFromImageWithParams(Mat image) {
        return new Mat(Dnn.blobFromImageWithParams_1(image.nativeObj));
    }

    public static void blobFromImageWithParams(Mat image, Mat blob, Image2BlobParams param) {
        Dnn.blobFromImageWithParams_2(image.nativeObj, blob.nativeObj, param.nativeObj);
    }

    public static void blobFromImageWithParams(Mat image, Mat blob) {
        Dnn.blobFromImageWithParams_3(image.nativeObj, blob.nativeObj);
    }

    public static Mat blobFromImagesWithParams(List<Mat> images, Image2BlobParams param) {
        Mat images_mat = Converters.vector_Mat_to_Mat(images);
        return new Mat(Dnn.blobFromImagesWithParams_0(images_mat.nativeObj, param.nativeObj));
    }

    public static Mat blobFromImagesWithParams(List<Mat> images) {
        Mat images_mat = Converters.vector_Mat_to_Mat(images);
        return new Mat(Dnn.blobFromImagesWithParams_1(images_mat.nativeObj));
    }

    public static void blobFromImagesWithParams(List<Mat> images, Mat blob, Image2BlobParams param) {
        Mat images_mat = Converters.vector_Mat_to_Mat(images);
        Dnn.blobFromImagesWithParams_2(images_mat.nativeObj, blob.nativeObj, param.nativeObj);
    }

    public static void blobFromImagesWithParams(List<Mat> images, Mat blob) {
        Mat images_mat = Converters.vector_Mat_to_Mat(images);
        Dnn.blobFromImagesWithParams_3(images_mat.nativeObj, blob.nativeObj);
    }

    public static void imagesFromBlob(Mat blob_, List<Mat> images_) {
        Mat images__mat = new Mat();
        Dnn.imagesFromBlob_0(blob_.nativeObj, images__mat.nativeObj);
        Converters.Mat_to_vector_Mat(images__mat, images_);
        images__mat.release();
    }

    public static void shrinkCaffeModel(String src, String dst, List<String> layersTypes) {
        Dnn.shrinkCaffeModel_0(src, dst, layersTypes);
    }

    public static void shrinkCaffeModel(String src, String dst) {
        Dnn.shrinkCaffeModel_1(src, dst);
    }

    public static void writeTextGraph(String model, String output) {
        Dnn.writeTextGraph_0(model, output);
    }

    public static void NMSBoxes(MatOfRect2d bboxes, MatOfFloat scores, float score_threshold, float nms_threshold, MatOfInt indices, float eta, int top_k) {
        MatOfRect2d bboxes_mat = bboxes;
        MatOfFloat scores_mat = scores;
        MatOfInt indices_mat = indices;
        Dnn.NMSBoxes_0(bboxes_mat.nativeObj, scores_mat.nativeObj, score_threshold, nms_threshold, indices_mat.nativeObj, eta, top_k);
    }

    public static void NMSBoxes(MatOfRect2d bboxes, MatOfFloat scores, float score_threshold, float nms_threshold, MatOfInt indices, float eta) {
        MatOfRect2d bboxes_mat = bboxes;
        MatOfFloat scores_mat = scores;
        MatOfInt indices_mat = indices;
        Dnn.NMSBoxes_1(bboxes_mat.nativeObj, scores_mat.nativeObj, score_threshold, nms_threshold, indices_mat.nativeObj, eta);
    }

    public static void NMSBoxes(MatOfRect2d bboxes, MatOfFloat scores, float score_threshold, float nms_threshold, MatOfInt indices) {
        MatOfRect2d bboxes_mat = bboxes;
        MatOfFloat scores_mat = scores;
        MatOfInt indices_mat = indices;
        Dnn.NMSBoxes_2(bboxes_mat.nativeObj, scores_mat.nativeObj, score_threshold, nms_threshold, indices_mat.nativeObj);
    }

    public static void NMSBoxesRotated(MatOfRotatedRect bboxes, MatOfFloat scores, float score_threshold, float nms_threshold, MatOfInt indices, float eta, int top_k) {
        MatOfRotatedRect bboxes_mat = bboxes;
        MatOfFloat scores_mat = scores;
        MatOfInt indices_mat = indices;
        Dnn.NMSBoxesRotated_0(bboxes_mat.nativeObj, scores_mat.nativeObj, score_threshold, nms_threshold, indices_mat.nativeObj, eta, top_k);
    }

    public static void NMSBoxesRotated(MatOfRotatedRect bboxes, MatOfFloat scores, float score_threshold, float nms_threshold, MatOfInt indices, float eta) {
        MatOfRotatedRect bboxes_mat = bboxes;
        MatOfFloat scores_mat = scores;
        MatOfInt indices_mat = indices;
        Dnn.NMSBoxesRotated_1(bboxes_mat.nativeObj, scores_mat.nativeObj, score_threshold, nms_threshold, indices_mat.nativeObj, eta);
    }

    public static void NMSBoxesRotated(MatOfRotatedRect bboxes, MatOfFloat scores, float score_threshold, float nms_threshold, MatOfInt indices) {
        MatOfRotatedRect bboxes_mat = bboxes;
        MatOfFloat scores_mat = scores;
        MatOfInt indices_mat = indices;
        Dnn.NMSBoxesRotated_2(bboxes_mat.nativeObj, scores_mat.nativeObj, score_threshold, nms_threshold, indices_mat.nativeObj);
    }

    public static void NMSBoxesBatched(MatOfRect2d bboxes, MatOfFloat scores, MatOfInt class_ids, float score_threshold, float nms_threshold, MatOfInt indices, float eta, int top_k) {
        MatOfRect2d bboxes_mat = bboxes;
        MatOfFloat scores_mat = scores;
        MatOfInt class_ids_mat = class_ids;
        MatOfInt indices_mat = indices;
        Dnn.NMSBoxesBatched_0(bboxes_mat.nativeObj, scores_mat.nativeObj, class_ids_mat.nativeObj, score_threshold, nms_threshold, indices_mat.nativeObj, eta, top_k);
    }

    public static void NMSBoxesBatched(MatOfRect2d bboxes, MatOfFloat scores, MatOfInt class_ids, float score_threshold, float nms_threshold, MatOfInt indices, float eta) {
        MatOfRect2d bboxes_mat = bboxes;
        MatOfFloat scores_mat = scores;
        MatOfInt class_ids_mat = class_ids;
        MatOfInt indices_mat = indices;
        Dnn.NMSBoxesBatched_1(bboxes_mat.nativeObj, scores_mat.nativeObj, class_ids_mat.nativeObj, score_threshold, nms_threshold, indices_mat.nativeObj, eta);
    }

    public static void NMSBoxesBatched(MatOfRect2d bboxes, MatOfFloat scores, MatOfInt class_ids, float score_threshold, float nms_threshold, MatOfInt indices) {
        MatOfRect2d bboxes_mat = bboxes;
        MatOfFloat scores_mat = scores;
        MatOfInt class_ids_mat = class_ids;
        MatOfInt indices_mat = indices;
        Dnn.NMSBoxesBatched_2(bboxes_mat.nativeObj, scores_mat.nativeObj, class_ids_mat.nativeObj, score_threshold, nms_threshold, indices_mat.nativeObj);
    }

    public static void softNMSBoxes(MatOfRect bboxes, MatOfFloat scores, MatOfFloat updated_scores, float score_threshold, float nms_threshold, MatOfInt indices, long top_k, float sigma) {
        MatOfRect bboxes_mat = bboxes;
        MatOfFloat scores_mat = scores;
        MatOfFloat updated_scores_mat = updated_scores;
        MatOfInt indices_mat = indices;
        Dnn.softNMSBoxes_0(bboxes_mat.nativeObj, scores_mat.nativeObj, updated_scores_mat.nativeObj, score_threshold, nms_threshold, indices_mat.nativeObj, top_k, sigma);
    }

    public static void softNMSBoxes(MatOfRect bboxes, MatOfFloat scores, MatOfFloat updated_scores, float score_threshold, float nms_threshold, MatOfInt indices, long top_k) {
        MatOfRect bboxes_mat = bboxes;
        MatOfFloat scores_mat = scores;
        MatOfFloat updated_scores_mat = updated_scores;
        MatOfInt indices_mat = indices;
        Dnn.softNMSBoxes_2(bboxes_mat.nativeObj, scores_mat.nativeObj, updated_scores_mat.nativeObj, score_threshold, nms_threshold, indices_mat.nativeObj, top_k);
    }

    public static void softNMSBoxes(MatOfRect bboxes, MatOfFloat scores, MatOfFloat updated_scores, float score_threshold, float nms_threshold, MatOfInt indices) {
        MatOfRect bboxes_mat = bboxes;
        MatOfFloat scores_mat = scores;
        MatOfFloat updated_scores_mat = updated_scores;
        MatOfInt indices_mat = indices;
        Dnn.softNMSBoxes_3(bboxes_mat.nativeObj, scores_mat.nativeObj, updated_scores_mat.nativeObj, score_threshold, nms_threshold, indices_mat.nativeObj);
    }

    @Deprecated
    public static String getInferenceEngineBackendType() {
        return Dnn.getInferenceEngineBackendType_0();
    }

    @Deprecated
    public static String setInferenceEngineBackendType(String newBackendType) {
        return Dnn.setInferenceEngineBackendType_0(newBackendType);
    }

    public static void resetMyriadDevice() {
        Dnn.resetMyriadDevice_0();
    }

    public static String getInferenceEngineVPUType() {
        return Dnn.getInferenceEngineVPUType_0();
    }

    public static String getInferenceEngineCPUType() {
        return Dnn.getInferenceEngineCPUType_0();
    }

    public static void releaseHDDLPlugin() {
        Dnn.releaseHDDLPlugin_0();
    }

    private static native List<Integer> getAvailableTargets_0(int var0);

    private static native long readNetFromDarknet_0(String var0, String var1);

    private static native long readNetFromDarknet_1(String var0);

    private static native long readNetFromDarknet_2(long var0, long var2);

    private static native long readNetFromDarknet_3(long var0);

    private static native long readNetFromCaffe_0(String var0, String var1);

    private static native long readNetFromCaffe_1(String var0);

    private static native long readNetFromCaffe_2(long var0, long var2);

    private static native long readNetFromCaffe_3(long var0);

    private static native long readNetFromTensorflow_0(String var0, String var1);

    private static native long readNetFromTensorflow_1(String var0);

    private static native long readNetFromTensorflow_2(long var0, long var2);

    private static native long readNetFromTensorflow_3(long var0);

    private static native long readNetFromTFLite_0(String var0);

    private static native long readNetFromTFLite_1(long var0);

    private static native long readNetFromTorch_0(String var0, boolean var1, boolean var2);

    private static native long readNetFromTorch_1(String var0, boolean var1);

    private static native long readNetFromTorch_2(String var0);

    private static native long readNet_0(String var0, String var1, String var2);

    private static native long readNet_1(String var0, String var1);

    private static native long readNet_2(String var0);

    private static native long readNet_3(String var0, long var1, long var3);

    private static native long readNet_4(String var0, long var1);

    private static native long readTorchBlob_0(String var0, boolean var1);

    private static native long readTorchBlob_1(String var0);

    private static native long readNetFromModelOptimizer_0(String var0, String var1);

    private static native long readNetFromModelOptimizer_1(long var0, long var2);

    private static native long readNetFromONNX_0(String var0);

    private static native long readNetFromONNX_1(long var0);

    private static native long readTensorFromONNX_0(String var0);

    private static native long blobFromImage_0(long var0, double var2, double var4, double var6, double var8, double var10, double var12, double var14, boolean var16, boolean var17, int var18);

    private static native long blobFromImage_1(long var0, double var2, double var4, double var6, double var8, double var10, double var12, double var14, boolean var16, boolean var17);

    private static native long blobFromImage_2(long var0, double var2, double var4, double var6, double var8, double var10, double var12, double var14, boolean var16);

    private static native long blobFromImage_3(long var0, double var2, double var4, double var6, double var8, double var10, double var12, double var14);

    private static native long blobFromImage_4(long var0, double var2, double var4, double var6);

    private static native long blobFromImage_5(long var0, double var2);

    private static native long blobFromImage_6(long var0);

    private static native long blobFromImages_0(long var0, double var2, double var4, double var6, double var8, double var10, double var12, double var14, boolean var16, boolean var17, int var18);

    private static native long blobFromImages_1(long var0, double var2, double var4, double var6, double var8, double var10, double var12, double var14, boolean var16, boolean var17);

    private static native long blobFromImages_2(long var0, double var2, double var4, double var6, double var8, double var10, double var12, double var14, boolean var16);

    private static native long blobFromImages_3(long var0, double var2, double var4, double var6, double var8, double var10, double var12, double var14);

    private static native long blobFromImages_4(long var0, double var2, double var4, double var6);

    private static native long blobFromImages_5(long var0, double var2);

    private static native long blobFromImages_6(long var0);

    private static native long blobFromImageWithParams_0(long var0, long var2);

    private static native long blobFromImageWithParams_1(long var0);

    private static native void blobFromImageWithParams_2(long var0, long var2, long var4);

    private static native void blobFromImageWithParams_3(long var0, long var2);

    private static native long blobFromImagesWithParams_0(long var0, long var2);

    private static native long blobFromImagesWithParams_1(long var0);

    private static native void blobFromImagesWithParams_2(long var0, long var2, long var4);

    private static native void blobFromImagesWithParams_3(long var0, long var2);

    private static native void imagesFromBlob_0(long var0, long var2);

    private static native void shrinkCaffeModel_0(String var0, String var1, List<String> var2);

    private static native void shrinkCaffeModel_1(String var0, String var1);

    private static native void writeTextGraph_0(String var0, String var1);

    private static native void NMSBoxes_0(long var0, long var2, float var4, float var5, long var6, float var8, int var9);

    private static native void NMSBoxes_1(long var0, long var2, float var4, float var5, long var6, float var8);

    private static native void NMSBoxes_2(long var0, long var2, float var4, float var5, long var6);

    private static native void NMSBoxesRotated_0(long var0, long var2, float var4, float var5, long var6, float var8, int var9);

    private static native void NMSBoxesRotated_1(long var0, long var2, float var4, float var5, long var6, float var8);

    private static native void NMSBoxesRotated_2(long var0, long var2, float var4, float var5, long var6);

    private static native void NMSBoxesBatched_0(long var0, long var2, long var4, float var6, float var7, long var8, float var10, int var11);

    private static native void NMSBoxesBatched_1(long var0, long var2, long var4, float var6, float var7, long var8, float var10);

    private static native void NMSBoxesBatched_2(long var0, long var2, long var4, float var6, float var7, long var8);

    private static native void softNMSBoxes_0(long var0, long var2, long var4, float var6, float var7, long var8, long var10, float var12);

    private static native void softNMSBoxes_2(long var0, long var2, long var4, float var6, float var7, long var8, long var10);

    private static native void softNMSBoxes_3(long var0, long var2, long var4, float var6, float var7, long var8);

    private static native String getInferenceEngineBackendType_0();

    private static native String setInferenceEngineBackendType_0(String var0);

    private static native void resetMyriadDevice_0();

    private static native String getInferenceEngineVPUType_0();

    private static native String getInferenceEngineCPUType_0();

    private static native void releaseHDDLPlugin_0();
}

