/*
 * Decompiled with CFR 0.152.
 */
package org.opencv.video;

import java.util.List;
import org.opencv.core.Mat;
import org.opencv.core.MatOfByte;
import org.opencv.core.MatOfFloat;
import org.opencv.core.MatOfPoint2f;
import org.opencv.core.MatOfRect;
import org.opencv.core.Rect;
import org.opencv.core.RotatedRect;
import org.opencv.core.Size;
import org.opencv.core.TermCriteria;
import org.opencv.utils.Converters;

public class Video {
    private static final int CV_LKFLOW_INITIAL_GUESSES = 4;
    private static final int CV_LKFLOW_GET_MIN_EIGENVALS = 8;
    public static final int OPTFLOW_USE_INITIAL_FLOW = 4;
    public static final int OPTFLOW_LK_GET_MIN_EIGENVALS = 8;
    public static final int OPTFLOW_FARNEBACK_GAUSSIAN = 256;

    public static RotatedRect CamShift(Mat probImage, Rect window, TermCriteria criteria) {
        double[] window_out = new double[4];
        RotatedRect retVal = new RotatedRect(Video.CamShift_0(probImage.nativeObj, window.x, window.y, window.width, window.height, window_out, criteria.type, criteria.maxCount, criteria.epsilon));
        if (window != null) {
            window.x = (int)window_out[0];
            window.y = (int)window_out[1];
            window.width = (int)window_out[2];
            window.height = (int)window_out[3];
        }
        return retVal;
    }

    public static int buildOpticalFlowPyramid(Mat img, List<Mat> pyramid, Size winSize, int maxLevel, boolean withDerivatives, int pyrBorder, int derivBorder, boolean tryReuseInputImage) {
        Mat pyramid_mat = new Mat();
        int retVal = Video.buildOpticalFlowPyramid_0(img.nativeObj, pyramid_mat.nativeObj, winSize.width, winSize.height, maxLevel, withDerivatives, pyrBorder, derivBorder, tryReuseInputImage);
        Converters.Mat_to_vector_Mat(pyramid_mat, pyramid);
        pyramid_mat.release();
        return retVal;
    }

    public static int buildOpticalFlowPyramid(Mat img, List<Mat> pyramid, Size winSize, int maxLevel) {
        Mat pyramid_mat = new Mat();
        int retVal = Video.buildOpticalFlowPyramid_1(img.nativeObj, pyramid_mat.nativeObj, winSize.width, winSize.height, maxLevel);
        Converters.Mat_to_vector_Mat(pyramid_mat, pyramid);
        pyramid_mat.release();
        return retVal;
    }

    public static double calcGlobalOrientation(Mat orientation, Mat mask, Mat mhi, double timestamp, double duration) {
        double retVal = Video.calcGlobalOrientation_0(orientation.nativeObj, mask.nativeObj, mhi.nativeObj, timestamp, duration);
        return retVal;
    }

    public static void calcMotionGradient(Mat mhi, Mat mask, Mat orientation, double delta1, double delta2, int apertureSize) {
        Video.calcMotionGradient_0(mhi.nativeObj, mask.nativeObj, orientation.nativeObj, delta1, delta2, apertureSize);
    }

    public static void calcMotionGradient(Mat mhi, Mat mask, Mat orientation, double delta1, double delta2) {
        Video.calcMotionGradient_1(mhi.nativeObj, mask.nativeObj, orientation.nativeObj, delta1, delta2);
    }

    public static void calcOpticalFlowFarneback(Mat prev, Mat next, Mat flow, double pyr_scale, int levels, int winsize, int iterations, int poly_n, double poly_sigma, int flags) {
        Video.calcOpticalFlowFarneback_0(prev.nativeObj, next.nativeObj, flow.nativeObj, pyr_scale, levels, winsize, iterations, poly_n, poly_sigma, flags);
    }

    public static void calcOpticalFlowPyrLK(Mat prevImg, Mat nextImg, MatOfPoint2f prevPts, MatOfPoint2f nextPts, MatOfByte status, MatOfFloat err, Size winSize, int maxLevel, TermCriteria criteria, int flags, double minEigThreshold) {
        MatOfPoint2f prevPts_mat = prevPts;
        MatOfPoint2f nextPts_mat = nextPts;
        MatOfByte status_mat = status;
        MatOfFloat err_mat = err;
        Video.calcOpticalFlowPyrLK_0(prevImg.nativeObj, nextImg.nativeObj, prevPts_mat.nativeObj, nextPts_mat.nativeObj, status_mat.nativeObj, err_mat.nativeObj, winSize.width, winSize.height, maxLevel, criteria.type, criteria.maxCount, criteria.epsilon, flags, minEigThreshold);
    }

    public static void calcOpticalFlowPyrLK(Mat prevImg, Mat nextImg, MatOfPoint2f prevPts, MatOfPoint2f nextPts, MatOfByte status, MatOfFloat err, Size winSize, int maxLevel) {
        MatOfPoint2f prevPts_mat = prevPts;
        MatOfPoint2f nextPts_mat = nextPts;
        MatOfByte status_mat = status;
        MatOfFloat err_mat = err;
        Video.calcOpticalFlowPyrLK_1(prevImg.nativeObj, nextImg.nativeObj, prevPts_mat.nativeObj, nextPts_mat.nativeObj, status_mat.nativeObj, err_mat.nativeObj, winSize.width, winSize.height, maxLevel);
    }

    public static void calcOpticalFlowPyrLK(Mat prevImg, Mat nextImg, MatOfPoint2f prevPts, MatOfPoint2f nextPts, MatOfByte status, MatOfFloat err) {
        MatOfPoint2f prevPts_mat = prevPts;
        MatOfPoint2f nextPts_mat = nextPts;
        MatOfByte status_mat = status;
        MatOfFloat err_mat = err;
        Video.calcOpticalFlowPyrLK_2(prevImg.nativeObj, nextImg.nativeObj, prevPts_mat.nativeObj, nextPts_mat.nativeObj, status_mat.nativeObj, err_mat.nativeObj);
    }

    public static void calcOpticalFlowSF(Mat from, Mat to, Mat flow, int layers, int averaging_block_size, int max_flow) {
        Video.calcOpticalFlowSF_0(from.nativeObj, to.nativeObj, flow.nativeObj, layers, averaging_block_size, max_flow);
    }

    public static void calcOpticalFlowSF(Mat from, Mat to, Mat flow, int layers, int averaging_block_size, int max_flow, double sigma_dist, double sigma_color, int postprocess_window, double sigma_dist_fix, double sigma_color_fix, double occ_thr, int upscale_averaging_radius, double upscale_sigma_dist, double upscale_sigma_color, double speed_up_thr) {
        Video.calcOpticalFlowSF_1(from.nativeObj, to.nativeObj, flow.nativeObj, layers, averaging_block_size, max_flow, sigma_dist, sigma_color, postprocess_window, sigma_dist_fix, sigma_color_fix, occ_thr, upscale_averaging_radius, upscale_sigma_dist, upscale_sigma_color, speed_up_thr);
    }

    public static Mat estimateRigidTransform(Mat src, Mat dst, boolean fullAffine) {
        Mat retVal = new Mat(Video.estimateRigidTransform_0(src.nativeObj, dst.nativeObj, fullAffine));
        return retVal;
    }

    public static int meanShift(Mat probImage, Rect window, TermCriteria criteria) {
        double[] window_out = new double[4];
        int retVal = Video.meanShift_0(probImage.nativeObj, window.x, window.y, window.width, window.height, window_out, criteria.type, criteria.maxCount, criteria.epsilon);
        if (window != null) {
            window.x = (int)window_out[0];
            window.y = (int)window_out[1];
            window.width = (int)window_out[2];
            window.height = (int)window_out[3];
        }
        return retVal;
    }

    public static void segmentMotion(Mat mhi, Mat segmask, MatOfRect boundingRects, double timestamp, double segThresh) {
        MatOfRect boundingRects_mat = boundingRects;
        Video.segmentMotion_0(mhi.nativeObj, segmask.nativeObj, boundingRects_mat.nativeObj, timestamp, segThresh);
    }

    public static void updateMotionHistory(Mat silhouette, Mat mhi, double timestamp, double duration) {
        Video.updateMotionHistory_0(silhouette.nativeObj, mhi.nativeObj, timestamp, duration);
    }

    private static native double[] CamShift_0(long var0, int var2, int var3, int var4, int var5, double[] var6, int var7, int var8, double var9);

    private static native int buildOpticalFlowPyramid_0(long var0, long var2, double var4, double var6, int var8, boolean var9, int var10, int var11, boolean var12);

    private static native int buildOpticalFlowPyramid_1(long var0, long var2, double var4, double var6, int var8);

    private static native double calcGlobalOrientation_0(long var0, long var2, long var4, double var6, double var8);

    private static native void calcMotionGradient_0(long var0, long var2, long var4, double var6, double var8, int var10);

    private static native void calcMotionGradient_1(long var0, long var2, long var4, double var6, double var8);

    private static native void calcOpticalFlowFarneback_0(long var0, long var2, long var4, double var6, int var8, int var9, int var10, int var11, double var12, int var14);

    private static native void calcOpticalFlowPyrLK_0(long var0, long var2, long var4, long var6, long var8, long var10, double var12, double var14, int var16, int var17, int var18, double var19, int var21, double var22);

    private static native void calcOpticalFlowPyrLK_1(long var0, long var2, long var4, long var6, long var8, long var10, double var12, double var14, int var16);

    private static native void calcOpticalFlowPyrLK_2(long var0, long var2, long var4, long var6, long var8, long var10);

    private static native void calcOpticalFlowSF_0(long var0, long var2, long var4, int var6, int var7, int var8);

    private static native void calcOpticalFlowSF_1(long var0, long var2, long var4, int var6, int var7, int var8, double var9, double var11, int var13, double var14, double var16, double var18, int var20, double var21, double var23, double var25);

    private static native long estimateRigidTransform_0(long var0, long var2, boolean var4);

    private static native int meanShift_0(long var0, int var2, int var3, int var4, int var5, double[] var6, int var7, int var8, double var9);

    private static native void segmentMotion_0(long var0, long var2, long var4, double var6, double var8);

    private static native void updateMotionHistory_0(long var0, long var2, double var4, double var6);
}

