/*
 * Decompiled with CFR 0.152.
 */
package org.opencv.imgproc;

import java.util.ArrayList;
import java.util.List;
import org.opencv.core.Mat;
import org.opencv.core.MatOfFloat;
import org.opencv.core.MatOfInt;
import org.opencv.core.MatOfInt4;
import org.opencv.core.MatOfPoint;
import org.opencv.core.MatOfPoint2f;
import org.opencv.core.Point;
import org.opencv.core.Rect;
import org.opencv.core.RotatedRect;
import org.opencv.core.Scalar;
import org.opencv.core.Size;
import org.opencv.core.TermCriteria;
import org.opencv.imgproc.Moments;
import org.opencv.utils.Converters;

public class Imgproc {
    private static final int IPL_BORDER_CONSTANT = 0;
    private static final int IPL_BORDER_REPLICATE = 1;
    private static final int IPL_BORDER_REFLECT = 2;
    private static final int IPL_BORDER_WRAP = 3;
    private static final int IPL_BORDER_REFLECT_101 = 4;
    private static final int IPL_BORDER_TRANSPARENT = 5;
    private static final int CV_INTER_NN = 0;
    private static final int CV_INTER_LINEAR = 1;
    private static final int CV_INTER_CUBIC = 2;
    private static final int CV_INTER_AREA = 3;
    private static final int CV_INTER_LANCZOS4 = 4;
    private static final int CV_MOP_ERODE = 0;
    private static final int CV_MOP_DILATE = 1;
    private static final int CV_MOP_OPEN = 2;
    private static final int CV_MOP_CLOSE = 3;
    private static final int CV_MOP_GRADIENT = 4;
    private static final int CV_MOP_TOPHAT = 5;
    private static final int CV_MOP_BLACKHAT = 6;
    private static final int CV_RETR_EXTERNAL = 0;
    private static final int CV_RETR_LIST = 1;
    private static final int CV_RETR_CCOMP = 2;
    private static final int CV_RETR_TREE = 3;
    private static final int CV_RETR_FLOODFILL = 4;
    private static final int CV_CHAIN_APPROX_NONE = 1;
    private static final int CV_CHAIN_APPROX_SIMPLE = 2;
    private static final int CV_CHAIN_APPROX_TC89_L1 = 3;
    private static final int CV_CHAIN_APPROX_TC89_KCOS = 4;
    private static final int CV_THRESH_BINARY = 0;
    private static final int CV_THRESH_BINARY_INV = 1;
    private static final int CV_THRESH_TRUNC = 2;
    private static final int CV_THRESH_TOZERO = 3;
    private static final int CV_THRESH_TOZERO_INV = 4;
    private static final int CV_THRESH_MASK = 7;
    private static final int CV_THRESH_OTSU = 8;
    public static final int CV_BLUR_NO_SCALE = 0;
    public static final int CV_BLUR = 1;
    public static final int CV_GAUSSIAN = 2;
    public static final int CV_MEDIAN = 3;
    public static final int CV_BILATERAL = 4;
    public static final int CV_GAUSSIAN_5x5 = 7;
    public static final int CV_SCHARR = -1;
    public static final int CV_MAX_SOBEL_KSIZE = 7;
    public static final int CV_RGBA2mRGBA = 125;
    public static final int CV_mRGBA2RGBA = 126;
    public static final int CV_WARP_FILL_OUTLIERS = 8;
    public static final int CV_WARP_INVERSE_MAP = 16;
    public static final int CV_SHAPE_RECT = 0;
    public static final int CV_SHAPE_CROSS = 1;
    public static final int CV_SHAPE_ELLIPSE = 2;
    public static final int CV_SHAPE_CUSTOM = 100;
    public static final int CV_CHAIN_CODE = 0;
    public static final int CV_LINK_RUNS = 5;
    public static final int CV_POLY_APPROX_DP = 0;
    public static final int CV_CONTOURS_MATCH_I1 = 1;
    public static final int CV_CONTOURS_MATCH_I2 = 2;
    public static final int CV_CONTOURS_MATCH_I3 = 3;
    public static final int CV_CLOCKWISE = 1;
    public static final int CV_COUNTER_CLOCKWISE = 2;
    public static final int CV_COMP_CORREL = 0;
    public static final int CV_COMP_CHISQR = 1;
    public static final int CV_COMP_INTERSECT = 2;
    public static final int CV_COMP_BHATTACHARYYA = 3;
    public static final int CV_COMP_HELLINGER = 3;
    public static final int CV_DIST_MASK_3 = 3;
    public static final int CV_DIST_MASK_5 = 5;
    public static final int CV_DIST_MASK_PRECISE = 0;
    public static final int CV_DIST_LABEL_CCOMP = 0;
    public static final int CV_DIST_LABEL_PIXEL = 1;
    public static final int CV_DIST_USER = -1;
    public static final int CV_DIST_L1 = 1;
    public static final int CV_DIST_L2 = 2;
    public static final int CV_DIST_C = 3;
    public static final int CV_DIST_L12 = 4;
    public static final int CV_DIST_FAIR = 5;
    public static final int CV_DIST_WELSCH = 6;
    public static final int CV_DIST_HUBER = 7;
    public static final int CV_CANNY_L2_GRADIENT = Integer.MIN_VALUE;
    public static final int CV_HOUGH_STANDARD = 0;
    public static final int CV_HOUGH_PROBABILISTIC = 1;
    public static final int CV_HOUGH_MULTI_SCALE = 2;
    public static final int CV_HOUGH_GRADIENT = 3;
    public static final int BORDER_REPLICATE = 1;
    public static final int BORDER_CONSTANT = 0;
    public static final int BORDER_REFLECT = 2;
    public static final int BORDER_WRAP = 3;
    public static final int BORDER_REFLECT_101 = 4;
    public static final int BORDER_REFLECT101 = 4;
    public static final int BORDER_TRANSPARENT = 5;
    public static final int BORDER_DEFAULT = 4;
    public static final int BORDER_ISOLATED = 16;
    public static final int KERNEL_GENERAL = 0;
    public static final int KERNEL_SYMMETRICAL = 1;
    public static final int KERNEL_ASYMMETRICAL = 2;
    public static final int KERNEL_SMOOTH = 4;
    public static final int KERNEL_INTEGER = 8;
    public static final int MORPH_ERODE = 0;
    public static final int MORPH_DILATE = 1;
    public static final int MORPH_OPEN = 2;
    public static final int MORPH_CLOSE = 3;
    public static final int MORPH_GRADIENT = 4;
    public static final int MORPH_TOPHAT = 5;
    public static final int MORPH_BLACKHAT = 6;
    public static final int MORPH_HITMISS = 7;
    public static final int MORPH_RECT = 0;
    public static final int MORPH_CROSS = 1;
    public static final int MORPH_ELLIPSE = 2;
    public static final int GHT_POSITION = 0;
    public static final int GHT_SCALE = 1;
    public static final int GHT_ROTATION = 2;
    public static final int INTER_NEAREST = 0;
    public static final int INTER_LINEAR = 1;
    public static final int INTER_CUBIC = 2;
    public static final int INTER_AREA = 3;
    public static final int INTER_LANCZOS4 = 4;
    public static final int INTER_MAX = 7;
    public static final int WARP_INVERSE_MAP = 16;
    public static final int INTER_BITS = 5;
    public static final int INTER_BITS2 = 10;
    public static final int INTER_TAB_SIZE = 32;
    public static final int INTER_TAB_SIZE2 = 1024;
    public static final int THRESH_BINARY = 0;
    public static final int THRESH_BINARY_INV = 1;
    public static final int THRESH_TRUNC = 2;
    public static final int THRESH_TOZERO = 3;
    public static final int THRESH_TOZERO_INV = 4;
    public static final int THRESH_MASK = 7;
    public static final int THRESH_OTSU = 8;
    public static final int ADAPTIVE_THRESH_MEAN_C = 0;
    public static final int ADAPTIVE_THRESH_GAUSSIAN_C = 1;
    public static final int PROJ_SPHERICAL_ORTHO = 0;
    public static final int PROJ_SPHERICAL_EQRECT = 1;
    public static final int GC_BGD = 0;
    public static final int GC_FGD = 1;
    public static final int GC_PR_BGD = 2;
    public static final int GC_PR_FGD = 3;
    public static final int GC_INIT_WITH_RECT = 0;
    public static final int GC_INIT_WITH_MASK = 1;
    public static final int GC_EVAL = 2;
    public static final int DIST_LABEL_CCOMP = 0;
    public static final int DIST_LABEL_PIXEL = 1;
    public static final int FLOODFILL_FIXED_RANGE = 65536;
    public static final int FLOODFILL_MASK_ONLY = 131072;
    public static final int COLOR_BGR2BGRA = 0;
    public static final int COLOR_RGB2RGBA = 0;
    public static final int COLOR_BGRA2BGR = 1;
    public static final int COLOR_RGBA2RGB = 1;
    public static final int COLOR_BGR2RGBA = 2;
    public static final int COLOR_RGB2BGRA = 2;
    public static final int COLOR_RGBA2BGR = 3;
    public static final int COLOR_BGRA2RGB = 3;
    public static final int COLOR_BGR2RGB = 4;
    public static final int COLOR_RGB2BGR = 4;
    public static final int COLOR_BGRA2RGBA = 5;
    public static final int COLOR_RGBA2BGRA = 5;
    public static final int COLOR_BGR2GRAY = 6;
    public static final int COLOR_RGB2GRAY = 7;
    public static final int COLOR_GRAY2BGR = 8;
    public static final int COLOR_GRAY2RGB = 8;
    public static final int COLOR_GRAY2BGRA = 9;
    public static final int COLOR_GRAY2RGBA = 9;
    public static final int COLOR_BGRA2GRAY = 10;
    public static final int COLOR_RGBA2GRAY = 11;
    public static final int COLOR_BGR2BGR565 = 12;
    public static final int COLOR_RGB2BGR565 = 13;
    public static final int COLOR_BGR5652BGR = 14;
    public static final int COLOR_BGR5652RGB = 15;
    public static final int COLOR_BGRA2BGR565 = 16;
    public static final int COLOR_RGBA2BGR565 = 17;
    public static final int COLOR_BGR5652BGRA = 18;
    public static final int COLOR_BGR5652RGBA = 19;
    public static final int COLOR_GRAY2BGR565 = 20;
    public static final int COLOR_BGR5652GRAY = 21;
    public static final int COLOR_BGR2BGR555 = 22;
    public static final int COLOR_RGB2BGR555 = 23;
    public static final int COLOR_BGR5552BGR = 24;
    public static final int COLOR_BGR5552RGB = 25;
    public static final int COLOR_BGRA2BGR555 = 26;
    public static final int COLOR_RGBA2BGR555 = 27;
    public static final int COLOR_BGR5552BGRA = 28;
    public static final int COLOR_BGR5552RGBA = 29;
    public static final int COLOR_GRAY2BGR555 = 30;
    public static final int COLOR_BGR5552GRAY = 31;
    public static final int COLOR_BGR2XYZ = 32;
    public static final int COLOR_RGB2XYZ = 33;
    public static final int COLOR_XYZ2BGR = 34;
    public static final int COLOR_XYZ2RGB = 35;
    public static final int COLOR_BGR2YCrCb = 36;
    public static final int COLOR_RGB2YCrCb = 37;
    public static final int COLOR_YCrCb2BGR = 38;
    public static final int COLOR_YCrCb2RGB = 39;
    public static final int COLOR_BGR2HSV = 40;
    public static final int COLOR_RGB2HSV = 41;
    public static final int COLOR_BGR2Lab = 44;
    public static final int COLOR_RGB2Lab = 45;
    public static final int COLOR_BayerBG2BGR = 46;
    public static final int COLOR_BayerGB2BGR = 47;
    public static final int COLOR_BayerRG2BGR = 48;
    public static final int COLOR_BayerGR2BGR = 49;
    public static final int COLOR_BayerBG2RGB = 48;
    public static final int COLOR_BayerGB2RGB = 49;
    public static final int COLOR_BayerRG2RGB = 46;
    public static final int COLOR_BayerGR2RGB = 47;
    public static final int COLOR_BGR2Luv = 50;
    public static final int COLOR_RGB2Luv = 51;
    public static final int COLOR_BGR2HLS = 52;
    public static final int COLOR_RGB2HLS = 53;
    public static final int COLOR_HSV2BGR = 54;
    public static final int COLOR_HSV2RGB = 55;
    public static final int COLOR_Lab2BGR = 56;
    public static final int COLOR_Lab2RGB = 57;
    public static final int COLOR_Luv2BGR = 58;
    public static final int COLOR_Luv2RGB = 59;
    public static final int COLOR_HLS2BGR = 60;
    public static final int COLOR_HLS2RGB = 61;
    public static final int COLOR_BayerBG2BGR_VNG = 62;
    public static final int COLOR_BayerGB2BGR_VNG = 63;
    public static final int COLOR_BayerRG2BGR_VNG = 64;
    public static final int COLOR_BayerGR2BGR_VNG = 65;
    public static final int COLOR_BayerBG2RGB_VNG = 64;
    public static final int COLOR_BayerGB2RGB_VNG = 65;
    public static final int COLOR_BayerRG2RGB_VNG = 62;
    public static final int COLOR_BayerGR2RGB_VNG = 63;
    public static final int COLOR_BGR2HSV_FULL = 66;
    public static final int COLOR_RGB2HSV_FULL = 67;
    public static final int COLOR_BGR2HLS_FULL = 68;
    public static final int COLOR_RGB2HLS_FULL = 69;
    public static final int COLOR_HSV2BGR_FULL = 70;
    public static final int COLOR_HSV2RGB_FULL = 71;
    public static final int COLOR_HLS2BGR_FULL = 72;
    public static final int COLOR_HLS2RGB_FULL = 73;
    public static final int COLOR_LBGR2Lab = 74;
    public static final int COLOR_LRGB2Lab = 75;
    public static final int COLOR_LBGR2Luv = 76;
    public static final int COLOR_LRGB2Luv = 77;
    public static final int COLOR_Lab2LBGR = 78;
    public static final int COLOR_Lab2LRGB = 79;
    public static final int COLOR_Luv2LBGR = 80;
    public static final int COLOR_Luv2LRGB = 81;
    public static final int COLOR_BGR2YUV = 82;
    public static final int COLOR_RGB2YUV = 83;
    public static final int COLOR_YUV2BGR = 84;
    public static final int COLOR_YUV2RGB = 85;
    public static final int COLOR_BayerBG2GRAY = 86;
    public static final int COLOR_BayerGB2GRAY = 87;
    public static final int COLOR_BayerRG2GRAY = 88;
    public static final int COLOR_BayerGR2GRAY = 89;
    public static final int COLOR_YUV2RGB_NV12 = 90;
    public static final int COLOR_YUV2BGR_NV12 = 91;
    public static final int COLOR_YUV2RGB_NV21 = 92;
    public static final int COLOR_YUV2BGR_NV21 = 93;
    public static final int COLOR_YUV420sp2RGB = 92;
    public static final int COLOR_YUV420sp2BGR = 93;
    public static final int COLOR_YUV2RGBA_NV12 = 94;
    public static final int COLOR_YUV2BGRA_NV12 = 95;
    public static final int COLOR_YUV2RGBA_NV21 = 96;
    public static final int COLOR_YUV2BGRA_NV21 = 97;
    public static final int COLOR_YUV420sp2RGBA = 96;
    public static final int COLOR_YUV420sp2BGRA = 97;
    public static final int COLOR_YUV2RGB_YV12 = 98;
    public static final int COLOR_YUV2BGR_YV12 = 99;
    public static final int COLOR_YUV2RGB_IYUV = 100;
    public static final int COLOR_YUV2BGR_IYUV = 101;
    public static final int COLOR_YUV2RGB_I420 = 100;
    public static final int COLOR_YUV2BGR_I420 = 101;
    public static final int COLOR_YUV420p2RGB = 98;
    public static final int COLOR_YUV420p2BGR = 99;
    public static final int COLOR_YUV2RGBA_YV12 = 102;
    public static final int COLOR_YUV2BGRA_YV12 = 103;
    public static final int COLOR_YUV2RGBA_IYUV = 104;
    public static final int COLOR_YUV2BGRA_IYUV = 105;
    public static final int COLOR_YUV2RGBA_I420 = 104;
    public static final int COLOR_YUV2BGRA_I420 = 105;
    public static final int COLOR_YUV420p2RGBA = 102;
    public static final int COLOR_YUV420p2BGRA = 103;
    public static final int COLOR_YUV2GRAY_420 = 106;
    public static final int COLOR_YUV2GRAY_NV21 = 106;
    public static final int COLOR_YUV2GRAY_NV12 = 106;
    public static final int COLOR_YUV2GRAY_YV12 = 106;
    public static final int COLOR_YUV2GRAY_IYUV = 106;
    public static final int COLOR_YUV2GRAY_I420 = 106;
    public static final int COLOR_YUV420sp2GRAY = 106;
    public static final int COLOR_YUV420p2GRAY = 106;
    public static final int COLOR_YUV2RGB_UYVY = 107;
    public static final int COLOR_YUV2BGR_UYVY = 108;
    public static final int COLOR_YUV2RGB_Y422 = 107;
    public static final int COLOR_YUV2BGR_Y422 = 108;
    public static final int COLOR_YUV2RGB_UYNV = 107;
    public static final int COLOR_YUV2BGR_UYNV = 108;
    public static final int COLOR_YUV2RGBA_UYVY = 111;
    public static final int COLOR_YUV2BGRA_UYVY = 112;
    public static final int COLOR_YUV2RGBA_Y422 = 111;
    public static final int COLOR_YUV2BGRA_Y422 = 112;
    public static final int COLOR_YUV2RGBA_UYNV = 111;
    public static final int COLOR_YUV2BGRA_UYNV = 112;
    public static final int COLOR_YUV2RGB_YUY2 = 115;
    public static final int COLOR_YUV2BGR_YUY2 = 116;
    public static final int COLOR_YUV2RGB_YVYU = 117;
    public static final int COLOR_YUV2BGR_YVYU = 118;
    public static final int COLOR_YUV2RGB_YUYV = 115;
    public static final int COLOR_YUV2BGR_YUYV = 116;
    public static final int COLOR_YUV2RGB_YUNV = 115;
    public static final int COLOR_YUV2BGR_YUNV = 116;
    public static final int COLOR_YUV2RGBA_YUY2 = 119;
    public static final int COLOR_YUV2BGRA_YUY2 = 120;
    public static final int COLOR_YUV2RGBA_YVYU = 121;
    public static final int COLOR_YUV2BGRA_YVYU = 122;
    public static final int COLOR_YUV2RGBA_YUYV = 119;
    public static final int COLOR_YUV2BGRA_YUYV = 120;
    public static final int COLOR_YUV2RGBA_YUNV = 119;
    public static final int COLOR_YUV2BGRA_YUNV = 120;
    public static final int COLOR_YUV2GRAY_UYVY = 123;
    public static final int COLOR_YUV2GRAY_YUY2 = 124;
    public static final int COLOR_YUV2GRAY_Y422 = 123;
    public static final int COLOR_YUV2GRAY_UYNV = 123;
    public static final int COLOR_YUV2GRAY_YVYU = 124;
    public static final int COLOR_YUV2GRAY_YUYV = 124;
    public static final int COLOR_YUV2GRAY_YUNV = 124;
    public static final int COLOR_RGBA2mRGBA = 125;
    public static final int COLOR_mRGBA2RGBA = 126;
    public static final int COLOR_RGB2YUV_I420 = 127;
    public static final int COLOR_BGR2YUV_I420 = 128;
    public static final int COLOR_RGB2YUV_IYUV = 127;
    public static final int COLOR_BGR2YUV_IYUV = 128;
    public static final int COLOR_RGBA2YUV_I420 = 129;
    public static final int COLOR_BGRA2YUV_I420 = 130;
    public static final int COLOR_RGBA2YUV_IYUV = 129;
    public static final int COLOR_BGRA2YUV_IYUV = 130;
    public static final int COLOR_RGB2YUV_YV12 = 131;
    public static final int COLOR_BGR2YUV_YV12 = 132;
    public static final int COLOR_RGBA2YUV_YV12 = 133;
    public static final int COLOR_BGRA2YUV_YV12 = 134;
    public static final int COLOR_COLORCVT_MAX = 135;
    public static final int TM_SQDIFF = 0;
    public static final int TM_SQDIFF_NORMED = 1;
    public static final int TM_CCORR = 2;
    public static final int TM_CCORR_NORMED = 3;
    public static final int TM_CCOEFF = 4;
    public static final int TM_CCOEFF_NORMED = 5;
    public static final int RETR_EXTERNAL = 0;
    public static final int RETR_LIST = 1;
    public static final int RETR_CCOMP = 2;
    public static final int RETR_TREE = 3;
    public static final int RETR_FLOODFILL = 4;
    public static final int CHAIN_APPROX_NONE = 1;
    public static final int CHAIN_APPROX_SIMPLE = 2;
    public static final int CHAIN_APPROX_TC89_L1 = 3;
    public static final int CHAIN_APPROX_TC89_KCOS = 4;

    public static void Canny(Mat image, Mat edges, double threshold1, double threshold2, int apertureSize, boolean L2gradient) {
        Imgproc.Canny_0(image.nativeObj, edges.nativeObj, threshold1, threshold2, apertureSize, L2gradient);
    }

    public static void Canny(Mat image, Mat edges, double threshold1, double threshold2) {
        Imgproc.Canny_1(image.nativeObj, edges.nativeObj, threshold1, threshold2);
    }

    public static void GaussianBlur(Mat src, Mat dst, Size ksize, double sigmaX, double sigmaY, int borderType) {
        Imgproc.GaussianBlur_0(src.nativeObj, dst.nativeObj, ksize.width, ksize.height, sigmaX, sigmaY, borderType);
    }

    public static void GaussianBlur(Mat src, Mat dst, Size ksize, double sigmaX, double sigmaY) {
        Imgproc.GaussianBlur_1(src.nativeObj, dst.nativeObj, ksize.width, ksize.height, sigmaX, sigmaY);
    }

    public static void GaussianBlur(Mat src, Mat dst, Size ksize, double sigmaX) {
        Imgproc.GaussianBlur_2(src.nativeObj, dst.nativeObj, ksize.width, ksize.height, sigmaX);
    }

    public static void HoughCircles(Mat image, Mat circles, int method, double dp, double minDist, double param1, double param2, int minRadius, int maxRadius) {
        Imgproc.HoughCircles_0(image.nativeObj, circles.nativeObj, method, dp, minDist, param1, param2, minRadius, maxRadius);
    }

    public static void HoughCircles(Mat image, Mat circles, int method, double dp, double minDist) {
        Imgproc.HoughCircles_1(image.nativeObj, circles.nativeObj, method, dp, minDist);
    }

    public static void HoughLines(Mat image, Mat lines, double rho, double theta, int threshold, double srn, double stn) {
        Imgproc.HoughLines_0(image.nativeObj, lines.nativeObj, rho, theta, threshold, srn, stn);
    }

    public static void HoughLines(Mat image, Mat lines, double rho, double theta, int threshold) {
        Imgproc.HoughLines_1(image.nativeObj, lines.nativeObj, rho, theta, threshold);
    }

    public static void HoughLinesP(Mat image, Mat lines, double rho, double theta, int threshold, double minLineLength, double maxLineGap) {
        Imgproc.HoughLinesP_0(image.nativeObj, lines.nativeObj, rho, theta, threshold, minLineLength, maxLineGap);
    }

    public static void HoughLinesP(Mat image, Mat lines, double rho, double theta, int threshold) {
        Imgproc.HoughLinesP_1(image.nativeObj, lines.nativeObj, rho, theta, threshold);
    }

    public static void HuMoments(Moments m, Mat hu) {
        Imgproc.HuMoments_0(m.nativeObj, hu.nativeObj);
    }

    public static void Laplacian(Mat src, Mat dst, int ddepth, int ksize, double scale, double delta, int borderType) {
        Imgproc.Laplacian_0(src.nativeObj, dst.nativeObj, ddepth, ksize, scale, delta, borderType);
    }

    public static void Laplacian(Mat src, Mat dst, int ddepth, int ksize, double scale, double delta) {
        Imgproc.Laplacian_1(src.nativeObj, dst.nativeObj, ddepth, ksize, scale, delta);
    }

    public static void Laplacian(Mat src, Mat dst, int ddepth) {
        Imgproc.Laplacian_2(src.nativeObj, dst.nativeObj, ddepth);
    }

    public static double PSNR(Mat src1, Mat src2) {
        double retVal = Imgproc.PSNR_0(src1.nativeObj, src2.nativeObj);
        return retVal;
    }

    public static void Scharr(Mat src, Mat dst, int ddepth, int dx, int dy, double scale, double delta, int borderType) {
        Imgproc.Scharr_0(src.nativeObj, dst.nativeObj, ddepth, dx, dy, scale, delta, borderType);
    }

    public static void Scharr(Mat src, Mat dst, int ddepth, int dx, int dy, double scale, double delta) {
        Imgproc.Scharr_1(src.nativeObj, dst.nativeObj, ddepth, dx, dy, scale, delta);
    }

    public static void Scharr(Mat src, Mat dst, int ddepth, int dx, int dy) {
        Imgproc.Scharr_2(src.nativeObj, dst.nativeObj, ddepth, dx, dy);
    }

    public static void Sobel(Mat src, Mat dst, int ddepth, int dx, int dy, int ksize, double scale, double delta, int borderType) {
        Imgproc.Sobel_0(src.nativeObj, dst.nativeObj, ddepth, dx, dy, ksize, scale, delta, borderType);
    }

    public static void Sobel(Mat src, Mat dst, int ddepth, int dx, int dy, int ksize, double scale, double delta) {
        Imgproc.Sobel_1(src.nativeObj, dst.nativeObj, ddepth, dx, dy, ksize, scale, delta);
    }

    public static void Sobel(Mat src, Mat dst, int ddepth, int dx, int dy) {
        Imgproc.Sobel_2(src.nativeObj, dst.nativeObj, ddepth, dx, dy);
    }

    public static void accumulate(Mat src, Mat dst, Mat mask) {
        Imgproc.accumulate_0(src.nativeObj, dst.nativeObj, mask.nativeObj);
    }

    public static void accumulate(Mat src, Mat dst) {
        Imgproc.accumulate_1(src.nativeObj, dst.nativeObj);
    }

    public static void accumulateProduct(Mat src1, Mat src2, Mat dst, Mat mask) {
        Imgproc.accumulateProduct_0(src1.nativeObj, src2.nativeObj, dst.nativeObj, mask.nativeObj);
    }

    public static void accumulateProduct(Mat src1, Mat src2, Mat dst) {
        Imgproc.accumulateProduct_1(src1.nativeObj, src2.nativeObj, dst.nativeObj);
    }

    public static void accumulateSquare(Mat src, Mat dst, Mat mask) {
        Imgproc.accumulateSquare_0(src.nativeObj, dst.nativeObj, mask.nativeObj);
    }

    public static void accumulateSquare(Mat src, Mat dst) {
        Imgproc.accumulateSquare_1(src.nativeObj, dst.nativeObj);
    }

    public static void accumulateWeighted(Mat src, Mat dst, double alpha, Mat mask) {
        Imgproc.accumulateWeighted_0(src.nativeObj, dst.nativeObj, alpha, mask.nativeObj);
    }

    public static void accumulateWeighted(Mat src, Mat dst, double alpha) {
        Imgproc.accumulateWeighted_1(src.nativeObj, dst.nativeObj, alpha);
    }

    public static void adaptiveBilateralFilter(Mat src, Mat dst, Size ksize, double sigmaSpace, double maxSigmaColor, Point anchor, int borderType) {
        Imgproc.adaptiveBilateralFilter_0(src.nativeObj, dst.nativeObj, ksize.width, ksize.height, sigmaSpace, maxSigmaColor, anchor.x, anchor.y, borderType);
    }

    public static void adaptiveBilateralFilter(Mat src, Mat dst, Size ksize, double sigmaSpace, double maxSigmaColor, Point anchor) {
        Imgproc.adaptiveBilateralFilter_1(src.nativeObj, dst.nativeObj, ksize.width, ksize.height, sigmaSpace, maxSigmaColor, anchor.x, anchor.y);
    }

    public static void adaptiveBilateralFilter(Mat src, Mat dst, Size ksize, double sigmaSpace) {
        Imgproc.adaptiveBilateralFilter_2(src.nativeObj, dst.nativeObj, ksize.width, ksize.height, sigmaSpace);
    }

    public static void adaptiveThreshold(Mat src, Mat dst, double maxValue, int adaptiveMethod, int thresholdType, int blockSize, double C) {
        Imgproc.adaptiveThreshold_0(src.nativeObj, dst.nativeObj, maxValue, adaptiveMethod, thresholdType, blockSize, C);
    }

    public static void approxPolyDP(MatOfPoint2f curve, MatOfPoint2f approxCurve, double epsilon, boolean closed) {
        MatOfPoint2f curve_mat = curve;
        MatOfPoint2f approxCurve_mat = approxCurve;
        Imgproc.approxPolyDP_0(curve_mat.nativeObj, approxCurve_mat.nativeObj, epsilon, closed);
    }

    public static double arcLength(MatOfPoint2f curve, boolean closed) {
        MatOfPoint2f curve_mat = curve;
        double retVal = Imgproc.arcLength_0(curve_mat.nativeObj, closed);
        return retVal;
    }

    public static void bilateralFilter(Mat src, Mat dst, int d, double sigmaColor, double sigmaSpace, int borderType) {
        Imgproc.bilateralFilter_0(src.nativeObj, dst.nativeObj, d, sigmaColor, sigmaSpace, borderType);
    }

    public static void bilateralFilter(Mat src, Mat dst, int d, double sigmaColor, double sigmaSpace) {
        Imgproc.bilateralFilter_1(src.nativeObj, dst.nativeObj, d, sigmaColor, sigmaSpace);
    }

    public static void blur(Mat src, Mat dst, Size ksize, Point anchor, int borderType) {
        Imgproc.blur_0(src.nativeObj, dst.nativeObj, ksize.width, ksize.height, anchor.x, anchor.y, borderType);
    }

    public static void blur(Mat src, Mat dst, Size ksize, Point anchor) {
        Imgproc.blur_1(src.nativeObj, dst.nativeObj, ksize.width, ksize.height, anchor.x, anchor.y);
    }

    public static void blur(Mat src, Mat dst, Size ksize) {
        Imgproc.blur_2(src.nativeObj, dst.nativeObj, ksize.width, ksize.height);
    }

    public static int borderInterpolate(int p, int len, int borderType) {
        int retVal = Imgproc.borderInterpolate_0(p, len, borderType);
        return retVal;
    }

    public static Rect boundingRect(MatOfPoint points) {
        MatOfPoint points_mat = points;
        Rect retVal = new Rect(Imgproc.boundingRect_0(points_mat.nativeObj));
        return retVal;
    }

    public static void boxFilter(Mat src, Mat dst, int ddepth, Size ksize, Point anchor, boolean normalize, int borderType) {
        Imgproc.boxFilter_0(src.nativeObj, dst.nativeObj, ddepth, ksize.width, ksize.height, anchor.x, anchor.y, normalize, borderType);
    }

    public static void boxFilter(Mat src, Mat dst, int ddepth, Size ksize, Point anchor, boolean normalize) {
        Imgproc.boxFilter_1(src.nativeObj, dst.nativeObj, ddepth, ksize.width, ksize.height, anchor.x, anchor.y, normalize);
    }

    public static void boxFilter(Mat src, Mat dst, int ddepth, Size ksize) {
        Imgproc.boxFilter_2(src.nativeObj, dst.nativeObj, ddepth, ksize.width, ksize.height);
    }

    public static void calcBackProject(List<Mat> images, MatOfInt channels, Mat hist, Mat dst, MatOfFloat ranges, double scale) {
        Mat images_mat = Converters.vector_Mat_to_Mat(images);
        MatOfInt channels_mat = channels;
        MatOfFloat ranges_mat = ranges;
        Imgproc.calcBackProject_0(images_mat.nativeObj, channels_mat.nativeObj, hist.nativeObj, dst.nativeObj, ranges_mat.nativeObj, scale);
    }

    public static void calcHist(List<Mat> images, MatOfInt channels, Mat mask, Mat hist, MatOfInt histSize, MatOfFloat ranges, boolean accumulate) {
        Mat images_mat = Converters.vector_Mat_to_Mat(images);
        MatOfInt channels_mat = channels;
        MatOfInt histSize_mat = histSize;
        MatOfFloat ranges_mat = ranges;
        Imgproc.calcHist_0(images_mat.nativeObj, channels_mat.nativeObj, mask.nativeObj, hist.nativeObj, histSize_mat.nativeObj, ranges_mat.nativeObj, accumulate);
    }

    public static void calcHist(List<Mat> images, MatOfInt channels, Mat mask, Mat hist, MatOfInt histSize, MatOfFloat ranges) {
        Mat images_mat = Converters.vector_Mat_to_Mat(images);
        MatOfInt channels_mat = channels;
        MatOfInt histSize_mat = histSize;
        MatOfFloat ranges_mat = ranges;
        Imgproc.calcHist_1(images_mat.nativeObj, channels_mat.nativeObj, mask.nativeObj, hist.nativeObj, histSize_mat.nativeObj, ranges_mat.nativeObj);
    }

    public static double compareHist(Mat H1, Mat H2, int method) {
        double retVal = Imgproc.compareHist_0(H1.nativeObj, H2.nativeObj, method);
        return retVal;
    }

    public static double contourArea(Mat contour, boolean oriented) {
        double retVal = Imgproc.contourArea_0(contour.nativeObj, oriented);
        return retVal;
    }

    public static double contourArea(Mat contour) {
        double retVal = Imgproc.contourArea_1(contour.nativeObj);
        return retVal;
    }

    public static void convertMaps(Mat map1, Mat map2, Mat dstmap1, Mat dstmap2, int dstmap1type, boolean nninterpolation) {
        Imgproc.convertMaps_0(map1.nativeObj, map2.nativeObj, dstmap1.nativeObj, dstmap2.nativeObj, dstmap1type, nninterpolation);
    }

    public static void convertMaps(Mat map1, Mat map2, Mat dstmap1, Mat dstmap2, int dstmap1type) {
        Imgproc.convertMaps_1(map1.nativeObj, map2.nativeObj, dstmap1.nativeObj, dstmap2.nativeObj, dstmap1type);
    }

    public static void convexHull(MatOfPoint points, MatOfInt hull, boolean clockwise) {
        MatOfPoint points_mat = points;
        MatOfInt hull_mat = hull;
        Imgproc.convexHull_0(points_mat.nativeObj, hull_mat.nativeObj, clockwise);
    }

    public static void convexHull(MatOfPoint points, MatOfInt hull) {
        MatOfPoint points_mat = points;
        MatOfInt hull_mat = hull;
        Imgproc.convexHull_1(points_mat.nativeObj, hull_mat.nativeObj);
    }

    public static void convexityDefects(MatOfPoint contour, MatOfInt convexhull, MatOfInt4 convexityDefects) {
        MatOfPoint contour_mat = contour;
        MatOfInt convexhull_mat = convexhull;
        MatOfInt4 convexityDefects_mat = convexityDefects;
        Imgproc.convexityDefects_0(contour_mat.nativeObj, convexhull_mat.nativeObj, convexityDefects_mat.nativeObj);
    }

    public static void copyMakeBorder(Mat src, Mat dst, int top, int bottom, int left, int right, int borderType, Scalar value) {
        Imgproc.copyMakeBorder_0(src.nativeObj, dst.nativeObj, top, bottom, left, right, borderType, value.val[0], value.val[1], value.val[2], value.val[3]);
    }

    public static void copyMakeBorder(Mat src, Mat dst, int top, int bottom, int left, int right, int borderType) {
        Imgproc.copyMakeBorder_1(src.nativeObj, dst.nativeObj, top, bottom, left, right, borderType);
    }

    public static void cornerEigenValsAndVecs(Mat src, Mat dst, int blockSize, int ksize, int borderType) {
        Imgproc.cornerEigenValsAndVecs_0(src.nativeObj, dst.nativeObj, blockSize, ksize, borderType);
    }

    public static void cornerEigenValsAndVecs(Mat src, Mat dst, int blockSize, int ksize) {
        Imgproc.cornerEigenValsAndVecs_1(src.nativeObj, dst.nativeObj, blockSize, ksize);
    }

    public static void cornerHarris(Mat src, Mat dst, int blockSize, int ksize, double k, int borderType) {
        Imgproc.cornerHarris_0(src.nativeObj, dst.nativeObj, blockSize, ksize, k, borderType);
    }

    public static void cornerHarris(Mat src, Mat dst, int blockSize, int ksize, double k) {
        Imgproc.cornerHarris_1(src.nativeObj, dst.nativeObj, blockSize, ksize, k);
    }

    public static void cornerMinEigenVal(Mat src, Mat dst, int blockSize, int ksize, int borderType) {
        Imgproc.cornerMinEigenVal_0(src.nativeObj, dst.nativeObj, blockSize, ksize, borderType);
    }

    public static void cornerMinEigenVal(Mat src, Mat dst, int blockSize, int ksize) {
        Imgproc.cornerMinEigenVal_1(src.nativeObj, dst.nativeObj, blockSize, ksize);
    }

    public static void cornerMinEigenVal(Mat src, Mat dst, int blockSize) {
        Imgproc.cornerMinEigenVal_2(src.nativeObj, dst.nativeObj, blockSize);
    }

    public static void cornerSubPix(Mat image, MatOfPoint2f corners, Size winSize, Size zeroZone, TermCriteria criteria) {
        MatOfPoint2f corners_mat = corners;
        Imgproc.cornerSubPix_0(image.nativeObj, corners_mat.nativeObj, winSize.width, winSize.height, zeroZone.width, zeroZone.height, criteria.type, criteria.maxCount, criteria.epsilon);
    }

    public static void createHanningWindow(Mat dst, Size winSize, int type) {
        Imgproc.createHanningWindow_0(dst.nativeObj, winSize.width, winSize.height, type);
    }

    public static void cvtColor(Mat src, Mat dst, int code, int dstCn) {
        Imgproc.cvtColor_0(src.nativeObj, dst.nativeObj, code, dstCn);
    }

    public static void cvtColor(Mat src, Mat dst, int code) {
        Imgproc.cvtColor_1(src.nativeObj, dst.nativeObj, code);
    }

    public static void dilate(Mat src, Mat dst, Mat kernel, Point anchor, int iterations, int borderType, Scalar borderValue) {
        Imgproc.dilate_0(src.nativeObj, dst.nativeObj, kernel.nativeObj, anchor.x, anchor.y, iterations, borderType, borderValue.val[0], borderValue.val[1], borderValue.val[2], borderValue.val[3]);
    }

    public static void dilate(Mat src, Mat dst, Mat kernel, Point anchor, int iterations) {
        Imgproc.dilate_1(src.nativeObj, dst.nativeObj, kernel.nativeObj, anchor.x, anchor.y, iterations);
    }

    public static void dilate(Mat src, Mat dst, Mat kernel) {
        Imgproc.dilate_2(src.nativeObj, dst.nativeObj, kernel.nativeObj);
    }

    public static void distanceTransform(Mat src, Mat dst, int distanceType, int maskSize) {
        Imgproc.distanceTransform_0(src.nativeObj, dst.nativeObj, distanceType, maskSize);
    }

    public static void distanceTransformWithLabels(Mat src, Mat dst, Mat labels, int distanceType, int maskSize, int labelType) {
        Imgproc.distanceTransformWithLabels_0(src.nativeObj, dst.nativeObj, labels.nativeObj, distanceType, maskSize, labelType);
    }

    public static void distanceTransformWithLabels(Mat src, Mat dst, Mat labels, int distanceType, int maskSize) {
        Imgproc.distanceTransformWithLabels_1(src.nativeObj, dst.nativeObj, labels.nativeObj, distanceType, maskSize);
    }

    public static void drawContours(Mat image, List<MatOfPoint> contours, int contourIdx, Scalar color, int thickness, int lineType, Mat hierarchy, int maxLevel, Point offset) {
        ArrayList<Mat> contours_tmplm = new ArrayList<Mat>(contours != null ? contours.size() : 0);
        Mat contours_mat = Converters.vector_vector_Point_to_Mat(contours, contours_tmplm);
        Imgproc.drawContours_0(image.nativeObj, contours_mat.nativeObj, contourIdx, color.val[0], color.val[1], color.val[2], color.val[3], thickness, lineType, hierarchy.nativeObj, maxLevel, offset.x, offset.y);
    }

    public static void drawContours(Mat image, List<MatOfPoint> contours, int contourIdx, Scalar color, int thickness) {
        ArrayList<Mat> contours_tmplm = new ArrayList<Mat>(contours != null ? contours.size() : 0);
        Mat contours_mat = Converters.vector_vector_Point_to_Mat(contours, contours_tmplm);
        Imgproc.drawContours_1(image.nativeObj, contours_mat.nativeObj, contourIdx, color.val[0], color.val[1], color.val[2], color.val[3], thickness);
    }

    public static void drawContours(Mat image, List<MatOfPoint> contours, int contourIdx, Scalar color) {
        ArrayList<Mat> contours_tmplm = new ArrayList<Mat>(contours != null ? contours.size() : 0);
        Mat contours_mat = Converters.vector_vector_Point_to_Mat(contours, contours_tmplm);
        Imgproc.drawContours_2(image.nativeObj, contours_mat.nativeObj, contourIdx, color.val[0], color.val[1], color.val[2], color.val[3]);
    }

    public static void equalizeHist(Mat src, Mat dst) {
        Imgproc.equalizeHist_0(src.nativeObj, dst.nativeObj);
    }

    public static void erode(Mat src, Mat dst, Mat kernel, Point anchor, int iterations, int borderType, Scalar borderValue) {
        Imgproc.erode_0(src.nativeObj, dst.nativeObj, kernel.nativeObj, anchor.x, anchor.y, iterations, borderType, borderValue.val[0], borderValue.val[1], borderValue.val[2], borderValue.val[3]);
    }

    public static void erode(Mat src, Mat dst, Mat kernel, Point anchor, int iterations) {
        Imgproc.erode_1(src.nativeObj, dst.nativeObj, kernel.nativeObj, anchor.x, anchor.y, iterations);
    }

    public static void erode(Mat src, Mat dst, Mat kernel) {
        Imgproc.erode_2(src.nativeObj, dst.nativeObj, kernel.nativeObj);
    }

    public static void filter2D(Mat src, Mat dst, int ddepth, Mat kernel, Point anchor, double delta, int borderType) {
        Imgproc.filter2D_0(src.nativeObj, dst.nativeObj, ddepth, kernel.nativeObj, anchor.x, anchor.y, delta, borderType);
    }

    public static void filter2D(Mat src, Mat dst, int ddepth, Mat kernel, Point anchor, double delta) {
        Imgproc.filter2D_1(src.nativeObj, dst.nativeObj, ddepth, kernel.nativeObj, anchor.x, anchor.y, delta);
    }

    public static void filter2D(Mat src, Mat dst, int ddepth, Mat kernel) {
        Imgproc.filter2D_2(src.nativeObj, dst.nativeObj, ddepth, kernel.nativeObj);
    }

    public static void findContours(Mat image, List<MatOfPoint> contours, Mat hierarchy, int mode, int method, Point offset) {
        Mat contours_mat = new Mat();
        Imgproc.findContours_0(image.nativeObj, contours_mat.nativeObj, hierarchy.nativeObj, mode, method, offset.x, offset.y);
        Converters.Mat_to_vector_vector_Point(contours_mat, contours);
        contours_mat.release();
    }

    public static void findContours(Mat image, List<MatOfPoint> contours, Mat hierarchy, int mode, int method) {
        Mat contours_mat = new Mat();
        Imgproc.findContours_1(image.nativeObj, contours_mat.nativeObj, hierarchy.nativeObj, mode, method);
        Converters.Mat_to_vector_vector_Point(contours_mat, contours);
        contours_mat.release();
    }

    public static RotatedRect fitEllipse(MatOfPoint2f points) {
        MatOfPoint2f points_mat = points;
        RotatedRect retVal = new RotatedRect(Imgproc.fitEllipse_0(points_mat.nativeObj));
        return retVal;
    }

    public static void fitLine(Mat points, Mat line, int distType, double param, double reps, double aeps) {
        Imgproc.fitLine_0(points.nativeObj, line.nativeObj, distType, param, reps, aeps);
    }

    public static int floodFill(Mat image, Mat mask, Point seedPoint, Scalar newVal, Rect rect, Scalar loDiff, Scalar upDiff, int flags) {
        double[] rect_out = new double[4];
        int retVal = Imgproc.floodFill_0(image.nativeObj, mask.nativeObj, seedPoint.x, seedPoint.y, newVal.val[0], newVal.val[1], newVal.val[2], newVal.val[3], rect_out, loDiff.val[0], loDiff.val[1], loDiff.val[2], loDiff.val[3], upDiff.val[0], upDiff.val[1], upDiff.val[2], upDiff.val[3], flags);
        if (rect != null) {
            rect.x = (int)rect_out[0];
            rect.y = (int)rect_out[1];
            rect.width = (int)rect_out[2];
            rect.height = (int)rect_out[3];
        }
        return retVal;
    }

    public static int floodFill(Mat image, Mat mask, Point seedPoint, Scalar newVal) {
        int retVal = Imgproc.floodFill_1(image.nativeObj, mask.nativeObj, seedPoint.x, seedPoint.y, newVal.val[0], newVal.val[1], newVal.val[2], newVal.val[3]);
        return retVal;
    }

    public static Mat getAffineTransform(MatOfPoint2f src, MatOfPoint2f dst) {
        MatOfPoint2f src_mat = src;
        MatOfPoint2f dst_mat = dst;
        Mat retVal = new Mat(Imgproc.getAffineTransform_0(src_mat.nativeObj, dst_mat.nativeObj));
        return retVal;
    }

    public static Mat getDefaultNewCameraMatrix(Mat cameraMatrix, Size imgsize, boolean centerPrincipalPoint) {
        Mat retVal = new Mat(Imgproc.getDefaultNewCameraMatrix_0(cameraMatrix.nativeObj, imgsize.width, imgsize.height, centerPrincipalPoint));
        return retVal;
    }

    public static Mat getDefaultNewCameraMatrix(Mat cameraMatrix) {
        Mat retVal = new Mat(Imgproc.getDefaultNewCameraMatrix_1(cameraMatrix.nativeObj));
        return retVal;
    }

    public static void getDerivKernels(Mat kx, Mat ky, int dx, int dy, int ksize, boolean normalize, int ktype) {
        Imgproc.getDerivKernels_0(kx.nativeObj, ky.nativeObj, dx, dy, ksize, normalize, ktype);
    }

    public static void getDerivKernels(Mat kx, Mat ky, int dx, int dy, int ksize) {
        Imgproc.getDerivKernels_1(kx.nativeObj, ky.nativeObj, dx, dy, ksize);
    }

    public static Mat getGaborKernel(Size ksize, double sigma, double theta, double lambd, double gamma, double psi, int ktype) {
        Mat retVal = new Mat(Imgproc.getGaborKernel_0(ksize.width, ksize.height, sigma, theta, lambd, gamma, psi, ktype));
        return retVal;
    }

    public static Mat getGaborKernel(Size ksize, double sigma, double theta, double lambd, double gamma) {
        Mat retVal = new Mat(Imgproc.getGaborKernel_1(ksize.width, ksize.height, sigma, theta, lambd, gamma));
        return retVal;
    }

    public static Mat getGaussianKernel(int ksize, double sigma, int ktype) {
        Mat retVal = new Mat(Imgproc.getGaussianKernel_0(ksize, sigma, ktype));
        return retVal;
    }

    public static Mat getGaussianKernel(int ksize, double sigma) {
        Mat retVal = new Mat(Imgproc.getGaussianKernel_1(ksize, sigma));
        return retVal;
    }

    public static Mat getPerspectiveTransform(Mat src, Mat dst) {
        Mat retVal = new Mat(Imgproc.getPerspectiveTransform_0(src.nativeObj, dst.nativeObj));
        return retVal;
    }

    public static void getRectSubPix(Mat image, Size patchSize, Point center, Mat patch, int patchType) {
        Imgproc.getRectSubPix_0(image.nativeObj, patchSize.width, patchSize.height, center.x, center.y, patch.nativeObj, patchType);
    }

    public static void getRectSubPix(Mat image, Size patchSize, Point center, Mat patch) {
        Imgproc.getRectSubPix_1(image.nativeObj, patchSize.width, patchSize.height, center.x, center.y, patch.nativeObj);
    }

    public static Mat getRotationMatrix2D(Point center, double angle, double scale) {
        Mat retVal = new Mat(Imgproc.getRotationMatrix2D_0(center.x, center.y, angle, scale));
        return retVal;
    }

    public static Mat getStructuringElement(int shape, Size ksize, Point anchor) {
        Mat retVal = new Mat(Imgproc.getStructuringElement_0(shape, ksize.width, ksize.height, anchor.x, anchor.y));
        return retVal;
    }

    public static Mat getStructuringElement(int shape, Size ksize) {
        Mat retVal = new Mat(Imgproc.getStructuringElement_1(shape, ksize.width, ksize.height));
        return retVal;
    }

    public static void goodFeaturesToTrack(Mat image, MatOfPoint corners, int maxCorners, double qualityLevel, double minDistance, Mat mask, int blockSize, boolean useHarrisDetector, double k) {
        MatOfPoint corners_mat = corners;
        Imgproc.goodFeaturesToTrack_0(image.nativeObj, corners_mat.nativeObj, maxCorners, qualityLevel, minDistance, mask.nativeObj, blockSize, useHarrisDetector, k);
    }

    public static void goodFeaturesToTrack(Mat image, MatOfPoint corners, int maxCorners, double qualityLevel, double minDistance) {
        MatOfPoint corners_mat = corners;
        Imgproc.goodFeaturesToTrack_1(image.nativeObj, corners_mat.nativeObj, maxCorners, qualityLevel, minDistance);
    }

    public static void grabCut(Mat img, Mat mask, Rect rect, Mat bgdModel, Mat fgdModel, int iterCount, int mode) {
        Imgproc.grabCut_0(img.nativeObj, mask.nativeObj, rect.x, rect.y, rect.width, rect.height, bgdModel.nativeObj, fgdModel.nativeObj, iterCount, mode);
    }

    public static void grabCut(Mat img, Mat mask, Rect rect, Mat bgdModel, Mat fgdModel, int iterCount) {
        Imgproc.grabCut_1(img.nativeObj, mask.nativeObj, rect.x, rect.y, rect.width, rect.height, bgdModel.nativeObj, fgdModel.nativeObj, iterCount);
    }

    public static void initUndistortRectifyMap(Mat cameraMatrix, Mat distCoeffs, Mat R, Mat newCameraMatrix, Size size, int m1type, Mat map1, Mat map2) {
        Imgproc.initUndistortRectifyMap_0(cameraMatrix.nativeObj, distCoeffs.nativeObj, R.nativeObj, newCameraMatrix.nativeObj, size.width, size.height, m1type, map1.nativeObj, map2.nativeObj);
    }

    public static float initWideAngleProjMap(Mat cameraMatrix, Mat distCoeffs, Size imageSize, int destImageWidth, int m1type, Mat map1, Mat map2, int projType, double alpha) {
        float retVal = Imgproc.initWideAngleProjMap_0(cameraMatrix.nativeObj, distCoeffs.nativeObj, imageSize.width, imageSize.height, destImageWidth, m1type, map1.nativeObj, map2.nativeObj, projType, alpha);
        return retVal;
    }

    public static float initWideAngleProjMap(Mat cameraMatrix, Mat distCoeffs, Size imageSize, int destImageWidth, int m1type, Mat map1, Mat map2) {
        float retVal = Imgproc.initWideAngleProjMap_1(cameraMatrix.nativeObj, distCoeffs.nativeObj, imageSize.width, imageSize.height, destImageWidth, m1type, map1.nativeObj, map2.nativeObj);
        return retVal;
    }

    public static void integral(Mat src, Mat sum, int sdepth) {
        Imgproc.integral_0(src.nativeObj, sum.nativeObj, sdepth);
    }

    public static void integral(Mat src, Mat sum) {
        Imgproc.integral_1(src.nativeObj, sum.nativeObj);
    }

    public static void integral2(Mat src, Mat sum, Mat sqsum, int sdepth) {
        Imgproc.integral2_0(src.nativeObj, sum.nativeObj, sqsum.nativeObj, sdepth);
    }

    public static void integral2(Mat src, Mat sum, Mat sqsum) {
        Imgproc.integral2_1(src.nativeObj, sum.nativeObj, sqsum.nativeObj);
    }

    public static void integral3(Mat src, Mat sum, Mat sqsum, Mat tilted, int sdepth) {
        Imgproc.integral3_0(src.nativeObj, sum.nativeObj, sqsum.nativeObj, tilted.nativeObj, sdepth);
    }

    public static void integral3(Mat src, Mat sum, Mat sqsum, Mat tilted) {
        Imgproc.integral3_1(src.nativeObj, sum.nativeObj, sqsum.nativeObj, tilted.nativeObj);
    }

    public static float intersectConvexConvex(Mat _p1, Mat _p2, Mat _p12, boolean handleNested) {
        float retVal = Imgproc.intersectConvexConvex_0(_p1.nativeObj, _p2.nativeObj, _p12.nativeObj, handleNested);
        return retVal;
    }

    public static float intersectConvexConvex(Mat _p1, Mat _p2, Mat _p12) {
        float retVal = Imgproc.intersectConvexConvex_1(_p1.nativeObj, _p2.nativeObj, _p12.nativeObj);
        return retVal;
    }

    public static void invertAffineTransform(Mat M, Mat iM) {
        Imgproc.invertAffineTransform_0(M.nativeObj, iM.nativeObj);
    }

    public static boolean isContourConvex(MatOfPoint contour) {
        MatOfPoint contour_mat = contour;
        boolean retVal = Imgproc.isContourConvex_0(contour_mat.nativeObj);
        return retVal;
    }

    public static double matchShapes(Mat contour1, Mat contour2, int method, double parameter) {
        double retVal = Imgproc.matchShapes_0(contour1.nativeObj, contour2.nativeObj, method, parameter);
        return retVal;
    }

    public static void matchTemplate(Mat image, Mat templ, Mat result, int method) {
        Imgproc.matchTemplate_0(image.nativeObj, templ.nativeObj, result.nativeObj, method);
    }

    public static void medianBlur(Mat src, Mat dst, int ksize) {
        Imgproc.medianBlur_0(src.nativeObj, dst.nativeObj, ksize);
    }

    public static RotatedRect minAreaRect(MatOfPoint2f points) {
        MatOfPoint2f points_mat = points;
        RotatedRect retVal = new RotatedRect(Imgproc.minAreaRect_0(points_mat.nativeObj));
        return retVal;
    }

    public static void minEnclosingCircle(MatOfPoint2f points, Point center, float[] radius) {
        MatOfPoint2f points_mat = points;
        double[] center_out = new double[2];
        double[] radius_out = new double[1];
        Imgproc.minEnclosingCircle_0(points_mat.nativeObj, center_out, radius_out);
        if (center != null) {
            center.x = center_out[0];
            center.y = center_out[1];
        }
        if (radius != null) {
            radius[0] = (float)radius_out[0];
        }
    }

    public static Moments moments(Mat array, boolean binaryImage) {
        Moments retVal = new Moments(Imgproc.moments_0(array.nativeObj, binaryImage));
        return retVal;
    }

    public static Moments moments(Mat array) {
        Moments retVal = new Moments(Imgproc.moments_1(array.nativeObj));
        return retVal;
    }

    public static void morphologyEx(Mat src, Mat dst, int op, Mat kernel, Point anchor, int iterations, int borderType, Scalar borderValue) {
        Imgproc.morphologyEx_0(src.nativeObj, dst.nativeObj, op, kernel.nativeObj, anchor.x, anchor.y, iterations, borderType, borderValue.val[0], borderValue.val[1], borderValue.val[2], borderValue.val[3]);
    }

    public static void morphologyEx(Mat src, Mat dst, int op, Mat kernel, Point anchor, int iterations) {
        Imgproc.morphologyEx_1(src.nativeObj, dst.nativeObj, op, kernel.nativeObj, anchor.x, anchor.y, iterations);
    }

    public static void morphologyEx(Mat src, Mat dst, int op, Mat kernel) {
        Imgproc.morphologyEx_2(src.nativeObj, dst.nativeObj, op, kernel.nativeObj);
    }

    public static Point phaseCorrelate(Mat src1, Mat src2, Mat window) {
        Point retVal = new Point(Imgproc.phaseCorrelate_0(src1.nativeObj, src2.nativeObj, window.nativeObj));
        return retVal;
    }

    public static Point phaseCorrelate(Mat src1, Mat src2) {
        Point retVal = new Point(Imgproc.phaseCorrelate_1(src1.nativeObj, src2.nativeObj));
        return retVal;
    }

    public static Point phaseCorrelateRes(Mat src1, Mat src2, Mat window, double[] response) {
        double[] response_out = new double[1];
        Point retVal = new Point(Imgproc.phaseCorrelateRes_0(src1.nativeObj, src2.nativeObj, window.nativeObj, response_out));
        if (response != null) {
            response[0] = response_out[0];
        }
        return retVal;
    }

    public static Point phaseCorrelateRes(Mat src1, Mat src2, Mat window) {
        Point retVal = new Point(Imgproc.phaseCorrelateRes_1(src1.nativeObj, src2.nativeObj, window.nativeObj));
        return retVal;
    }

    public static double pointPolygonTest(MatOfPoint2f contour, Point pt, boolean measureDist) {
        MatOfPoint2f contour_mat = contour;
        double retVal = Imgproc.pointPolygonTest_0(contour_mat.nativeObj, pt.x, pt.y, measureDist);
        return retVal;
    }

    public static void preCornerDetect(Mat src, Mat dst, int ksize, int borderType) {
        Imgproc.preCornerDetect_0(src.nativeObj, dst.nativeObj, ksize, borderType);
    }

    public static void preCornerDetect(Mat src, Mat dst, int ksize) {
        Imgproc.preCornerDetect_1(src.nativeObj, dst.nativeObj, ksize);
    }

    public static void pyrDown(Mat src, Mat dst, Size dstsize, int borderType) {
        Imgproc.pyrDown_0(src.nativeObj, dst.nativeObj, dstsize.width, dstsize.height, borderType);
    }

    public static void pyrDown(Mat src, Mat dst, Size dstsize) {
        Imgproc.pyrDown_1(src.nativeObj, dst.nativeObj, dstsize.width, dstsize.height);
    }

    public static void pyrDown(Mat src, Mat dst) {
        Imgproc.pyrDown_2(src.nativeObj, dst.nativeObj);
    }

    public static void pyrMeanShiftFiltering(Mat src, Mat dst, double sp, double sr, int maxLevel, TermCriteria termcrit) {
        Imgproc.pyrMeanShiftFiltering_0(src.nativeObj, dst.nativeObj, sp, sr, maxLevel, termcrit.type, termcrit.maxCount, termcrit.epsilon);
    }

    public static void pyrMeanShiftFiltering(Mat src, Mat dst, double sp, double sr) {
        Imgproc.pyrMeanShiftFiltering_1(src.nativeObj, dst.nativeObj, sp, sr);
    }

    public static void pyrUp(Mat src, Mat dst, Size dstsize, int borderType) {
        Imgproc.pyrUp_0(src.nativeObj, dst.nativeObj, dstsize.width, dstsize.height, borderType);
    }

    public static void pyrUp(Mat src, Mat dst, Size dstsize) {
        Imgproc.pyrUp_1(src.nativeObj, dst.nativeObj, dstsize.width, dstsize.height);
    }

    public static void pyrUp(Mat src, Mat dst) {
        Imgproc.pyrUp_2(src.nativeObj, dst.nativeObj);
    }

    public static void remap(Mat src, Mat dst, Mat map1, Mat map2, int interpolation, int borderMode, Scalar borderValue) {
        Imgproc.remap_0(src.nativeObj, dst.nativeObj, map1.nativeObj, map2.nativeObj, interpolation, borderMode, borderValue.val[0], borderValue.val[1], borderValue.val[2], borderValue.val[3]);
    }

    public static void remap(Mat src, Mat dst, Mat map1, Mat map2, int interpolation) {
        Imgproc.remap_1(src.nativeObj, dst.nativeObj, map1.nativeObj, map2.nativeObj, interpolation);
    }

    public static void resize(Mat src, Mat dst, Size dsize, double fx, double fy, int interpolation) {
        Imgproc.resize_0(src.nativeObj, dst.nativeObj, dsize.width, dsize.height, fx, fy, interpolation);
    }

    public static void resize(Mat src, Mat dst, Size dsize) {
        Imgproc.resize_1(src.nativeObj, dst.nativeObj, dsize.width, dsize.height);
    }

    public static void sepFilter2D(Mat src, Mat dst, int ddepth, Mat kernelX, Mat kernelY, Point anchor, double delta, int borderType) {
        Imgproc.sepFilter2D_0(src.nativeObj, dst.nativeObj, ddepth, kernelX.nativeObj, kernelY.nativeObj, anchor.x, anchor.y, delta, borderType);
    }

    public static void sepFilter2D(Mat src, Mat dst, int ddepth, Mat kernelX, Mat kernelY, Point anchor, double delta) {
        Imgproc.sepFilter2D_1(src.nativeObj, dst.nativeObj, ddepth, kernelX.nativeObj, kernelY.nativeObj, anchor.x, anchor.y, delta);
    }

    public static void sepFilter2D(Mat src, Mat dst, int ddepth, Mat kernelX, Mat kernelY) {
        Imgproc.sepFilter2D_2(src.nativeObj, dst.nativeObj, ddepth, kernelX.nativeObj, kernelY.nativeObj);
    }

    public static double threshold(Mat src, Mat dst, double thresh, double maxval, int type) {
        double retVal = Imgproc.threshold_0(src.nativeObj, dst.nativeObj, thresh, maxval, type);
        return retVal;
    }

    public static void undistort(Mat src, Mat dst, Mat cameraMatrix, Mat distCoeffs, Mat newCameraMatrix) {
        Imgproc.undistort_0(src.nativeObj, dst.nativeObj, cameraMatrix.nativeObj, distCoeffs.nativeObj, newCameraMatrix.nativeObj);
    }

    public static void undistort(Mat src, Mat dst, Mat cameraMatrix, Mat distCoeffs) {
        Imgproc.undistort_1(src.nativeObj, dst.nativeObj, cameraMatrix.nativeObj, distCoeffs.nativeObj);
    }

    public static void undistortPoints(MatOfPoint2f src, MatOfPoint2f dst, Mat cameraMatrix, Mat distCoeffs, Mat R, Mat P) {
        MatOfPoint2f src_mat = src;
        MatOfPoint2f dst_mat = dst;
        Imgproc.undistortPoints_0(src_mat.nativeObj, dst_mat.nativeObj, cameraMatrix.nativeObj, distCoeffs.nativeObj, R.nativeObj, P.nativeObj);
    }

    public static void undistortPoints(MatOfPoint2f src, MatOfPoint2f dst, Mat cameraMatrix, Mat distCoeffs) {
        MatOfPoint2f src_mat = src;
        MatOfPoint2f dst_mat = dst;
        Imgproc.undistortPoints_1(src_mat.nativeObj, dst_mat.nativeObj, cameraMatrix.nativeObj, distCoeffs.nativeObj);
    }

    public static void warpAffine(Mat src, Mat dst, Mat M, Size dsize, int flags, int borderMode, Scalar borderValue) {
        Imgproc.warpAffine_0(src.nativeObj, dst.nativeObj, M.nativeObj, dsize.width, dsize.height, flags, borderMode, borderValue.val[0], borderValue.val[1], borderValue.val[2], borderValue.val[3]);
    }

    public static void warpAffine(Mat src, Mat dst, Mat M, Size dsize, int flags) {
        Imgproc.warpAffine_1(src.nativeObj, dst.nativeObj, M.nativeObj, dsize.width, dsize.height, flags);
    }

    public static void warpAffine(Mat src, Mat dst, Mat M, Size dsize) {
        Imgproc.warpAffine_2(src.nativeObj, dst.nativeObj, M.nativeObj, dsize.width, dsize.height);
    }

    public static void warpPerspective(Mat src, Mat dst, Mat M, Size dsize, int flags, int borderMode, Scalar borderValue) {
        Imgproc.warpPerspective_0(src.nativeObj, dst.nativeObj, M.nativeObj, dsize.width, dsize.height, flags, borderMode, borderValue.val[0], borderValue.val[1], borderValue.val[2], borderValue.val[3]);
    }

    public static void warpPerspective(Mat src, Mat dst, Mat M, Size dsize, int flags) {
        Imgproc.warpPerspective_1(src.nativeObj, dst.nativeObj, M.nativeObj, dsize.width, dsize.height, flags);
    }

    public static void warpPerspective(Mat src, Mat dst, Mat M, Size dsize) {
        Imgproc.warpPerspective_2(src.nativeObj, dst.nativeObj, M.nativeObj, dsize.width, dsize.height);
    }

    public static void watershed(Mat image, Mat markers) {
        Imgproc.watershed_0(image.nativeObj, markers.nativeObj);
    }

    private static native void Canny_0(long var0, long var2, double var4, double var6, int var8, boolean var9);

    private static native void Canny_1(long var0, long var2, double var4, double var6);

    private static native void GaussianBlur_0(long var0, long var2, double var4, double var6, double var8, double var10, int var12);

    private static native void GaussianBlur_1(long var0, long var2, double var4, double var6, double var8, double var10);

    private static native void GaussianBlur_2(long var0, long var2, double var4, double var6, double var8);

    private static native void HoughCircles_0(long var0, long var2, int var4, double var5, double var7, double var9, double var11, int var13, int var14);

    private static native void HoughCircles_1(long var0, long var2, int var4, double var5, double var7);

    private static native void HoughLines_0(long var0, long var2, double var4, double var6, int var8, double var9, double var11);

    private static native void HoughLines_1(long var0, long var2, double var4, double var6, int var8);

    private static native void HoughLinesP_0(long var0, long var2, double var4, double var6, int var8, double var9, double var11);

    private static native void HoughLinesP_1(long var0, long var2, double var4, double var6, int var8);

    private static native void HuMoments_0(long var0, long var2);

    private static native void Laplacian_0(long var0, long var2, int var4, int var5, double var6, double var8, int var10);

    private static native void Laplacian_1(long var0, long var2, int var4, int var5, double var6, double var8);

    private static native void Laplacian_2(long var0, long var2, int var4);

    private static native double PSNR_0(long var0, long var2);

    private static native void Scharr_0(long var0, long var2, int var4, int var5, int var6, double var7, double var9, int var11);

    private static native void Scharr_1(long var0, long var2, int var4, int var5, int var6, double var7, double var9);

    private static native void Scharr_2(long var0, long var2, int var4, int var5, int var6);

    private static native void Sobel_0(long var0, long var2, int var4, int var5, int var6, int var7, double var8, double var10, int var12);

    private static native void Sobel_1(long var0, long var2, int var4, int var5, int var6, int var7, double var8, double var10);

    private static native void Sobel_2(long var0, long var2, int var4, int var5, int var6);

    private static native void accumulate_0(long var0, long var2, long var4);

    private static native void accumulate_1(long var0, long var2);

    private static native void accumulateProduct_0(long var0, long var2, long var4, long var6);

    private static native void accumulateProduct_1(long var0, long var2, long var4);

    private static native void accumulateSquare_0(long var0, long var2, long var4);

    private static native void accumulateSquare_1(long var0, long var2);

    private static native void accumulateWeighted_0(long var0, long var2, double var4, long var6);

    private static native void accumulateWeighted_1(long var0, long var2, double var4);

    private static native void adaptiveBilateralFilter_0(long var0, long var2, double var4, double var6, double var8, double var10, double var12, double var14, int var16);

    private static native void adaptiveBilateralFilter_1(long var0, long var2, double var4, double var6, double var8, double var10, double var12, double var14);

    private static native void adaptiveBilateralFilter_2(long var0, long var2, double var4, double var6, double var8);

    private static native void adaptiveThreshold_0(long var0, long var2, double var4, int var6, int var7, int var8, double var9);

    private static native void approxPolyDP_0(long var0, long var2, double var4, boolean var6);

    private static native double arcLength_0(long var0, boolean var2);

    private static native void bilateralFilter_0(long var0, long var2, int var4, double var5, double var7, int var9);

    private static native void bilateralFilter_1(long var0, long var2, int var4, double var5, double var7);

    private static native void blur_0(long var0, long var2, double var4, double var6, double var8, double var10, int var12);

    private static native void blur_1(long var0, long var2, double var4, double var6, double var8, double var10);

    private static native void blur_2(long var0, long var2, double var4, double var6);

    private static native int borderInterpolate_0(int var0, int var1, int var2);

    private static native double[] boundingRect_0(long var0);

    private static native void boxFilter_0(long var0, long var2, int var4, double var5, double var7, double var9, double var11, boolean var13, int var14);

    private static native void boxFilter_1(long var0, long var2, int var4, double var5, double var7, double var9, double var11, boolean var13);

    private static native void boxFilter_2(long var0, long var2, int var4, double var5, double var7);

    private static native void calcBackProject_0(long var0, long var2, long var4, long var6, long var8, double var10);

    private static native void calcHist_0(long var0, long var2, long var4, long var6, long var8, long var10, boolean var12);

    private static native void calcHist_1(long var0, long var2, long var4, long var6, long var8, long var10);

    private static native double compareHist_0(long var0, long var2, int var4);

    private static native double contourArea_0(long var0, boolean var2);

    private static native double contourArea_1(long var0);

    private static native void convertMaps_0(long var0, long var2, long var4, long var6, int var8, boolean var9);

    private static native void convertMaps_1(long var0, long var2, long var4, long var6, int var8);

    private static native void convexHull_0(long var0, long var2, boolean var4);

    private static native void convexHull_1(long var0, long var2);

    private static native void convexityDefects_0(long var0, long var2, long var4);

    private static native void copyMakeBorder_0(long var0, long var2, int var4, int var5, int var6, int var7, int var8, double var9, double var11, double var13, double var15);

    private static native void copyMakeBorder_1(long var0, long var2, int var4, int var5, int var6, int var7, int var8);

    private static native void cornerEigenValsAndVecs_0(long var0, long var2, int var4, int var5, int var6);

    private static native void cornerEigenValsAndVecs_1(long var0, long var2, int var4, int var5);

    private static native void cornerHarris_0(long var0, long var2, int var4, int var5, double var6, int var8);

    private static native void cornerHarris_1(long var0, long var2, int var4, int var5, double var6);

    private static native void cornerMinEigenVal_0(long var0, long var2, int var4, int var5, int var6);

    private static native void cornerMinEigenVal_1(long var0, long var2, int var4, int var5);

    private static native void cornerMinEigenVal_2(long var0, long var2, int var4);

    private static native void cornerSubPix_0(long var0, long var2, double var4, double var6, double var8, double var10, int var12, int var13, double var14);

    private static native void createHanningWindow_0(long var0, double var2, double var4, int var6);

    private static native void cvtColor_0(long var0, long var2, int var4, int var5);

    private static native void cvtColor_1(long var0, long var2, int var4);

    private static native void dilate_0(long var0, long var2, long var4, double var6, double var8, int var10, int var11, double var12, double var14, double var16, double var18);

    private static native void dilate_1(long var0, long var2, long var4, double var6, double var8, int var10);

    private static native void dilate_2(long var0, long var2, long var4);

    private static native void distanceTransform_0(long var0, long var2, int var4, int var5);

    private static native void distanceTransformWithLabels_0(long var0, long var2, long var4, int var6, int var7, int var8);

    private static native void distanceTransformWithLabels_1(long var0, long var2, long var4, int var6, int var7);

    private static native void drawContours_0(long var0, long var2, int var4, double var5, double var7, double var9, double var11, int var13, int var14, long var15, int var17, double var18, double var20);

    private static native void drawContours_1(long var0, long var2, int var4, double var5, double var7, double var9, double var11, int var13);

    private static native void drawContours_2(long var0, long var2, int var4, double var5, double var7, double var9, double var11);

    private static native void equalizeHist_0(long var0, long var2);

    private static native void erode_0(long var0, long var2, long var4, double var6, double var8, int var10, int var11, double var12, double var14, double var16, double var18);

    private static native void erode_1(long var0, long var2, long var4, double var6, double var8, int var10);

    private static native void erode_2(long var0, long var2, long var4);

    private static native void filter2D_0(long var0, long var2, int var4, long var5, double var7, double var9, double var11, int var13);

    private static native void filter2D_1(long var0, long var2, int var4, long var5, double var7, double var9, double var11);

    private static native void filter2D_2(long var0, long var2, int var4, long var5);

    private static native void findContours_0(long var0, long var2, long var4, int var6, int var7, double var8, double var10);

    private static native void findContours_1(long var0, long var2, long var4, int var6, int var7);

    private static native double[] fitEllipse_0(long var0);

    private static native void fitLine_0(long var0, long var2, int var4, double var5, double var7, double var9);

    private static native int floodFill_0(long var0, long var2, double var4, double var6, double var8, double var10, double var12, double var14, double[] var16, double var17, double var19, double var21, double var23, double var25, double var27, double var29, double var31, int var33);

    private static native int floodFill_1(long var0, long var2, double var4, double var6, double var8, double var10, double var12, double var14);

    private static native long getAffineTransform_0(long var0, long var2);

    private static native long getDefaultNewCameraMatrix_0(long var0, double var2, double var4, boolean var6);

    private static native long getDefaultNewCameraMatrix_1(long var0);

    private static native void getDerivKernels_0(long var0, long var2, int var4, int var5, int var6, boolean var7, int var8);

    private static native void getDerivKernels_1(long var0, long var2, int var4, int var5, int var6);

    private static native long getGaborKernel_0(double var0, double var2, double var4, double var6, double var8, double var10, double var12, int var14);

    private static native long getGaborKernel_1(double var0, double var2, double var4, double var6, double var8, double var10);

    private static native long getGaussianKernel_0(int var0, double var1, int var3);

    private static native long getGaussianKernel_1(int var0, double var1);

    private static native long getPerspectiveTransform_0(long var0, long var2);

    private static native void getRectSubPix_0(long var0, double var2, double var4, double var6, double var8, long var10, int var12);

    private static native void getRectSubPix_1(long var0, double var2, double var4, double var6, double var8, long var10);

    private static native long getRotationMatrix2D_0(double var0, double var2, double var4, double var6);

    private static native long getStructuringElement_0(int var0, double var1, double var3, double var5, double var7);

    private static native long getStructuringElement_1(int var0, double var1, double var3);

    private static native void goodFeaturesToTrack_0(long var0, long var2, int var4, double var5, double var7, long var9, int var11, boolean var12, double var13);

    private static native void goodFeaturesToTrack_1(long var0, long var2, int var4, double var5, double var7);

    private static native void grabCut_0(long var0, long var2, int var4, int var5, int var6, int var7, long var8, long var10, int var12, int var13);

    private static native void grabCut_1(long var0, long var2, int var4, int var5, int var6, int var7, long var8, long var10, int var12);

    private static native void initUndistortRectifyMap_0(long var0, long var2, long var4, long var6, double var8, double var10, int var12, long var13, long var15);

    private static native float initWideAngleProjMap_0(long var0, long var2, double var4, double var6, int var8, int var9, long var10, long var12, int var14, double var15);

    private static native float initWideAngleProjMap_1(long var0, long var2, double var4, double var6, int var8, int var9, long var10, long var12);

    private static native void integral_0(long var0, long var2, int var4);

    private static native void integral_1(long var0, long var2);

    private static native void integral2_0(long var0, long var2, long var4, int var6);

    private static native void integral2_1(long var0, long var2, long var4);

    private static native void integral3_0(long var0, long var2, long var4, long var6, int var8);

    private static native void integral3_1(long var0, long var2, long var4, long var6);

    private static native float intersectConvexConvex_0(long var0, long var2, long var4, boolean var6);

    private static native float intersectConvexConvex_1(long var0, long var2, long var4);

    private static native void invertAffineTransform_0(long var0, long var2);

    private static native boolean isContourConvex_0(long var0);

    private static native double matchShapes_0(long var0, long var2, int var4, double var5);

    private static native void matchTemplate_0(long var0, long var2, long var4, int var6);

    private static native void medianBlur_0(long var0, long var2, int var4);

    private static native double[] minAreaRect_0(long var0);

    private static native void minEnclosingCircle_0(long var0, double[] var2, double[] var3);

    private static native long moments_0(long var0, boolean var2);

    private static native long moments_1(long var0);

    private static native void morphologyEx_0(long var0, long var2, int var4, long var5, double var7, double var9, int var11, int var12, double var13, double var15, double var17, double var19);

    private static native void morphologyEx_1(long var0, long var2, int var4, long var5, double var7, double var9, int var11);

    private static native void morphologyEx_2(long var0, long var2, int var4, long var5);

    private static native double[] phaseCorrelate_0(long var0, long var2, long var4);

    private static native double[] phaseCorrelate_1(long var0, long var2);

    private static native double[] phaseCorrelateRes_0(long var0, long var2, long var4, double[] var6);

    private static native double[] phaseCorrelateRes_1(long var0, long var2, long var4);

    private static native double pointPolygonTest_0(long var0, double var2, double var4, boolean var6);

    private static native void preCornerDetect_0(long var0, long var2, int var4, int var5);

    private static native void preCornerDetect_1(long var0, long var2, int var4);

    private static native void pyrDown_0(long var0, long var2, double var4, double var6, int var8);

    private static native void pyrDown_1(long var0, long var2, double var4, double var6);

    private static native void pyrDown_2(long var0, long var2);

    private static native void pyrMeanShiftFiltering_0(long var0, long var2, double var4, double var6, int var8, int var9, int var10, double var11);

    private static native void pyrMeanShiftFiltering_1(long var0, long var2, double var4, double var6);

    private static native void pyrUp_0(long var0, long var2, double var4, double var6, int var8);

    private static native void pyrUp_1(long var0, long var2, double var4, double var6);

    private static native void pyrUp_2(long var0, long var2);

    private static native void remap_0(long var0, long var2, long var4, long var6, int var8, int var9, double var10, double var12, double var14, double var16);

    private static native void remap_1(long var0, long var2, long var4, long var6, int var8);

    private static native void resize_0(long var0, long var2, double var4, double var6, double var8, double var10, int var12);

    private static native void resize_1(long var0, long var2, double var4, double var6);

    private static native void sepFilter2D_0(long var0, long var2, int var4, long var5, long var7, double var9, double var11, double var13, int var15);

    private static native void sepFilter2D_1(long var0, long var2, int var4, long var5, long var7, double var9, double var11, double var13);

    private static native void sepFilter2D_2(long var0, long var2, int var4, long var5, long var7);

    private static native double threshold_0(long var0, long var2, double var4, double var6, int var8);

    private static native void undistort_0(long var0, long var2, long var4, long var6, long var8);

    private static native void undistort_1(long var0, long var2, long var4, long var6);

    private static native void undistortPoints_0(long var0, long var2, long var4, long var6, long var8, long var10);

    private static native void undistortPoints_1(long var0, long var2, long var4, long var6);

    private static native void warpAffine_0(long var0, long var2, long var4, double var6, double var8, int var10, int var11, double var12, double var14, double var16, double var18);

    private static native void warpAffine_1(long var0, long var2, long var4, double var6, double var8, int var10);

    private static native void warpAffine_2(long var0, long var2, long var4, double var6, double var8);

    private static native void warpPerspective_0(long var0, long var2, long var4, double var6, double var8, int var10, int var11, double var12, double var14, double var16, double var18);

    private static native void warpPerspective_1(long var0, long var2, long var4, double var6, double var8, int var10);

    private static native void warpPerspective_2(long var0, long var2, long var4, double var6, double var8);

    private static native void watershed_0(long var0, long var2);
}

