/*
 * Decompiled with CFR 0.152.
 */
package org.opencv.features2d;

import java.util.ArrayList;
import java.util.List;
import org.opencv.core.Mat;
import org.opencv.core.MatOfKeyPoint;
import org.opencv.utils.Converters;

public class DescriptorExtractor {
    protected final long nativeObj;
    private static final int OPPONENTEXTRACTOR = 1000;
    public static final int SIFT = 1;
    public static final int SURF = 2;
    public static final int ORB = 3;
    public static final int BRIEF = 4;
    public static final int BRISK = 5;
    public static final int FREAK = 6;
    public static final int OPPONENT_SIFT = 1001;
    public static final int OPPONENT_SURF = 1002;
    public static final int OPPONENT_ORB = 1003;
    public static final int OPPONENT_BRIEF = 1004;
    public static final int OPPONENT_BRISK = 1005;
    public static final int OPPONENT_FREAK = 1006;

    protected DescriptorExtractor(long addr) {
        this.nativeObj = addr;
    }

    public void compute(Mat image, MatOfKeyPoint keypoints, Mat descriptors) {
        MatOfKeyPoint keypoints_mat = keypoints;
        DescriptorExtractor.compute_0(this.nativeObj, image.nativeObj, keypoints_mat.nativeObj, descriptors.nativeObj);
    }

    public void compute(List<Mat> images, List<MatOfKeyPoint> keypoints, List<Mat> descriptors) {
        Mat images_mat = Converters.vector_Mat_to_Mat(images);
        ArrayList<Mat> keypoints_tmplm = new ArrayList<Mat>(keypoints != null ? keypoints.size() : 0);
        Mat keypoints_mat = Converters.vector_vector_KeyPoint_to_Mat(keypoints, keypoints_tmplm);
        Mat descriptors_mat = new Mat();
        DescriptorExtractor.compute_1(this.nativeObj, images_mat.nativeObj, keypoints_mat.nativeObj, descriptors_mat.nativeObj);
        Converters.Mat_to_vector_vector_KeyPoint(keypoints_mat, keypoints);
        keypoints_mat.release();
        Converters.Mat_to_vector_Mat(descriptors_mat, descriptors);
        descriptors_mat.release();
    }

    public static DescriptorExtractor create(int extractorType) {
        DescriptorExtractor retVal = new DescriptorExtractor(DescriptorExtractor.create_0(extractorType));
        return retVal;
    }

    public int descriptorSize() {
        int retVal = DescriptorExtractor.descriptorSize_0(this.nativeObj);
        return retVal;
    }

    public int descriptorType() {
        int retVal = DescriptorExtractor.descriptorType_0(this.nativeObj);
        return retVal;
    }

    public boolean empty() {
        boolean retVal = DescriptorExtractor.empty_0(this.nativeObj);
        return retVal;
    }

    public void read(String fileName) {
        DescriptorExtractor.read_0(this.nativeObj, fileName);
    }

    public void write(String fileName) {
        DescriptorExtractor.write_0(this.nativeObj, fileName);
    }

    protected void finalize() throws Throwable {
        DescriptorExtractor.delete(this.nativeObj);
    }

    private static native void compute_0(long var0, long var2, long var4, long var6);

    private static native void compute_1(long var0, long var2, long var4, long var6);

    private static native long create_0(int var0);

    private static native int descriptorSize_0(long var0);

    private static native int descriptorType_0(long var0);

    private static native boolean empty_0(long var0);

    private static native void read_0(long var0, String var2);

    private static native void write_0(long var0, String var2);

    private static native void delete(long var0);
}

