/*
 * Decompiled with CFR 0.152.
 */
package org.opencv.contrib;

import java.util.List;
import org.opencv.core.Algorithm;
import org.opencv.core.Mat;
import org.opencv.utils.Converters;

public class FaceRecognizer
extends Algorithm {
    protected FaceRecognizer(long addr) {
        super(addr);
    }

    public void load(String filename) {
        FaceRecognizer.load_0(this.nativeObj, filename);
    }

    public void predict(Mat src, int[] label, double[] confidence) {
        double[] label_out = new double[1];
        double[] confidence_out = new double[1];
        FaceRecognizer.predict_0(this.nativeObj, src.nativeObj, label_out, confidence_out);
        if (label != null) {
            label[0] = (int)label_out[0];
        }
        if (confidence != null) {
            confidence[0] = confidence_out[0];
        }
    }

    public void save(String filename) {
        FaceRecognizer.save_0(this.nativeObj, filename);
    }

    public void train(List<Mat> src, Mat labels) {
        Mat src_mat = Converters.vector_Mat_to_Mat(src);
        FaceRecognizer.train_0(this.nativeObj, src_mat.nativeObj, labels.nativeObj);
    }

    public void update(List<Mat> src, Mat labels) {
        Mat src_mat = Converters.vector_Mat_to_Mat(src);
        FaceRecognizer.update_0(this.nativeObj, src_mat.nativeObj, labels.nativeObj);
    }

    @Override
    protected void finalize() throws Throwable {
        FaceRecognizer.delete(this.nativeObj);
    }

    private static native void load_0(long var0, String var2);

    private static native void predict_0(long var0, long var2, double[] var4, double[] var5);

    private static native void save_0(long var0, String var2);

    private static native void train_0(long var0, long var2, long var4);

    private static native void update_0(long var0, long var2, long var4);

    private static native void delete(long var0);
}

