/*
 * Decompiled with CFR 0.152.
 */
package org.opencv.ml;

import org.opencv.core.Mat;
import org.opencv.core.Range;
import org.opencv.ml.CvGBTreesParams;
import org.opencv.ml.CvStatModel;

public class CvGBTrees
extends CvStatModel {
    public static final int SQUARED_LOSS = 0;
    public static final int ABSOLUTE_LOSS = 1;
    public static final int HUBER_LOSS = 3;
    public static final int DEVIANCE_LOSS = 4;

    protected CvGBTrees(long addr) {
        super(addr);
    }

    public CvGBTrees() {
        super(CvGBTrees.CvGBTrees_0());
    }

    public CvGBTrees(Mat trainData, int tflag, Mat responses, Mat varIdx, Mat sampleIdx, Mat varType, Mat missingDataMask, CvGBTreesParams params) {
        super(CvGBTrees.CvGBTrees_1(trainData.nativeObj, tflag, responses.nativeObj, varIdx.nativeObj, sampleIdx.nativeObj, varType.nativeObj, missingDataMask.nativeObj, params.nativeObj));
    }

    public CvGBTrees(Mat trainData, int tflag, Mat responses) {
        super(CvGBTrees.CvGBTrees_2(trainData.nativeObj, tflag, responses.nativeObj));
    }

    public void clear() {
        CvGBTrees.clear_0(this.nativeObj);
    }

    public float predict(Mat sample, Mat missing, Range slice, int k) {
        float retVal = CvGBTrees.predict_0(this.nativeObj, sample.nativeObj, missing.nativeObj, slice.start, slice.end, k);
        return retVal;
    }

    public float predict(Mat sample) {
        float retVal = CvGBTrees.predict_1(this.nativeObj, sample.nativeObj);
        return retVal;
    }

    public boolean train(Mat trainData, int tflag, Mat responses, Mat varIdx, Mat sampleIdx, Mat varType, Mat missingDataMask, CvGBTreesParams params, boolean update) {
        boolean retVal = CvGBTrees.train_0(this.nativeObj, trainData.nativeObj, tflag, responses.nativeObj, varIdx.nativeObj, sampleIdx.nativeObj, varType.nativeObj, missingDataMask.nativeObj, params.nativeObj, update);
        return retVal;
    }

    public boolean train(Mat trainData, int tflag, Mat responses) {
        boolean retVal = CvGBTrees.train_1(this.nativeObj, trainData.nativeObj, tflag, responses.nativeObj);
        return retVal;
    }

    @Override
    protected void finalize() throws Throwable {
        CvGBTrees.delete(this.nativeObj);
    }

    private static native long CvGBTrees_0();

    private static native long CvGBTrees_1(long var0, int var2, long var3, long var5, long var7, long var9, long var11, long var13);

    private static native long CvGBTrees_2(long var0, int var2, long var3);

    private static native void clear_0(long var0);

    private static native float predict_0(long var0, long var2, long var4, int var6, int var7, int var8);

    private static native float predict_1(long var0, long var2);

    private static native boolean train_0(long var0, long var2, int var4, long var5, long var7, long var9, long var11, long var13, long var15, boolean var17);

    private static native boolean train_1(long var0, long var2, int var4, long var5);

    private static native void delete(long var0);
}

