/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.smoketest.utils;

import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.net.InetSocketAddress;
import javax.sql.DataSource;
import org.hibernate.SessionFactory;
import org.opennms.netmgt.dao.hibernate.AbstractDaoHibernate;
import org.springframework.orm.hibernate3.HibernateTemplate;
import org.springframework.orm.hibernate3.annotation.AnnotationSessionFactoryBean;

public class HibernateDaoFactory {
    private final SessionFactory m_sessionFactory;
    private final HibernateTemplate m_hibernateTemplate;

    public HibernateDaoFactory(InetSocketAddress pgsqlAddr) {
        HikariConfig config = new HikariConfig();
        config.setJdbcUrl("jdbc:postgresql://" + pgsqlAddr.getHostString() + ":" + pgsqlAddr.getPort() + "/opennms");
        config.setUsername("opennms");
        config.setPassword("opennms");
        HikariDataSource ds = new HikariDataSource(config);
        AnnotationSessionFactoryBean sfb = new AnnotationSessionFactoryBean();
        sfb.setDataSource((DataSource)ds);
        sfb.setPackagesToScan(new String[]{"org.opennms.netmgt.model", "org.opennms.features.deviceconfig.persistence.api"});
        try {
            sfb.afterPropertiesSet();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.m_sessionFactory = sfb.getObject();
        this.m_hibernateTemplate = new HibernateTemplate(this.m_sessionFactory);
    }

    public <T extends AbstractDaoHibernate<?, ?>> T getDao(Class<T> clazz) {
        try {
            AbstractDaoHibernate dao = (AbstractDaoHibernate)clazz.newInstance();
            dao.setHibernateTemplate(this.m_hibernateTemplate);
            dao.setSessionFactory(this.m_sessionFactory);
            return (T)dao;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

