/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.smoketest.ui.framework;

import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.opennms.smoketest.selenium.AbstractOpenNMSSeleniumHelper;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Element {
    protected final Logger LOG = LoggerFactory.getLogger(this.getClass());
    protected final WebDriver driver;
    private final int implicitWait;
    private final TimeUnit implicitWaitUnit;

    public Element(WebDriver driver, int implicitWait, TimeUnit implictWaitUnit) {
        this.driver = Objects.requireNonNull(driver);
        this.implicitWait = implicitWait;
        this.implicitWaitUnit = Objects.requireNonNull(implictWaitUnit);
    }

    public Element(WebDriver driver) {
        this(driver, 2, TimeUnit.SECONDS);
    }

    public WebElement findElementById(String id) {
        this.LOG.debug("findElementById: id={}", (Object)id);
        return this.execute(() -> this.driver.findElement(By.id((String)id)));
    }

    public WebElement findElementByLink(String link) {
        this.LOG.debug("findElementByLink: link={}", (Object)link);
        return this.execute(() -> this.driver.findElement(By.linkText((String)link)));
    }

    public WebElement findElementByName(String name) {
        this.LOG.debug("findElementByName: name={}", (Object)name);
        return this.execute(() -> this.driver.findElement(By.name((String)name)));
    }

    public WebElement findElementByCss(String css) {
        this.LOG.debug("findElementByCss: selector={}", (Object)css);
        return this.execute(() -> this.driver.findElement(By.cssSelector((String)css)));
    }

    public WebElement findElementByXpath(String xpath) {
        this.LOG.debug("findElementByXpath: selector={}", (Object)xpath);
        return this.execute(() -> this.driver.findElement(By.xpath((String)xpath)));
    }

    public WebDriver getDriver() {
        return this.driver;
    }

    protected <X> X execute(Supplier<X> supplier) {
        try {
            this.driver.manage().timeouts().implicitlyWait((long)this.implicitWait, TimeUnit.SECONDS);
            X x = supplier.get();
            return x;
        }
        finally {
            this.driver.manage().timeouts().implicitlyWait(AbstractOpenNMSSeleniumHelper.LOAD_TIMEOUT, TimeUnit.MILLISECONDS);
        }
    }
}

