/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.smoketest.utils;

import java.nio.file.Path;
import java.nio.file.Paths;

public class TargetRoot {
    private final Path targetRoot;

    public TargetRoot() {
        this(TargetRoot.class);
    }

    public TargetRoot(Class clazz) {
        String relPath = clazz.getProtectionDomain().getCodeSource().getLocation().getFile();
        Path jarOrClassRoot = Paths.get(relPath, new String[0]);
        this.targetRoot = this.determineTargetRoot(jarOrClassRoot);
    }

    public Path getPath() {
        return this.targetRoot;
    }

    public Path getPath(String ... paths) {
        return Paths.get(this.targetRoot.toString(), paths);
    }

    private Path determineTargetRoot(Path jarOrClassRoot) {
        if (jarOrClassRoot.toFile().isFile()) {
            jarOrClassRoot = jarOrClassRoot.getParent();
        }
        while (jarOrClassRoot != null && !"target".equals(jarOrClassRoot.getFileName().toString())) {
            jarOrClassRoot = jarOrClassRoot.getParent();
        }
        if (jarOrClassRoot == null) {
            throw new IllegalArgumentException("No target directory found in " + jarOrClassRoot);
        }
        return jarOrClassRoot;
    }
}

