/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.smoketest.telemetry;

import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import org.opennms.smoketest.telemetry.FlowPacket;
import org.opennms.smoketest.telemetry.FlowTester;
import org.opennms.smoketest.telemetry.Packets;
import org.opennms.smoketest.telemetry.Sender;

public class FlowTestBuilder {
    private final List<FlowTester.Delivery> deliveries = new ArrayList<FlowTester.Delivery>();
    private final List<Consumer<FlowTester>> runBefore = new ArrayList<Consumer<FlowTester>>();
    private final List<Consumer<FlowTester>> runAfter = new ArrayList<Consumer<FlowTester>>();
    private InetSocketAddress opennmsWebAddress;

    public FlowTestBuilder withFlowPacket(FlowPacket packet, Sender sender) {
        this.deliveries.add(new FlowTester.Delivery(packet, sender));
        return this;
    }

    public FlowTestBuilder withFlowPackets(List<FlowTester.Delivery> deliveries) {
        this.deliveries.addAll(deliveries);
        return this;
    }

    public FlowTestBuilder withFlowPackets(List<FlowPacket> packets, Sender sender) {
        packets.stream().map(packet -> new FlowTester.Delivery((FlowPacket)packet, sender)).forEach(this.deliveries::add);
        return this;
    }

    public FlowTestBuilder verifyOpennmsRestEndpoint(InetSocketAddress opennmsWebAddress) {
        this.opennmsWebAddress = Objects.requireNonNull(opennmsWebAddress);
        return this;
    }

    public FlowTestBuilder withNetflow5Packet(Sender sender) {
        return this.withFlowPacket(Packets.Netflow5, sender);
    }

    public FlowTestBuilder withNetflow9Packet(Sender sender) {
        return this.withFlowPacket(Packets.Netflow9, sender);
    }

    public FlowTestBuilder withIpfixPacket(Sender sender) {
        return this.withFlowPacket(Packets.Ipfix, sender);
    }

    public FlowTestBuilder withSFlowPacket(Sender sender) {
        return this.withFlowPacket(Packets.SFlow, sender);
    }

    public FlowTestBuilder verifyBeforeSendingFlows(Consumer<FlowTester> before) {
        this.runBefore.add(before);
        return this;
    }

    public FlowTestBuilder verifyAfterSendingFlows(Consumer<FlowTester> after) {
        this.runAfter.add(after);
        return this;
    }

    public FlowTester build(InetSocketAddress elasticAddress) {
        FlowTester flowTester = new FlowTester(elasticAddress, this.opennmsWebAddress, this.deliveries);
        flowTester.setRunAfter(this.runAfter);
        flowTester.setRunBefore(this.runBefore);
        return flowTester;
    }
}

