/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.smoketest.stacks;

import com.google.common.io.Resources;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.attribute.PosixFilePermission;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import org.opennms.smoketest.containers.OpenNMSContainer;
import org.opennms.smoketest.stacks.OverlayFile;
import org.testcontainers.containers.wait.strategy.WaitStrategy;

public class OpenNMSProfile {
    public static OpenNMSProfile DEFAULT = OpenNMSProfile.newBuilder().build();
    private final boolean jvmDebuggingEnabled;
    private final boolean kafkaProducerEnabled;
    private final List<OverlayFile> files;
    private final Function<OpenNMSContainer, WaitStrategy> waitStrategy;
    private final HashMap<String, Path> installFeatures;

    private OpenNMSProfile(Builder builder) {
        this.jvmDebuggingEnabled = builder.jvmDebuggingEnabled;
        this.kafkaProducerEnabled = builder.kafkaProducerEnabled;
        this.files = Collections.unmodifiableList(builder.files);
        this.waitStrategy = Objects.requireNonNull(builder.waitStrategy);
        this.installFeatures = Objects.requireNonNull(builder.installFeatures);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public boolean isJvmDebuggingEnabled() {
        return this.jvmDebuggingEnabled;
    }

    public boolean isKafkaProducerEnabled() {
        return this.kafkaProducerEnabled;
    }

    public List<OverlayFile> getFiles() {
        return this.files;
    }

    public Function<OpenNMSContainer, WaitStrategy> getWaitStrategy() {
        return this.waitStrategy;
    }

    public HashMap<String, Path> getInstallFeatures() {
        return this.installFeatures;
    }

    public static final class Builder {
        private boolean jvmDebuggingEnabled = false;
        private boolean kafkaProducerEnabled = false;
        private List<OverlayFile> files = new LinkedList<OverlayFile>();
        private Function<OpenNMSContainer, WaitStrategy> waitStrategy = OpenNMSContainer.WaitForOpenNMS::new;
        private HashMap<String, Path> installFeatures = new LinkedHashMap<String, Path>();

        public Builder withJvmDebuggingEnabled(boolean enabled) {
            this.jvmDebuggingEnabled = enabled;
            return this;
        }

        public Builder withKafkaProducerEnabled(boolean enabled) {
            this.kafkaProducerEnabled = enabled;
            return this;
        }

        public Builder withFile(Path source, String target) {
            try {
                this.files.add(new OverlayFile(source.toUri().toURL(), target));
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
            return this;
        }

        public Builder withFile(URL source, String target) {
            this.files.add(new OverlayFile(source, target));
            return this;
        }

        public Builder withFile(String resourceName, String target) {
            this.files.add(new OverlayFile(Resources.getResource((String)resourceName), target));
            return this;
        }

        public Builder withFile(URL source, String target, Set<PosixFilePermission> permissions) {
            this.files.add(new OverlayFile(source, target, permissions));
            return this;
        }

        public Builder withFile(String resourceName, String target, Set<PosixFilePermission> permissions) {
            this.files.add(new OverlayFile(Resources.getResource((String)resourceName), target, permissions));
            return this;
        }

        public Builder withWaitStrategy(Function<OpenNMSContainer, WaitStrategy> waitStrategy) {
            this.waitStrategy = waitStrategy;
            return this;
        }

        public Builder withInstallFeature(String feature) {
            return this.withInstallFeature(feature, null, null);
        }

        public Builder withInstallFeature(String feature, String waitForKar) {
            return this.withInstallFeature(feature, waitForKar, null);
        }

        public Builder withInstallFeature(String feature, String waitForKar, Path karFile) {
            if (waitForKar != null) {
                this.installFeatures.put(String.format("%s wait-for-kar=%s", feature, waitForKar), karFile);
            } else {
                this.installFeatures.put(feature, karFile);
            }
            return this;
        }

        public Builder withDisableFeature(String feature) {
            return this.withInstallFeature(String.format("!%s", feature), null, null);
        }

        public OpenNMSProfile build() {
            return new OpenNMSProfile(this);
        }
    }
}

