/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.smoketest.utils;

import java.io.PrintStream;
import java.net.InetSocketAddress;
import java.time.Duration;
import java.util.LinkedList;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.apache.commons.lang3.tuple.Pair;
import org.awaitility.Awaitility;
import org.opennms.smoketest.utils.SshClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KarafShell {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final InetSocketAddress sshAddress;
    private final String username;
    private final String password;

    public KarafShell(InetSocketAddress sshAddress) {
        this(sshAddress, "admin", "admin");
    }

    public KarafShell(InetSocketAddress sshAddress, String username, String password) {
        this.sshAddress = Objects.requireNonNull(sshAddress);
        this.username = username;
        this.password = password;
    }

    public KarafShell runCommand(String command, Function<String, Boolean> verifyOutputFunction) {
        return this.runCommand(command, verifyOutputFunction, true);
    }

    public KarafShell runCommand(String command, Function<String, Boolean> verifyOutputFunction, boolean displayLogs) {
        Awaitility.await().atMost(5L, TimeUnit.MINUTES).pollInterval(5L, TimeUnit.SECONDS).until(() -> this.runCommandOnce(command, verifyOutputFunction, displayLogs));
        return this;
    }

    public Boolean runCommandOnce(String command, Function<String, Boolean> verifyOutputFunction, boolean displayLogs) {
        Boolean bl;
        SshClient sshClient = new SshClient(this.sshAddress, this.username, this.password);
        try {
            PrintStream pipe = sshClient.openShell();
            LinkedList<String> foo = new LinkedList<String>();
            if (command != null) {
                foo.add(command);
            }
            if (displayLogs) {
                foo.add("log:display");
            }
            Pair<String, String> output = this.run(foo.toArray(new String[0]));
            boolean result = true;
            if (verifyOutputFunction != null) {
                result = verifyOutputFunction.apply((String)output.getLeft());
            }
            if (command != null) {
                this.logger.info(command);
            }
            if (displayLogs) {
                this.logger.info("log:display");
            }
            this.logger.info("{}", output.getLeft());
            bl = result;
        }
        catch (Throwable throwable) {
            try {
                try {
                    sshClient.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception ex) {
                this.logger.error("Error while executing command '{}': {}", (Object)command, (Object)ex.getMessage());
                return false;
            }
        }
        sshClient.close();
        return bl;
    }

    public Pair<String, String> run(String ... command) throws Exception {
        try (SshClient sshClient = new SshClient(this.sshAddress, this.username, this.password);){
            PrintStream pipe = sshClient.openShell();
            for (String c : command) {
                pipe.println(c);
            }
            pipe.println("logout");
            Awaitility.await().atMost(30L, TimeUnit.SECONDS).until(sshClient.isShellClosedCallable());
            Pair pair = Pair.of((Object)sshClient.getStdout(), (Object)sshClient.getStderr());
            return pair;
        }
    }

    public KarafShell runCommand(String command) {
        this.runCommand(command, null);
        return this;
    }

    public KarafShell verifyLog(Function<String, Boolean> function) {
        Objects.requireNonNull(function);
        this.runCommand(null, function);
        return this;
    }

    public void checkFeature(String feature, String regex, Duration wait) {
        Awaitility.await((String)String.format("waiting for feature %s state to match regex '%s'", feature, regex)).atMost(wait).until(() -> this.runCommandOnce("feature:list | grep " + feature, output -> output.matches("(?ms).*?\\|\\s*(" + regex + ")\\s*\\|.*"), false));
    }
}

