/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.smoketest.stacks;

import java.util.HashMap;
import java.util.Map;

public enum KafkaCompressionStrategy {
    GZIP("gzip"),
    SNAPPY("snappy"),
    LZ4("lz4"),
    ZSTD("zstd"),
    NONE("none");

    private String codec;
    private static final Map<String, KafkaCompressionStrategy> lookup;

    private KafkaCompressionStrategy(String codec) {
        this.codec = codec;
    }

    public String getCodec() {
        return this.codec;
    }

    public static KafkaCompressionStrategy get(String codec) {
        return lookup.get(codec);
    }

    static {
        lookup = new HashMap<String, KafkaCompressionStrategy>();
        for (KafkaCompressionStrategy codec : KafkaCompressionStrategy.values()) {
            lookup.put(codec.getCodec(), codec);
        }
    }
}

