/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.smoketest.graphml;

import java.io.InputStream;
import java.util.Objects;
import org.opennms.smoketest.utils.RestClient;

public class GraphmlDocument {
    private final String name;
    private final String resource;

    public GraphmlDocument(String graphName, String graphResource) {
        this.name = Objects.requireNonNull(graphName);
        this.resource = Objects.requireNonNull(graphResource);
        Objects.requireNonNull(this.getResourceAsStream());
    }

    public void create(RestClient client) {
        if (client.getGraphML(this.name).getStatus() == 404) {
            client.sendGraphML(this.name, this.getResourceAsStream());
        }
    }

    public void delete(RestClient client) {
        if (client.getGraphML(this.name).getStatus() != 404) {
            client.deleteGraphML(this.name);
        }
    }

    public boolean exists(RestClient client) {
        return client.getGraphML(this.name).getStatus() == 200;
    }

    private InputStream getResourceAsStream() {
        return this.getClass().getResourceAsStream(this.resource);
    }
}

