/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.smoketest.utils;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.List;
import java.util.Optional;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Response;
import org.apache.commons.io.IOUtils;

public class RestHealthClient {
    private URL url;
    private Optional<String> alias;
    private Client client;
    private static final String PROBE = "/rest/health/probe";
    private static final String SUCCESS_PROBE = "Everything is awesome";
    private static final String HEALTH_KEY = "Health";

    public RestHealthClient(URL webUrl, Optional<String> alias) {
        this.alias = alias;
        this.url = webUrl;
        this.client = ClientBuilder.newClient();
    }

    private WebTarget getTargetFor(String path) {
        return this.alias.isPresent() ? this.client.target(this.url.toString()).path(this.alias.get()).path(path) : this.client.target(this.url.toString()).path(path);
    }

    public String getProbeHealthResponse() {
        Response response = this.getTargetFor(PROBE).request(new String[]{"text/plain"}).get();
        if (response.getStatus() == 200 && response.getHeaders().containsKey((Object)HEALTH_KEY)) {
            return ((List)response.getHeaders().get((Object)HEALTH_KEY)).toString();
        }
        try {
            return "Response status != 200 or Health header not found. Dumping response.\nStatus: " + response.getStatus() + "\nHeaders: " + response.getStringHeaders() + "\n" + IOUtils.toString((InputStream)((InputStream)response.getEntity()));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public String getProbeSuccessMessage() {
        return SUCCESS_PROBE;
    }
}

