/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.smoketest.containers;

import java.net.MalformedURLException;
import java.net.URL;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.Network;

public class WebhookEndpointContainer
extends GenericContainer<WebhookEndpointContainer> {
    private static final String ALIAS = "opennms-dummy-http-endpoint";
    private static final int PORT = 8080;

    public WebhookEndpointContainer() {
        super("opennms/dummy-http-endpoint:0.0.2");
        this.addExposedPort(8080);
        this.withNetwork(Network.SHARED);
        this.withNetworkAliases(new String[]{ALIAS});
    }

    public int getWebPort() {
        return this.getMappedPort(8080);
    }

    public URL getBaseUrlExternal() {
        try {
            return new URL(String.format("http://%s:%d/", this.getContainerIpAddress(), this.getMappedPort(8080)));
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }
}

