/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.smoketest.utils;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.Response;
import org.opennms.core.xml.JaxbUtils;
import org.opennms.netmgt.measurements.model.QueryRequest;
import org.opennms.netmgt.measurements.model.QueryResponse;
import org.opennms.netmgt.model.OnmsAlarmCollection;
import org.opennms.netmgt.model.OnmsApplication;
import org.opennms.netmgt.model.OnmsCategory;
import org.opennms.netmgt.model.OnmsEvent;
import org.opennms.netmgt.model.OnmsEventCollection;
import org.opennms.netmgt.model.OnmsIpInterface;
import org.opennms.netmgt.model.OnmsMonitoredService;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.minion.OnmsMinion;
import org.opennms.netmgt.model.resource.ResourceDTO;
import org.opennms.netmgt.provision.persist.requisition.Requisition;
import org.opennms.netmgt.xml.event.Event;
import org.opennms.smoketest.utils.XmlUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestClient {
    private static final Logger LOG = LoggerFactory.getLogger(RestClient.class);
    private static final String DEFAULT_USERNAME = "admin";
    private static final String DEFAULT_PASSWORD = "admin";
    private final String authorizationHeader;
    private final URL url;

    public RestClient(InetSocketAddress addr) {
        this(addr, "admin", "admin");
    }

    public RestClient(URL url) {
        this(url, "admin", "admin");
    }

    public RestClient(InetSocketAddress addr, String username, String password) {
        this(RestClient.toUrl(addr), username, password);
    }

    public RestClient(URL url, String username, String password) {
        this.url = url;
        this.authorizationHeader = "Basic " + Base64.getEncoder().encodeToString((username + ":" + password).getBytes());
    }

    public static RestClient forLocalhost() {
        return new RestClient(InetSocketAddress.createUnresolved("127.0.0.1", 8980));
    }

    private static URL toUrl(InetSocketAddress addr) {
        try {
            return new URL(String.format("http://%s:%d/opennms", addr.getHostString(), addr.getPort()));
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    public String getDisplayVersion() {
        WebTarget target = this.getTarget().path("info");
        String json = (String)this.getBuilder(target).get(String.class);
        ObjectMapper mapper = new ObjectMapper();
        try {
            JsonNode actualObj = mapper.readTree(json);
            return actualObj.get("displayVersion").asText();
        }
        catch (IOException e) {
            LOG.debug("Failed to get displayVersion from the info REST service. (OpenNMS is probably not up yet): {}", (Object)e.getMessage());
            return null;
        }
    }

    public void addOrReplaceRequisition(Requisition requisition) {
        WebTarget target = this.getTarget().path("requisitions");
        this.getBuilder(target).post(Entity.entity((Object)requisition, (String)"application/xml"));
    }

    public void importRequisition(String foreignSource) {
        WebTarget target = this.getTarget().path("requisitions").path(foreignSource).path("import");
        this.getBuilder(target).put(null);
    }

    public List<OnmsNode> getNodes() {
        GenericType<List<OnmsNode>> nodes = new GenericType<List<OnmsNode>>(){};
        WebTarget target = this.getTarget().path("nodes");
        return (List)this.getBuilder(target).get((GenericType)nodes);
    }

    public List<OnmsMonitoredService> getServicesForANode(String nodeCriteria, String ipAddress) {
        GenericType<List<OnmsMonitoredService>> services = new GenericType<List<OnmsMonitoredService>>(){};
        WebTarget target = this.getTarget().path("nodes").path(nodeCriteria).path("ipinterfaces").path(ipAddress).path("services");
        return (List)this.getBuilder(target).get((GenericType)services);
    }

    public QueryResponse getMeasurements(QueryRequest request) {
        WebTarget target = this.getTarget().path("measurements");
        return (QueryResponse)this.getBuilder(target).post(Entity.entity((Object)request, (String)"application/xml"), QueryResponse.class);
    }

    public OnmsNode getNode(String nodeCriteria) {
        WebTarget target = this.getTarget().path("nodes").path(nodeCriteria);
        return (OnmsNode)this.getBuilder(target).get(OnmsNode.class);
    }

    public Map<String, Object> getUsageStatistics() throws Exception {
        Response response = this.getBuilder(this.getTarget().path("datachoices")).get();
        String jsonContent = (String)response.readEntity(String.class);
        Map hashMap = (Map)new ObjectMapper().readValue(jsonContent, HashMap.class);
        return hashMap.entrySet().stream().collect(Collectors.toMap(e -> (String)e.getKey(), e -> {
            if (e.getValue() instanceof Integer) {
                return (long)((Integer)e.getValue()).intValue();
            }
            return e.getValue();
        }));
    }

    public Response getResponseForNode(String nodeCriteria) {
        WebTarget target = this.getTarget().path("nodes").path(nodeCriteria);
        return this.getBuilder(target).get();
    }

    public Response addNode(OnmsNode onmsNode) {
        WebTarget target = this.getTarget().path("nodes");
        return this.getBuilder(target).post(Entity.entity((Object)onmsNode, (String)"application/xml"));
    }

    public Response addInterface(String nodeCriteria, OnmsIpInterface ipInterface) {
        WebTarget target = this.getTarget().path("nodes").path(nodeCriteria).path("ipinterfaces");
        String ipInterfaceXml = XmlUtils.filterAttributesFromXml(JaxbUtils.marshal((Object)ipInterface), "isDown", "hasFlows", "monitoredServiceCount");
        return this.getBuilder(target).post(Entity.entity((Object)ipInterfaceXml, (String)"application/xml"));
    }

    public Response deleteInterface(String nodeCriteria, String ipAddress) {
        WebTarget target = this.getTarget().path("nodes").path(nodeCriteria).path("ipinterfaces").path(ipAddress);
        return this.getBuilder(target).delete();
    }

    public Response addService(String nodeCriteria, String ipAddress, OnmsMonitoredService service) {
        WebTarget target = this.getTarget().path("nodes").path(nodeCriteria).path("ipinterfaces").path(ipAddress).path("services");
        String serviceXml = XmlUtils.filterAttributesFromXml(JaxbUtils.marshal((Object)service), "down", "statusLong");
        return this.getBuilder(target).post(Entity.entity((Object)serviceXml, (String)"application/xml"));
    }

    public OnmsMonitoredService getService(String nodeCriteria, String ipAddress, String service) {
        WebTarget target = this.getTarget().path("nodes").path(nodeCriteria).path("ipinterfaces").path(ipAddress).path("services").path(service);
        return (OnmsMonitoredService)this.getBuilder(target).get(OnmsMonitoredService.class);
    }

    public Response getResponseForService(String nodeCriteria, String ipAddress, String service) {
        WebTarget target = this.getTarget().path("nodes").path(nodeCriteria).path("ipinterfaces").path(ipAddress).path("services").path(service);
        return this.getBuilder(target).get();
    }

    public Response deleteNode(String nodeCriteria) {
        WebTarget target = this.getTarget().path("nodes").path(nodeCriteria);
        return this.getBuilder(target).delete();
    }

    public Response deleteService(String nodeCriteria, String ipAddress, String service) {
        WebTarget target = this.getTarget().path("nodes").path(nodeCriteria).path("ipinterfaces").path(ipAddress).path("services").path(service);
        return this.getBuilder(target).delete();
    }

    public OnmsIpInterface getInterface(String nodeCriteria, String ipAddress) {
        WebTarget target = this.getTarget().path("nodes").path(nodeCriteria).path("ipinterfaces").path(ipAddress);
        return (OnmsIpInterface)this.getBuilder(target).get(OnmsIpInterface.class);
    }

    public Response getResponseForInterface(String nodeCriteria, String ipAddress) {
        WebTarget target = this.getTarget().path("nodes").path(nodeCriteria).path("ipinterfaces").path(ipAddress);
        return this.getBuilder(target).get();
    }

    public OnmsEventCollection getEventsForNode(int nodeId) {
        WebTarget target = this.getTarget().path("events").queryParam("node.id", new Object[]{nodeId});
        return (OnmsEventCollection)this.getBuilder(target).accept(new String[]{"application/xml"}).get(OnmsEventCollection.class);
    }

    public OnmsEventCollection getEventsForNodeByEventUei(int nodeId, String eventUei) {
        WebTarget target = this.getTarget().path("events").queryParam("node.id", new Object[]{nodeId}).queryParam("eventUei", new Object[]{eventUei});
        return (OnmsEventCollection)this.getBuilder(target).accept(new String[]{"application/xml"}).get(OnmsEventCollection.class);
    }

    public OnmsAlarmCollection getAlarmsByEventUei(String eventUei) {
        WebTarget target = this.getTarget().path("alarms").queryParam("uei", new Object[]{eventUei});
        return (OnmsAlarmCollection)this.getBuilder(target).accept(new String[]{"application/xml"}).get(OnmsAlarmCollection.class);
    }

    public OnmsAlarmCollection getAlarmsForNode(int nodeId) {
        WebTarget target = this.getTarget().path("alarms").queryParam("node.id", new Object[]{nodeId});
        return (OnmsAlarmCollection)this.getBuilder(target).accept(new String[]{"application/xml"}).get(OnmsAlarmCollection.class);
    }

    public OnmsMinion getMinion(String id) {
        WebTarget target = this.getTarget().path("minions").path(id);
        return (OnmsMinion)this.getBuilder(target).accept(new String[]{"application/xml"}).get(OnmsMinion.class);
    }

    public List<OnmsMinion> getAllMinions() {
        GenericType<List<OnmsMinion>> minions = new GenericType<List<OnmsMinion>>(){};
        WebTarget target = this.getTargetV2().path("minions");
        return (List)this.getBuilder(target).accept(new String[]{"application/xml"}).get((GenericType)minions);
    }

    public Response addMinion(OnmsMinion minion) {
        WebTarget target = this.getTargetV2().path("minions");
        return this.getBuilder(target).post(Entity.entity((Object)minion, (String)"application/xml"));
    }

    public Response deleteMinion(String id) {
        WebTarget target = this.getTargetV2().path("minions").path(id);
        return this.getBuilder(target).delete();
    }

    public void sendEvent(Event event) {
        this.sendEvent(event, true);
    }

    public void sendEvent(Event event, boolean clearDates) {
        if (clearDates) {
            event.setCreationTime(null);
            event.setTime(null);
        }
        WebTarget target = this.getTarget().path("events");
        Response response = this.getBuilder(target).post(Entity.entity((Object)event, (String)"application/xml"));
        this.bailOnFailure(response);
    }

    public List<OnmsEvent> getEvents() {
        GenericType<List<OnmsEvent>> events = new GenericType<List<OnmsEvent>>(){};
        WebTarget target = this.getTarget().path("events");
        return (List)this.getBuilder(target).get((GenericType)events);
    }

    public List<OnmsEvent> getAllEvents() {
        GenericType<List<OnmsEvent>> events = new GenericType<List<OnmsEvent>>(){};
        WebTarget target = this.getTarget().path("events").queryParam("limit", new Object[]{0});
        return (List)this.getBuilder(target).get((GenericType)events);
    }

    public Long getFlowCount(long start, long end) {
        WebTarget target = this.getTarget().path("flows").path("count").queryParam("start", new Object[]{start}).queryParam("end", new Object[]{end});
        return (Long)this.getBuilder(target).get(Long.class);
    }

    public ResourceDTO getResourcesForNode(String nodeCriteria) {
        WebTarget target = this.getTarget().path("resources").path("fornode").path(nodeCriteria);
        return (ResourceDTO)this.getBuilder(target).get(ResourceDTO.class);
    }

    public void resetGeocoderConfiguration() {
        WebTarget target = this.getTargetV2().path("geocoding").path("config");
        Response response = this.getBuilder(target).delete();
        if (!Response.Status.Family.SUCCESSFUL.equals((Object)response.getStatusInfo().getFamily())) {
            throw new RuntimeException(String.format("Request failed with: %s:\n%s", response.getStatusInfo().getReasonPhrase(), response.hasEntity() ? response.readEntity(String.class) : ""));
        }
    }

    public void addCategory(String categoryName) {
        OnmsCategory category = new OnmsCategory(categoryName);
        WebTarget target = this.getTarget().path("categories");
        Response response = this.getBuilder(target).post(Entity.entity((Object)category, (String)"application/xml"));
        if (!Response.Status.Family.SUCCESSFUL.equals((Object)response.getStatusInfo().getFamily())) {
            throw new RuntimeException(String.format("Request failed with: %s:\n%s", response.getStatusInfo().getReasonPhrase(), response.hasEntity() ? response.readEntity(String.class) : ""));
        }
    }

    public void addCategoryToNode(String nodeCriteria, String categoryName) {
        WebTarget target = this.getTarget().path("categories").path(categoryName).path("nodes").path(nodeCriteria);
        Response response = this.getBuilder(target).put(null);
        if (!Response.Status.Family.SUCCESSFUL.equals((Object)response.getStatusInfo().getFamily())) {
            throw new RuntimeException(String.format("Request failed with: %s:\n%s", response.getStatusInfo().getReasonPhrase(), response.hasEntity() ? response.readEntity(String.class) : ""));
        }
    }

    private WebTarget getTarget() {
        Client client = ClientBuilder.newClient();
        client.property("jersey.config.client.suppressHttpComplianceValidation", (Object)true);
        return client.target(this.url.toString()).path("rest");
    }

    private WebTarget getTargetV2() {
        Client client = ClientBuilder.newClient();
        return client.target(this.url.toString()).path("api").path("v2");
    }

    private Invocation.Builder getBuilder(WebTarget target) {
        return target.request().header("Authorization", (Object)this.authorizationHeader);
    }

    public void sendGraphML(String graphName, InputStream graphMLStream) {
        Objects.requireNonNull(graphName);
        Objects.requireNonNull(graphMLStream);
        WebTarget target = this.getTarget().path("graphml").path(graphName);
        Response response = this.getBuilder(target).accept(new String[]{"application/xml"}).post(Entity.entity((Object)graphMLStream, (String)"application/xml"));
        this.bailOnFailure(response);
    }

    public Response getGraphML(String graphName) {
        Objects.requireNonNull(graphName);
        WebTarget target = this.getTarget().path("graphml").path(graphName);
        Response response = this.getBuilder(target).accept(new String[]{"application/xml"}).get();
        return response;
    }

    public void deleteGraphML(String graphName) {
        Objects.requireNonNull(graphName);
        WebTarget target = this.getTarget().path("graphml").path(graphName);
        Response response = this.getBuilder(target).delete();
        this.bailOnFailure(response);
    }

    private void bailOnFailure(Response response) {
        if (!Response.Status.Family.SUCCESSFUL.equals((Object)response.getStatusInfo().getFamily())) {
            throw new RuntimeException(String.format("Request failed with: %s:\n%s", response.getStatusInfo().getReasonPhrase(), response.hasEntity() ? response.readEntity(String.class) : ""));
        }
    }

    public List<OnmsApplication> getApplications() {
        GenericType<List<OnmsApplication>> applications = new GenericType<List<OnmsApplication>>(){};
        WebTarget target = this.getTargetV2().path("applications");
        return (List)this.getBuilder(target).accept(new String[]{"application/xml"}).get((GenericType)applications);
    }

    public void triggerBackup(String requestDTO) {
        WebTarget target = this.getTarget().path("device-config").path("backup");
        Response response = this.getBuilder(target).post(Entity.entity((Object)requestDTO, (String)"application/json"));
        System.err.println(response);
        this.bailOnFailure(response);
    }

    public JsonNode getBackups() throws IOException {
        String result = (String)this.getBuilder(this.getTarget().path("device-config")).accept(new String[]{"application/json"}).get(String.class);
        if (result == null) {
            return null;
        }
        return new ObjectMapper().readTree(result);
    }
}

