/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.smoketest.utils;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.google.common.collect.Maps;
import com.google.common.io.ByteSink;
import com.google.common.io.CharSink;
import com.google.common.io.FileWriteMode;
import com.hubspot.jinjava.Jinjava;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Stream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.opennms.smoketest.stacks.OverlayFile;
import org.opennms.smoketest.stacks.StackModel;
import org.testcontainers.utility.MountableFile;

public class OverlayUtils {
    public static final ObjectMapper jsonMapper = new ObjectMapper();
    private static final ObjectMapper yamlMapper = new ObjectMapper((JsonFactory)new YAMLFactory());

    public static void copyFiles(List<OverlayFile> files, Path overlayRoot) {
        try {
            for (OverlayFile file : files) {
                Path target = overlayRoot.resolve(file.getTarget());
                File targetFile = target.toFile();
                Files.createDirectories(target.getParent(), new FileAttribute[0]);
                URL sourceUrl = file.getSource();
                File sourceFile = OverlayUtils.toFile(sourceUrl);
                if (sourceFile != null) {
                    if (sourceFile.isDirectory()) {
                        Files.createDirectories(target, new FileAttribute[0]);
                        FileUtils.copyDirectory((File)sourceFile, (File)targetFile);
                    } else {
                        FileUtils.copyFile((File)sourceFile, (File)targetFile);
                    }
                } else {
                    ByteSink sink = com.google.common.io.Files.asByteSink((File)targetFile, (FileWriteMode[])new FileWriteMode[0]);
                    try (InputStream is = sourceUrl.openStream();){
                        sink.writeFrom(is);
                    }
                }
                if (file.getPermissions().isEmpty()) continue;
                Files.setPosixFilePermissions(target, file.getPermissions());
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static File toFile(URL url) {
        try {
            return Paths.get(url.toURI()).toFile();
        }
        catch (URISyntaxException | FileSystemNotFoundException e) {
            return null;
        }
    }

    public static void copyAndTemplate(String classpathResource, Path target, StackModel model) {
        Jinjava jinjava = new Jinjava();
        HashMap context = Maps.newHashMap();
        context.put("model", model);
        try {
            FileUtils.copyDirectory((File)new File(MountableFile.forClasspathResource((String)classpathResource).getFilesystemPath()), (File)target.toFile());
            try (Stream<Path> walk = Files.walk(target, new FileVisitOption[0]);){
                walk.map(Path::toString).filter(f -> FilenameUtils.isExtension((String)f, (String)"j2")).forEach(template -> {
                    try {
                        String templateSource = com.google.common.io.Files.asCharSource((File)new File((String)template), (Charset)StandardCharsets.UTF_8).read();
                        String renderedTemplate = jinjava.render(templateSource, context);
                        String targetFile = FilenameUtils.removeExtension((String)template);
                        com.google.common.io.Files.asCharSink((File)new File(targetFile), (Charset)StandardCharsets.UTF_8, (FileWriteMode[])new FileWriteMode[0]).write((CharSequence)renderedTemplate);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                });
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void writeProps(Path dest, Map<String, String> propMap) {
        Properties props = new Properties();
        props.putAll(propMap);
        try (FileOutputStream fos = new FileOutputStream(dest.toFile());){
            props.store(fos, "Generated");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void writeFeaturesBoot(Path dest, List<String> features) {
        try {
            CharSink sink = com.google.common.io.Files.asCharSink((File)dest.toFile(), (Charset)StandardCharsets.UTF_8, (FileWriteMode[])new FileWriteMode[0]);
            sink.writeLines(features);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void setOverlayPermissions(Path overlay) throws IOException {
        HashSet<PosixFilePermission> perms = new HashSet<PosixFilePermission>();
        perms.add(PosixFilePermission.OWNER_READ);
        perms.add(PosixFilePermission.OWNER_WRITE);
        perms.add(PosixFilePermission.OWNER_EXECUTE);
        perms.add(PosixFilePermission.GROUP_READ);
        perms.add(PosixFilePermission.GROUP_WRITE);
        perms.add(PosixFilePermission.GROUP_EXECUTE);
        perms.add(PosixFilePermission.OTHERS_READ);
        perms.add(PosixFilePermission.OTHERS_EXECUTE);
        Files.setPosixFilePermissions(overlay, perms);
    }

    public static void setTempPermissions(Path temp) throws IOException {
        HashSet<PosixFilePermission> perms = new HashSet<PosixFilePermission>();
        perms.add(PosixFilePermission.OWNER_READ);
        perms.add(PosixFilePermission.OWNER_WRITE);
        perms.add(PosixFilePermission.OWNER_EXECUTE);
        perms.add(PosixFilePermission.GROUP_READ);
        perms.add(PosixFilePermission.GROUP_WRITE);
        perms.add(PosixFilePermission.GROUP_EXECUTE);
        perms.add(PosixFilePermission.OTHERS_READ);
        perms.add(PosixFilePermission.OTHERS_EXECUTE);
        perms.add(PosixFilePermission.OWNER_WRITE);
        Files.setPosixFilePermissions(temp, perms);
    }

    public static void writeYaml(Path path, Map<String, Object> values) throws IOException {
        File file = path.toFile();
        Map yamlMap = (Map)yamlMapper.readValue(file, Map.class);
        OverlayUtils.mergeMaps(yamlMap, values);
        yamlMapper.writeValue(file, (Object)yamlMap);
    }

    static void mergeMaps(Map<String, Object> originalMap, Map<String, Object> newMap) {
        newMap.forEach((key, value) -> {
            if (value instanceof Map) {
                Object subMap = originalMap.get(key);
                if (subMap == null) {
                    originalMap.put((String)key, value);
                } else {
                    OverlayUtils.mergeMaps((Map)subMap, (Map)value);
                }
            } else {
                originalMap.put((String)key, value);
            }
        });
    }
}

