/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.smoketest.ui.framework.search.result;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.opennms.smoketest.ui.framework.Element;
import org.opennms.smoketest.ui.framework.search.result.ContextSearchResult;
import org.opennms.smoketest.ui.framework.search.result.ItemType;
import org.opennms.smoketest.ui.framework.search.result.SearchResultItem;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;

public class SearchResult
extends Element {
    private String input;

    public SearchResult(WebDriver driver, String input) {
        super(driver);
        this.input = Objects.requireNonNull(input);
    }

    public List<SearchResultItem> getItems() {
        List elements = this.getDriver().findElements(By.xpath((String)"//div[@id='onms-search-result']//*[contains(@class, 'list-group-item')]"));
        List<SearchResultItem> items = elements.stream().map(element -> {
            if (element.getTagName().equalsIgnoreCase("div")) {
                return new SearchResultItem(this.getDriver(), ItemType.Header, element.getAttribute("id"), element.getText());
            }
            if (element.getTagName().equalsIgnoreCase("a")) {
                if (element.getText().contains("more...")) {
                    return new SearchResultItem(this.getDriver(), ItemType.More, element.getAttribute("id"), element.getText());
                }
                return new SearchResultItem(this.getDriver(), ItemType.Item, element.getAttribute("id"), element.getText());
            }
            throw new IllegalStateException("Could not determine item type. Bailing");
        }).collect(Collectors.toList());
        return items;
    }

    public SearchResultItem getSingleItem() {
        return this.getItems().stream().filter(i -> i.getType() == ItemType.Item).findFirst().orElseThrow(() -> new RuntimeException("Not a single item found"));
    }

    public ContextSearchResult forContext(String context) {
        return new ContextSearchResult(this.getDriver(), this.input, context);
    }

    public long size() {
        return this.getItems().stream().filter(item -> item.getType() == ItemType.Item).count();
    }
}

