/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.smoketest.stacks;

import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import org.opennms.smoketest.stacks.BlobStoreStrategy;
import org.opennms.smoketest.stacks.IpcStrategy;
import org.opennms.smoketest.stacks.JsonStoreStrategy;
import org.opennms.smoketest.stacks.KafkaCompressionStrategy;
import org.opennms.smoketest.stacks.MinionProfile;
import org.opennms.smoketest.stacks.OpenNMSProfile;
import org.opennms.smoketest.stacks.SentinelProfile;
import org.opennms.smoketest.stacks.TimeSeriesStrategy;

public class StackModel {
    private final OpenNMSProfile opennms;
    private final List<MinionProfile> minions;
    private final List<SentinelProfile> sentinels;
    private final boolean jaegerEnabled;
    private final boolean elasticsearchEnabled;
    private final boolean telemetryProcessingEnabled;
    private final boolean simulateRestricedOpenShiftEnvironment;
    private final IpcStrategy ipcStrategy;
    private final TimeSeriesStrategy timeSeriesStrategy;
    private final BlobStoreStrategy blobStoreStrategy;
    private final JsonStoreStrategy jsonStoreStrategy;
    private final KafkaCompressionStrategy kafkaCompressionStrategy;

    private StackModel(Builder builder) {
        this.opennms = builder.opennms;
        this.minions = builder.minions;
        this.sentinels = builder.sentinels;
        this.jaegerEnabled = builder.jaegerEnabled;
        this.elasticsearchEnabled = builder.elasticsearchEnabled;
        this.telemetryProcessingEnabled = builder.telemetryProcessingEnabled;
        this.simulateRestricedOpenShiftEnvironment = builder.simulateRestricedOpenShiftEnvironment;
        this.ipcStrategy = builder.ipcStrategy;
        this.timeSeriesStrategy = builder.timeSeriesStrategy;
        this.blobStoreStrategy = builder.blobStoreStrategy;
        this.jsonStoreStrategy = builder.jsonStoreStrategy;
        this.kafkaCompressionStrategy = builder.kafkaCompressionStrategy;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public OpenNMSProfile getOpenNMS() {
        return this.opennms;
    }

    public List<MinionProfile> getMinions() {
        return this.minions;
    }

    public List<SentinelProfile> getSentinels() {
        return this.sentinels;
    }

    public boolean isJaegerEnabled() {
        return this.jaegerEnabled;
    }

    public boolean isElasticsearchEnabled() {
        return this.elasticsearchEnabled;
    }

    public boolean isTelemetryProcessingEnabled() {
        return this.telemetryProcessingEnabled;
    }

    public boolean isSimulateRestricedOpenShiftEnvironment() {
        return this.simulateRestricedOpenShiftEnvironment;
    }

    public IpcStrategy getIpcStrategy() {
        return this.ipcStrategy;
    }

    public TimeSeriesStrategy getTimeSeriesStrategy() {
        return this.timeSeriesStrategy;
    }

    public BlobStoreStrategy getBlobStoreStrategy() {
        return this.blobStoreStrategy;
    }

    public JsonStoreStrategy getJsonStoreStrategy() {
        return this.jsonStoreStrategy;
    }

    public KafkaCompressionStrategy getKafkaCompressionStrategy() {
        return this.kafkaCompressionStrategy;
    }

    public static final class Builder {
        private OpenNMSProfile opennms = OpenNMSProfile.DEFAULT;
        private List<MinionProfile> minions = new LinkedList<MinionProfile>();
        private List<SentinelProfile> sentinels = new LinkedList<SentinelProfile>();
        public boolean jaegerEnabled = false;
        private boolean elasticsearchEnabled = false;
        private boolean telemetryProcessingEnabled = false;
        private boolean simulateRestricedOpenShiftEnvironment = false;
        private IpcStrategy ipcStrategy = IpcStrategy.JMS;
        private TimeSeriesStrategy timeSeriesStrategy = TimeSeriesStrategy.RRD;
        private BlobStoreStrategy blobStoreStrategy = BlobStoreStrategy.NOOP;
        private JsonStoreStrategy jsonStoreStrategy;
        private KafkaCompressionStrategy kafkaCompressionStrategy = KafkaCompressionStrategy.NONE;

        public Builder withOpenNMS(OpenNMSProfile opennms) {
            this.opennms = Objects.requireNonNull(opennms);
            return this;
        }

        public Builder withMinion() {
            this.minions = Collections.singletonList(MinionProfile.DEFAULT);
            return this;
        }

        public Builder withMinions(MinionProfile ... minions) {
            this.minions = Arrays.asList(minions);
            return this;
        }

        public Builder withSentinel() {
            this.sentinels = Collections.singletonList(SentinelProfile.DEFAULT);
            return this;
        }

        public Builder withSentinels(SentinelProfile ... sentinels) {
            this.sentinels = Arrays.asList(sentinels);
            return this;
        }

        public Builder withJaeger() {
            this.jaegerEnabled = true;
            return this;
        }

        public Builder withElasticsearch() {
            this.elasticsearchEnabled = true;
            return this;
        }

        public Builder withIpcStrategy(IpcStrategy ipcStrategy) {
            this.ipcStrategy = Objects.requireNonNull(ipcStrategy);
            return this;
        }

        public Builder withTimeSeriesStrategy(TimeSeriesStrategy timeSeriesStrategy) {
            this.timeSeriesStrategy = Objects.requireNonNull(timeSeriesStrategy);
            return this;
        }

        public Builder withKafkaCompressionStrategy(KafkaCompressionStrategy kafkaCompressionStrategy) {
            this.kafkaCompressionStrategy = Objects.requireNonNull(kafkaCompressionStrategy);
            return this;
        }

        public Builder withTelemetryProcessing() {
            this.telemetryProcessingEnabled = true;
            return this;
        }

        public Builder withSimulateRestricedOpenShiftEnvironment() {
            this.simulateRestricedOpenShiftEnvironment = true;
            return this;
        }

        public Builder withBlobStoreStrategy(BlobStoreStrategy blobStoreStrategy) {
            this.blobStoreStrategy = blobStoreStrategy;
            return this;
        }

        public Builder withJsonStoreStrategy(JsonStoreStrategy jsonStoreStrategy) {
            this.jsonStoreStrategy = jsonStoreStrategy;
            return this;
        }

        public StackModel build() {
            if (this.telemetryProcessingEnabled) {
                this.elasticsearchEnabled = true;
                if (!this.sentinels.isEmpty()) {
                    this.timeSeriesStrategy = TimeSeriesStrategy.NEWTS;
                }
            }
            return new StackModel(this);
        }
    }
}

