/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.smoketest.containers;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.net.InetSocketAddress;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.opennms.netmgt.dao.hibernate.AbstractDaoHibernate;
import org.opennms.smoketest.utils.DevDebugUtils;
import org.opennms.smoketest.utils.HibernateDaoFactory;
import org.opennms.smoketest.utils.TestContainerUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.Container;
import org.testcontainers.containers.Network;
import org.testcontainers.lifecycle.TestDescription;
import org.testcontainers.lifecycle.TestLifecycleAware;

public class PostgreSQLContainer
extends org.testcontainers.containers.PostgreSQLContainer<PostgreSQLContainer>
implements TestLifecycleAware {
    private static final Logger LOG = LoggerFactory.getLogger(PostgreSQLContainer.class);
    private LoadingCache<Integer, HibernateDaoFactory> daoFactoryCache = CacheBuilder.newBuilder().expireAfterWrite(10L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<Integer, HibernateDaoFactory>(){

        public HibernateDaoFactory load(Integer mappedPort) {
            InetSocketAddress pgsql = new InetSocketAddress(PostgreSQLContainer.this.getContainerIpAddress(), (int)mappedPort);
            return new HibernateDaoFactory(pgsql);
        }
    });
    private HibernateDaoFactory daoFactory;

    public PostgreSQLContainer() {
        super("postgres:10.7-alpine");
        ((PostgreSQLContainer)((PostgreSQLContainer)this.withNetwork(Network.SHARED)).withNetworkAliases(new String[]{"db"})).withCreateContainerCmdModifier(TestContainerUtils::setGlobalMemAndCpuLimits);
    }

    protected void configure() {
        super.configure();
        this.setCommand(new String[]{"postgres", "-c", "fsync=off", "-c", "shared_buffers=256MB", "-c", "max_connections=200"});
    }

    public HibernateDaoFactory getDaoFactory() {
        try {
            return (HibernateDaoFactory)this.daoFactoryCache.get((Object)this.getMappedPort(POSTGRESQL_PORT));
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    public <T extends AbstractDaoHibernate<?, ?>> T dao(Class<T> clazz) {
        return this.getDaoFactory().getDao(clazz);
    }

    public void afterTest(TestDescription description, Optional<Throwable> throwable) {
        this.daoFactoryCache.invalidateAll();
        this.retainLogsfNeeded(description.getFilesystemFriendlyName(), !throwable.isPresent());
    }

    private void retainLogsfNeeded(String prefix, boolean succeeded) {
        if (!succeeded) {
            LOG.info("Gathering logs...");
            Path targetLogFolder = Paths.get("target", "logs", prefix, "postgresql");
            DevDebugUtils.clearLogs(targetLogFolder);
            DevDebugUtils.copyLogs((Container)this, targetLogFolder, Paths.get("/var", "lib", "postgresql", "data"), Collections.emptyList());
        }
    }
}

