/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.smoketest.utils;

import org.junit.Assert;
import org.testcontainers.utility.DockerImageName;
import org.testcontainers.utility.ImageNameSubstitutor;

public class OpenNMSImageNameSubstitutor
extends ImageNameSubstitutor {
    public DockerImageName apply(DockerImageName original) {
        if (original.getUnversionedPart().startsWith("selenium/standalone-firefox") && original.getVersionPart().startsWith("4.")) {
            return DockerImageName.parse((String)("seleniarm/standalone-firefox:" + this.getSeleniarmVersion()));
        }
        if (original.getUnversionedPart().startsWith("selenium/standalone-chrome") && original.getVersionPart().startsWith("4.")) {
            return DockerImageName.parse((String)("seleniarm/standalone-chromium:" + this.getSeleniarmVersion()));
        }
        return original;
    }

    private String getSeleniarmVersion() {
        String version = System.getProperty("seleniarm.version");
        Assert.assertNotNull((String)"The system property 'seleniarm.version' needs to be set to do browser testing. Make sure it is set in pom.xml.", (Object)version);
        return version;
    }

    protected String getDescription() {
        return "OpenNMS image name substitutor";
    }
}

