/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.smoketest.ui.framework;

import java.time.Duration;
import org.junit.Assert;
import org.opennms.smoketest.ui.framework.UiElement;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.ui.ExpectedConditions;
import org.openqa.selenium.support.ui.FluentWait;

public class CheckBox
extends UiElement {
    public CheckBox(WebDriver driver, String elementId) {
        super(driver, elementId);
    }

    public void setSelected(boolean selected) {
        this.LOG.debug("Update setSelected {} of element with id: {}", (Object)selected, (Object)this.elementId);
        FluentWait wait = new FluentWait((Object)this.driver).withTimeout(Duration.ofSeconds(30L)).pollingEvery(Duration.ofSeconds(1L)).ignoring(Exception.class);
        if (selected != this.isSelected()) {
            wait.until(driver -> ExpectedConditions.elementToBeClickable((WebElement)this.getElement()));
            this.getElement().click();
            wait.until(driver -> selected == this.isSelected());
        }
        this.LOG.debug("Expecting {} for isSelected. Actual value is {}. Element id: {}", new Object[]{selected, this.isSelected(), this.elementId});
        Assert.assertEquals((String)String.format("Expected checkbox to be selected=%s", selected), (Object)selected, (Object)this.isSelected());
    }

    public boolean isSelected() {
        return this.getElement().isSelected();
    }
}

