/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.smoketest.stacks;

import com.google.common.io.Resources;
import java.net.MalformedURLException;
import java.nio.file.Path;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Function;
import org.opennms.smoketest.containers.MinionContainer;
import org.opennms.smoketest.stacks.OverlayFile;
import org.testcontainers.containers.wait.strategy.WaitStrategy;

public class MinionProfile {
    public static MinionProfile DEFAULT = MinionProfile.newBuilder().build();
    public static final String DEFAULT_LOCATION = "MINION";
    private final String location;
    private final String id;
    private final boolean jvmDebuggingEnabled;
    private final boolean icmpSupportEnabled;
    private final List<OverlayFile> files;
    private final String dominionGrpcScvClientSecret;
    private final Function<MinionContainer, WaitStrategy> waitStrategy;
    private final Map<String, String> legacyConfiguration;

    private MinionProfile(Builder builder) {
        this.location = builder.location;
        this.id = builder.id;
        this.jvmDebuggingEnabled = builder.jvmDebuggingEnabled;
        this.icmpSupportEnabled = builder.icmpSupportEnabled;
        this.files = Collections.unmodifiableList(builder.files);
        this.dominionGrpcScvClientSecret = builder.dominionGrpcScvClientSecret;
        this.waitStrategy = Objects.requireNonNull(builder.waitStrategy);
        this.legacyConfiguration = builder.legacyConfiguration;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String getLocation() {
        return this.location;
    }

    public String getId() {
        return this.id;
    }

    public boolean isJvmDebuggingEnabled() {
        return this.jvmDebuggingEnabled;
    }

    public boolean isIcmpSupportEnabled() {
        return this.icmpSupportEnabled;
    }

    public List<OverlayFile> getFiles() {
        return this.files;
    }

    public String getDominionGrpcScvClientSecret() {
        return this.dominionGrpcScvClientSecret;
    }

    public Function<MinionContainer, WaitStrategy> getWaitStrategy() {
        return this.waitStrategy;
    }

    public boolean isLegacy() {
        return this.legacyConfiguration != null;
    }

    public Map<String, String> getLegacyConfiguration() {
        return this.legacyConfiguration;
    }

    public static final class Builder {
        private String location = "MINION";
        private String id = UUID.randomUUID().toString();
        private boolean jvmDebuggingEnabled = false;
        private boolean icmpSupportEnabled = false;
        private List<OverlayFile> files = new LinkedList<OverlayFile>();
        private String dominionGrpcScvClientSecret;
        private Function<MinionContainer, WaitStrategy> waitStrategy = MinionContainer.WaitForMinion::new;
        private Map<String, String> legacyConfiguration = null;

        public Builder withLocation(String location) {
            this.location = Objects.requireNonNull(location);
            return this;
        }

        public Builder withId(String id) {
            this.id = Objects.requireNonNull(id);
            return this;
        }

        public Builder withJvmDebuggingEnabled(boolean enabled) {
            this.jvmDebuggingEnabled = enabled;
            return this;
        }

        public Builder withIcmpSupportEnabled(boolean enabled) {
            this.icmpSupportEnabled = enabled;
            return this;
        }

        public Builder withFile(Path source, String target) {
            try {
                this.files.add(new OverlayFile(source.toUri().toURL(), target));
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
            return this;
        }

        public Builder withFile(String resourceName, String target) {
            this.files.add(new OverlayFile(Resources.getResource((String)resourceName), target));
            return this;
        }

        public Builder withDominionGrpcScvClientSecret(String dominionGrpcScvClientSecret) {
            this.dominionGrpcScvClientSecret = dominionGrpcScvClientSecret;
            return this;
        }

        public Builder withWaitStrategy(Function<MinionContainer, WaitStrategy> waitStrategy) {
            this.waitStrategy = waitStrategy;
            return this;
        }

        public Builder withLegacyConfiguration(Map<String, String> configuration) {
            this.legacyConfiguration = Collections.unmodifiableMap(configuration);
            return this;
        }

        public MinionProfile build() {
            return new MinionProfile(this);
        }
    }
}

