/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.smoketest.utils;

import com.github.dockerjava.api.exception.NotFoundException;
import com.google.common.base.Strings;
import com.google.common.util.concurrent.SimpleTimeLimiter;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.common.util.concurrent.TimeLimiter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import java.util.List;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.awaitility.Awaitility;
import org.hamcrest.Matchers;
import org.opennms.smoketest.utils.TestContainerUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.FileSystemUtils;
import org.testcontainers.containers.BindMode;
import org.testcontainers.containers.Container;
import org.testcontainers.containers.SelinuxContext;

public class DevDebugUtils {
    private static final Logger LOG = LoggerFactory.getLogger(DevDebugUtils.class);
    public static final String M2_DEV_SYS_PROP = "org.opennms.dev.m2";
    public static final String CONTAINER_HOST_M2_SYS_PROP = "org.opennms.dev.container.host";
    private static final TimeLimiter LIMITER = SimpleTimeLimiter.create((ExecutorService)Executors.newCachedThreadPool(new ThreadFactoryBuilder().setNameFormat("dev-debug-utils-pool-%d").build()));
    public static final String CONTAINER_STDOUT_STDERR = "container_stdout_stderr";

    public static String convertToContainerAccessibleUrl(String url, String defaultAlias, int defaultPort) {
        try {
            URI uri = new URI(url);
            String containerHost = System.getProperty(CONTAINER_HOST_M2_SYS_PROP);
            URI effectiveUri = Strings.isNullOrEmpty((String)containerHost) ? new URI(uri.getScheme(), defaultAlias + ":" + defaultPort, uri.getPath(), uri.getQuery(), uri.getFragment()) : new URI(uri.getScheme(), containerHost + ":" + uri.getPort(), uri.getPath(), uri.getQuery(), uri.getFragment());
            return effectiveUri.toString();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public static void setupMavenRepoBind(Container container, String containerPath) {
        String m2dev = System.getProperty(M2_DEV_SYS_PROP);
        if (!Strings.isNullOrEmpty((String)m2dev)) {
            container.addFileSystemBind(m2dev, containerPath, BindMode.READ_WRITE, SelinuxContext.SINGLE);
        }
    }

    public static void clearLogs(Path targetLogFolder) {
        if (Files.exists(targetLogFolder, new LinkOption[0])) {
            FileSystemUtils.deleteRecursively((File)targetLogFolder.toFile());
        }
    }

    public static Path gatherThreadDump(Container container, Path targetLogFolder, Path outputLog) {
        LOG.info("Gathering thread dump...");
        if (!container.isRunning()) {
            LOG.warn("gatherThreadDump can only be used on a running container. Container [{}] is not running", (Object)container.getDockerImageName());
            return null;
        }
        LOG.debug("send SIGQUIT to process in container");
        try {
            LIMITER.callWithTimeout(() -> {
                container.execInContainer(new String[]{"kill", "-3", "1"});
                return null;
            }, 1L, TimeUnit.MINUTES);
        }
        catch (Exception e) {
            LOG.warn("Sending SIGQUIT to JVM in container failed. Thread dump may not be available.", (Throwable)e);
        }
        LOG.debug("kill sent");
        Callable<String> threadDumpCallable = outputLog != null ? () -> TestContainerUtils.getFileFromContainerAsString(container, outputLog) : () -> ((Container)container).getLogs();
        LOG.debug("waiting for thread dump to complete ...");
        try {
            Awaitility.await((String)"waiting for thread dump to complete").atMost(Duration.ofSeconds(5L)).failFast("container is no longer running", () -> !container.isRunning()).ignoreException(NotFoundException.class).until(threadDumpCallable, Matchers.containsString((String)"JNI global refs"));
        }
        catch (Exception e) {
            LOG.warn("Did not see thread dump in container {} within timeout", outputLog != null ? outputLog : "console logs", (Object)e);
        }
        LOG.debug("thread dump complete");
        if (targetLogFolder == null) {
            return null;
        }
        try {
            Files.createDirectories(targetLogFolder, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to create " + targetLogFolder, e);
        }
        LOG.debug("grabbing thread dump");
        Path targetFile = targetLogFolder.resolve("threadDump.log");
        try {
            Pattern pattern = Pattern.compile("(?ms)((^[^\r\n]*$[\r\n]+)?^Full thread dump .*^Heap$.*?^$)");
            Matcher matcher = pattern.matcher(threadDumpCallable.call());
            if (!matcher.find()) {
                LOG.warn("Did not find thread dump");
                return null;
            }
            String threadDump = matcher.group(1);
            try (OutputStreamWriter fileWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(targetFile.toFile()), StandardCharsets.UTF_8);){
                fileWriter.write("# IntelliJ IDEA users: might I suggest Code | Analyze Stack Trace or Thread Dump.\n# See: https://www.jetbrains.com/help/idea/analyzing-external-stacktraces.html\n\n");
                fileWriter.write(threadDump);
            }
            LOG.debug("grabbed thread dump");
            return targetFile;
        }
        catch (Exception e) {
            LOG.warn("Could not retrieve or store thread dump in file {}", (Object)targetFile, (Object)e);
            return null;
        }
    }

    public static void copyLogs(Container container, Path targetLogFolder, Path sourceLogFolder, List<String> logFiles) {
        try {
            Files.createDirectories(targetLogFolder, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to create " + targetLogFolder, e);
        }
        Path containerLogOutputFile = targetLogFolder.resolve(CONTAINER_STDOUT_STDERR);
        try {
            LIMITER.runWithTimeout(() -> {
                try {
                    Files.write(containerLogOutputFile, container.getLogs().getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }, 1L, TimeUnit.MINUTES);
        }
        catch (TimeoutException e) {
            LOG.warn("Timeout when copying stdout/stderr from container to file {}.", (Object)containerLogOutputFile);
            return;
        }
        catch (Exception e) {
            LOG.info("Failed to copy stdout/stderr from container to file {}: {}", (Object)containerLogOutputFile, (Object)e.getMessage());
        }
        TreeSet<String> missingLogs = new TreeSet<String>();
        for (String logFile : logFiles) {
            try {
                LIMITER.runWithTimeout(() -> {
                    try {
                        container.copyFileFromContainer(sourceLogFolder.resolve(logFile).toString(), targetLogFolder.resolve(logFile).toString());
                    }
                    catch (IOException | InterruptedException e) {
                        throw new RuntimeException(e);
                    }
                }, 1L, TimeUnit.MINUTES);
            }
            catch (TimeoutException e) {
                LOG.warn("Timeout when copying log file {} from container: {}", (Object)logFile, (Object)e.getMessage());
                return;
            }
            catch (Exception e) {
                if (ExceptionUtils.getRootCause((Throwable)e).getClass() == NotFoundException.class) {
                    missingLogs.add(logFile);
                    continue;
                }
                LOG.warn("Failed to copy log file {} from container: {}", (Object)logFile, (Object)e.getMessage());
            }
        }
        if (!missingLogs.isEmpty()) {
            LOG.warn("Failed to copy log files from the container because container does not have files: {}", missingLogs);
        }
    }
}

