/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.smoketest.containers;

import com.google.common.base.Strings;
import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.SocketException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.FileUtils;
import org.awaitility.Awaitility;
import org.hamcrest.CoreMatchers;
import org.opennms.smoketest.containers.JaegerContainer;
import org.opennms.smoketest.containers.KarafContainer;
import org.opennms.smoketest.stacks.IpcStrategy;
import org.opennms.smoketest.stacks.MinionProfile;
import org.opennms.smoketest.stacks.NetworkProtocol;
import org.opennms.smoketest.stacks.StackModel;
import org.opennms.smoketest.utils.DevDebugUtils;
import org.opennms.smoketest.utils.OverlayUtils;
import org.opennms.smoketest.utils.RestHealthClient;
import org.opennms.smoketest.utils.SshClient;
import org.opennms.smoketest.utils.TestContainerUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.BindMode;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.Network;
import org.testcontainers.containers.SelinuxContext;
import org.testcontainers.containers.wait.strategy.AbstractWaitStrategy;
import org.testcontainers.lifecycle.TestDescription;
import org.testcontainers.lifecycle.TestLifecycleAware;
import org.testcontainers.utility.MountableFile;

public class MinionContainer
extends GenericContainer<MinionContainer>
implements KarafContainer<MinionContainer>,
TestLifecycleAware {
    private static final Logger LOG = LoggerFactory.getLogger(MinionContainer.class);
    private static final int MINION_DEBUG_PORT = 5005;
    private static final int MINION_SYSLOG_PORT = 1514;
    private static final int MINION_SSH_PORT = 8201;
    private static final int MINION_SNMP_TRAP_PORT = 1162;
    private static final int MINION_TELEMETRY_FLOW_PORT = 50000;
    private static final int MINION_TELEMETRY_IPFIX_TCP_PORT = 4730;
    private static final int MINION_TELEMETRY_JTI_PORT = 50001;
    private static final int MINION_TELEMETRY_NXOS_PORT = 50002;
    private static final int MINION_JETTY_PORT = 8181;
    static final String ALIAS = "minion";
    static final String IMAGE = "opennms/minion";
    private final StackModel model;
    private final String id;
    private final String location;
    private final MinionProfile profile;
    private final Path overlay;

    public MinionContainer(StackModel model, MinionProfile profile) {
        super(IMAGE);
        this.model = Objects.requireNonNull(model);
        this.profile = Objects.requireNonNull(profile);
        this.id = Objects.requireNonNull(profile.getId());
        this.location = Objects.requireNonNull(profile.getLocation());
        this.overlay = this.writeOverlay();
        Integer[] tcpPorts = new Integer[]{5005, 8201, 50000, 4730, 8181};
        int[] udpPorts = new int[]{1514, 1162, 50000, 50001, 50002};
        ((MinionContainer)((MinionContainer)((MinionContainer)((MinionContainer)((MinionContainer)((MinionContainer)((MinionContainer)((MinionContainer)((MinionContainer)((MinionContainer)((MinionContainer)((MinionContainer)this.withExposedPorts(tcpPorts)).withCreateContainerCmdModifier(createCmd -> {
            TestContainerUtils.setGlobalMemAndCpuLimits(createCmd);
            TestContainerUtils.exposePortsAsUdp(createCmd, udpPorts);
        })).withEnv("OPENNMS_HTTP_USER", "admin")).withEnv("OPENNMS_HTTP_PASS", "admin")).withEnv("OPENNMS_BROKER_USER", "admin")).withEnv("OPENNMS_BROKER_PASS", "admin")).withEnv("JACOCO_AGENT_ENABLED", "1")).withEnv("JAVA_OPTS", "-Xms1g -Xmx1g -Djava.security.egd=file:/dev/./urandom")).withNetwork(Network.SHARED)).withNetworkAliases(new String[]{ALIAS})).withCommand("-c")).waitingFor(Objects.requireNonNull(profile.getWaitStrategy()).apply(this))).addFileSystemBind(this.overlay.toString(), "/opt/minion-etc-overlay", BindMode.READ_ONLY, SelinuxContext.SINGLE);
        DevDebugUtils.setupMavenRepoBind(this, "/opt/minion/.m2");
        if (profile.isLegacy()) {
            for (Map.Entry<String, String> entry : profile.getLegacyConfiguration().entrySet()) {
                this.addEnv(entry.getKey(), entry.getValue());
            }
        } else {
            this.addFileSystemBind(this.writeMinionConfig(profile).toString(), "/opt/minion/minion-config.yaml", BindMode.READ_ONLY, SelinuxContext.SINGLE);
        }
        if (profile.isJvmDebuggingEnabled()) {
            this.withEnv("KARAF_DEBUG", "true");
            this.withEnv("JAVA_DEBUG_PORT", "*:5005");
        }
    }

    private Path writeMinionConfig(MinionProfile profile) {
        try {
            Path minionConfig = Files.createTempDirectory(ALIAS, new FileAttribute[0]).toAbsolutePath().resolve("minion-config.yaml");
            this.writeMinionConfigYaml(minionConfig, profile);
            return minionConfig;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void writeMinionConfigYaml(Path minionConfigYaml, MinionProfile profile) throws IOException {
        FileUtils.copyFile((File)new File(MountableFile.forClasspathResource((String)"minion-config/minion-config.yaml").getFilesystemPath()), (File)minionConfigYaml.toFile());
        OverlayUtils.setOverlayPermissions(minionConfigYaml);
        String config = "{\n\t\"location\": \"" + profile.getLocation() + "\",\n\t\"id\": \"" + profile.getId() + "\",\n\t\"broker-url\": \"failover:tcp://opennms:61616\"\n}";
        OverlayUtils.writeYaml(minionConfigYaml, (Map)OverlayUtils.jsonMapper.readValue(config, Map.class));
        if (!Strings.isNullOrEmpty((String)profile.getDominionGrpcScvClientSecret())) {
            String scvConfig = "{\"scv\": {\"provider\": \"dominion\"}}";
            OverlayUtils.writeYaml(minionConfigYaml, (Map)OverlayUtils.jsonMapper.readValue("{\"scv\": {\"provider\": \"dominion\"}}", Map.class));
            String gprcConfig = "{\"dominion\": { \"grpc\": { \"client-secret\":\"" + profile.getDominionGrpcScvClientSecret() + "\"}}}";
            OverlayUtils.writeYaml(minionConfigYaml, (Map)OverlayUtils.jsonMapper.readValue(gprcConfig, Map.class));
        }
        if (IpcStrategy.KAFKA.equals((Object)this.model.getIpcStrategy())) {
            String kafkaIpc = "{\n\t\"ipc\": {\n\t\t\"kafka\": {\n\t\t\t\"bootstrap.servers\": \"kafka:9092\",\n\t\t\t\"compression.type\": \"" + this.model.getKafkaCompressionStrategy().getCodec() + "\"\n\t\t}\n\t}\n}";
            OverlayUtils.writeYaml(minionConfigYaml, (Map)OverlayUtils.jsonMapper.readValue(kafkaIpc, Map.class));
        } else if (IpcStrategy.GRPC.equals((Object)this.model.getIpcStrategy())) {
            String grpc = "{\n\t\"ipc\": {\n\t\t\"grpc\": {\n\t\t\t\"host\": \"opennms\",\n\t\t\t\"port\": 8990\n\t\t}\n\t}\n}";
            OverlayUtils.writeYaml(minionConfigYaml, (Map)OverlayUtils.jsonMapper.readValue(grpc, Map.class));
        }
        if (this.model.isJaegerEnabled()) {
            String jaeger = "{\n\t\"system\": {\n\t\t\"properties\": {\n\t\t\t\"JAEGER_ENDPOINT\": \"" + JaegerContainer.getThriftHttpURL() + "\"\n\t\t}\n\t}\n}";
            OverlayUtils.writeYaml(minionConfigYaml, (Map)OverlayUtils.jsonMapper.readValue(jaeger, Map.class));
        }
    }

    private Path writeOverlay() {
        try {
            Path home = Files.createTempDirectory(ALIAS, new FileAttribute[0]).toAbsolutePath();
            this.writeOverlay(home, this.profile);
            return home;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void writeOverlay(Path home, MinionProfile profile) throws IOException {
        OverlayUtils.setOverlayPermissions(home);
        OverlayUtils.copyFiles(profile.getFiles(), home);
    }

    public InetSocketAddress getSyslogAddress() {
        return new InetSocketAddress(this.getContainerIpAddress(), TestContainerUtils.getMappedUdpPort(this, 1514));
    }

    @Override
    public InetSocketAddress getSshAddress() {
        return new InetSocketAddress(this.getContainerIpAddress(), (int)this.getMappedPort(8201));
    }

    @Override
    public SshClient ssh() {
        return new SshClient(this.getSshAddress(), "admin", "admin");
    }

    @Override
    public Path getKarafHomeDirectory() {
        return Path.of("/opt/minion", new String[0]);
    }

    public URL getWebUrl() {
        try {
            return new URL(String.format("http://%s:%d/", this.getContainerIpAddress(), this.getMappedPort(8181)));
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    public int getWebPort() {
        return 8181;
    }

    public String getLocation() {
        return this.location;
    }

    public InetSocketAddress getNetworkProtocolAddress(NetworkProtocol protocol) {
        int mappedPort = -1;
        switch (protocol) {
            case SNMP: {
                mappedPort = TestContainerUtils.getMappedUdpPort(this, 1162);
                break;
            }
            case FLOWS: {
                mappedPort = TestContainerUtils.getMappedUdpPort(this, 50000);
                break;
            }
            case JTI: {
                mappedPort = TestContainerUtils.getMappedUdpPort(this, 50001);
                break;
            }
            case NXOS: {
                mappedPort = TestContainerUtils.getMappedUdpPort(this, 50002);
                break;
            }
            case IPFIX_TCP: {
                mappedPort = this.getMappedPort(4730);
            }
        }
        return new InetSocketAddress(this.getContainerIpAddress(), mappedPort);
    }

    public void afterTest(TestDescription description, Optional<Throwable> throwable) {
        this.retainLogsfNeeded(description.getFilesystemFriendlyName(), !throwable.isPresent());
    }

    private void retainLogsfNeeded(String prefix, boolean succeeded) {
        Path targetLogFolder = Paths.get("target", "logs", prefix, ALIAS);
        DevDebugUtils.clearLogs(targetLogFolder);
        Path threadDump = DevDebugUtils.gatherThreadDump(this, targetLogFolder, null);
        LOG.info("Gathering logs...");
        List<String> logFiles = Arrays.asList("karaf.log");
        DevDebugUtils.copyLogs(this, targetLogFolder, Paths.get("/opt", ALIAS, "data", "log"), logFiles);
        LOG.info("Log directory: {}", (Object)targetLogFolder.toUri());
        LOG.info("Console log: {}", (Object)targetLogFolder.resolve("container_stdout_stderr").toUri());
        if (threadDump != null) {
            LOG.info("Thread dump: {}", (Object)threadDump.toUri());
        }
    }

    public String getId() {
        return this.id;
    }

    public static class WaitForMinion
    extends AbstractWaitStrategy {
        private final MinionContainer container;

        public WaitForMinion(MinionContainer container) {
            this.container = Objects.requireNonNull(container);
        }

        protected void waitUntilReady() {
            LOG.info("Waiting for Minion health check...");
            RestHealthClient client = new RestHealthClient(this.container.getWebUrl(), Optional.of(MinionContainer.ALIAS));
            Awaitility.await((String)"waiting for good health check probe").atMost(5L, TimeUnit.MINUTES).pollInterval(10L, TimeUnit.SECONDS).failFast("container is no longer running", () -> !this.container.isRunning()).ignoreExceptionsMatching(e -> e.getCause() != null && e.getCause() instanceof SocketException).until(client::getProbeHealthResponse, CoreMatchers.containsString((String)client.getProbeSuccessMessage()));
            LOG.info("Health check passed.");
            this.container.assertNoKarafDestroy(Paths.get("/opt", MinionContainer.ALIAS, "data", "log", "karaf.log"));
        }
    }
}

