/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.smoketest.utils;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamGobbler
extends Thread {
    private static final Logger LOG = LoggerFactory.getLogger(StreamGobbler.class);
    private static final AtomicInteger counter = new AtomicInteger();
    private final InputStream stream;
    private final String kind;
    private final List<String> lines = new ArrayList<String>();

    public StreamGobbler(InputStream stream, String kind) {
        super("StreamGobbler-" + counter.incrementAndGet());
        this.stream = stream;
        this.kind = kind;
        this.setDaemon(true);
        this.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        try (InputStreamReader inputStreamReader2 = new InputStreamReader(this.stream);
             BufferedReader bufferedReader = new BufferedReader(inputStreamReader2);){
            String line;
            while ((line = bufferedReader.readLine()) != null) {
                LOG.debug(this.kind + ": " + line);
                List<String> list = this.lines;
                synchronized (list) {
                    this.lines.add(line);
                }
            }
        }
        catch (InterruptedIOException inputStreamReader2) {
        }
        catch (Throwable e) {
            LOG.error("error reading stream", e);
        }
        LOG.debug(this.kind + "<EOF>");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getLines() {
        List<String> list = this.lines;
        synchronized (list) {
            return new ArrayList<String>(this.lines);
        }
    }
}

